package immibis.chunkloader.porting;

/* $if mc == 1.2.5$ */

import immibis.chunkloader.mod_DimensionalAnchors;
import net.minecraft.src.forge.*;
import net.minecraft.src.*;
import java.util.Set;

public class ChunkLoadInterface125 extends ChunkLoadInterface implements IChunkLoadHandler {
	public ChunkLoadInterface125() {
		MinecraftForge.registerChunkLoadHandler(this);
	}
	
	@Override
	public boolean canUpdateEntity(Entity entity) {
		return mod_DimensionalAnchors.getWorld(entity.worldObj).isChunkForceLoaded(new ChunkCoordIntPair(entity.chunkCoordX, entity.chunkCoordZ));
	}
	
	@Override
	public boolean canUnloadChunk(Chunk chunk) {
		return !mod_DimensionalAnchors.getWorld(chunk.worldObj).isChunkForceLoaded(chunk.getChunkCoordIntPair());
	}
	
	@Override
	public void addActiveChunks(World world, Set<ChunkCoordIntPair> chunkList) {
		chunkList.addAll(mod_DimensionalAnchors.getWorld(world).getLoadedChunks());
	}
}

/* $endif$ */