package immibis.chunkloader;

import forge.Property;
import immibis.core.Config;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import net.minecraft.server.Block;
import net.minecraft.server.Item;

public class Fuels
{
    private static Property property;
    private static Map fuels = new HashMap();
    public static int SECONDS = 20;
    public static int MINUTES = 1200;
    public static int HOURS = 72000;
    private static Fuels.Key getKey = new Fuels.Key(0, 0);

    static void setProperty(Property var0)
    {
        property = var0;
        var0.comment = "comma-separated list of id:meta=number-of-ticks or id=number-of-ticks";

        if (var0.value.equals(""))
        {
            addDefaults();
            save();
        }
        else
        {
            try
            {
                String[] var4;
                int var3 = (var4 = var0.value.split(",")).length;

                for (int var2 = 0; var2 < var3; ++var2)
                {
                    String var1 = var4[var2];
                    String[] var5 = var1.split("=");
                    String[] var6 = var5[0].split(":");

                    if (var6.length == 1)
                    {
                        set(Integer.parseInt(var6[0]), Integer.parseInt(var5[1]));
                    }
                    else
                    {
                        set(Integer.parseInt(var6[0]), Integer.parseInt(var6[1]), Integer.parseInt(var5[1]));
                    }
                }
            }
            catch (Exception var7)
            {
                var7.printStackTrace();
                throw new RuntimeException("Invalid chunkloader fuel option in config");
            }
        }
    }

    private static void save()
    {
        StringBuilder var0 = new StringBuilder();
        Iterator var2 = fuels.entrySet().iterator();

        while (var2.hasNext())
        {
            Entry var1 = (Entry)var2.next();

            if (var0.length() > 0)
            {
                var0.append(',');
            }

            Fuels.Key var3 = (Fuels.Key)var1.getKey();
            var0.append(var3.id);

            if (var3.meta != 12345678)
            {
                var0.append(':');
                var0.append(var3.meta);
            }

            var0.append('=');
            var0.append(var1.getValue());
        }

        property.value = var0.toString();
        Config.save();
    }

    private static void addDefaults()
    {
        set(Item.COAL, 0, 10 * MINUTES);
        set(Item.COAL, 1, 1 * MINUTES);
        set(Item.REDSTONE, 1 * MINUTES);
        set(Item.ENDER_PEARL, 15 * MINUTES);
        set(Item.MAGMA_CREAM, 15 * MINUTES);
        set(Item.EYE_OF_ENDER, 30 * MINUTES);
        set(Block.DIRT, 1 * SECONDS);
        set(Block.COBBLESTONE, 1 * SECONDS);
        set(Block.STONE, 3 * SECONDS);
        set(Block.NETHERRACK, 4 * SECONDS);
        set(Block.NETHER_BRICK, 10 * SECONDS);
        set(Item.GLOWSTONE_DUST, 2 * MINUTES);
    }

    public static void set(int var0, int var1, int var2)
    {
        if (var2 <= 0)
        {
            fuels.remove(new Fuels.Key(var0, var1));
        }
        else
        {
            fuels.put(new Fuels.Key(var0, var1), Integer.valueOf(var2));
        }

        save();
    }

    public static void set(int var0, int var1)
    {
        if (var1 <= 0)
        {
            fuels.remove(new Fuels.Key(var0, 12345678));
        }
        else
        {
            fuels.put(new Fuels.Key(var0, 12345678), Integer.valueOf(var1));
        }

        save();
    }

    public static void set(Item var0, int var1, int var2)
    {
        set(var0.id, var1, var2);
    }

    public static void set(Item var0, int var1)
    {
        set(var0.id, var1);
    }

    public static void set(Block var0, int var1, int var2)
    {
        set(var0.id, var1, var2);
    }

    public static void set(Block var0, int var1)
    {
        set(var0.id, var1);
    }

    public static int get(int var0, int var1)
    {
        getKey.id = var0;
        getKey.meta = var1;
        Integer var2 = (Integer)fuels.get(getKey);

        if (var2 != null)
        {
            return var2.intValue();
        }
        else
        {
            getKey.meta = 12345678;
            var2 = (Integer)fuels.get(getKey);
            return var2 != null ? var2.intValue() : 0;
        }
    }

    static void addCommands()
    {
        mod_DimensionalAnchors.commands.put("setfuel", new Command()
        {
            public void invoke(CommandUser var1, String[] var2, int var3)
            {
                if (var2.length <= var3)
                {
                    var1.send("\u00a7cNot enough arguments.");
                }
                else
                {
                    String var4 = var2[var3++];

                    if (var2.length <= var3)
                    {
                        var1.send("\u00a7cNot enough arguments.");
                    }
                    else
                    {
                        String var5 = var2[var3++];
                        String var6 = "";

                        if (var2.length > var3)
                        {
                            var6 = var2[var3++];
                        }

                        int var9 = 0;
                        boolean var10 = false;
                        String[] var11 = var4.split(":");

                        if (var11.length != 1 && var11.length != 2)
                        {
                            var1.send("\u00a7cInvalid ID/metadata: " + var4);
                        }
                        else
                        {
                            int var7;
                            int var8;

                            try
                            {
                                var8 = Integer.parseInt(var11[0]);

                                if (var11.length > 1)
                                {
                                    var9 = Integer.parseInt(var11[1]);
                                    var10 = true;
                                }

                                var7 = Integer.parseInt(var5);
                            }
                            catch (NumberFormatException var12)
                            {
                                var1.send("\u00a7cInvalid number");
                                return;
                            }

                            if (var6.equals("sec"))
                            {
                                var7 *= 20;
                            }
                            else if (var6.equals("min"))
                            {
                                var7 *= 1200;
                            }
                            else if (var6.equals("hr"))
                            {
                                var7 *= 72000;
                            }
                            else if (!var6.equals(""))
                            {
                                var1.send("\u00a7cInvalid time unit: " + var6 + " - must be sec, min, hr or blank");
                                return;
                            }

                            if (var10)
                            {
                                Fuels.set(var8, var9, var7);
                            }
                            else
                            {
                                Fuels.set(var8, var7);
                            }

                            Fuels.save();
                            var1.send("\u00a7bChunk-loading time for " + (var10 ? var8 + ":" + var9 : String.valueOf(var8)) + " set to " + var7 + " ticks");
                            var1.send("\u00a7bThis will not affect currently burning items.");
                        }
                    }
                }
            }
            public String getUsage()
            {
                return "/dimanc setfuel <ID>[:<meta>] <time> [sec|min|hr] - use time=0 to remove a fuel";
            }
        });
        mod_DimensionalAnchors.commands.put("setpipemode", new Command()
        {
            public void invoke(CommandUser var1, String[] var2, int var3)
            {
                if (var2.length <= var3)
                {
                    var1.send("\u00a7cNot enough arguments.");
                }
                else
                {
                    String var4 = var2[var3++];
                    boolean var5;

                    if (var4.equals("allow"))
                    {
                        var5 = true;
                    }
                    else
                    {
                        if (!var4.equals("block"))
                        {
                            var1.send("\u00a7cInvalid mode: " + var4 + " - must be allow or block");
                            return;
                        }

                        var5 = false;
                    }

                    mod_DimensionalAnchors.allowFuelPiping = var5;

                    if (var5)
                    {
                        var1.send("\u00a7bFuel can now be inserted by pipes until the server restarts.");
                    }
                    else
                    {
                        var1.send("\u00a7bFuel cannot be inserted by pipes until the server restarts.");
                    }
                }
            }
            public String getUsage()
            {
                return "/dimanc setpipemode {allow|block} - temporarily sets whether fuel can be inserted by pipes";
            }
        });
    }

    private static class Key
    {
        public int id;
        public int meta;
        public static final int ANY_META = 12345678;

        public boolean equals(Object var1)
        {
            if (var1 instanceof Fuels.Key)
            {
                Fuels.Key var2 = (Fuels.Key)var1;
                return var2.id == this.id && var2.meta == this.meta;
            }
            else
            {
                return false;
            }
        }

        public String toString()
        {
            return this.meta == 12345678 ? String.valueOf(this.id) : this.id + ":" + this.meta;
        }

        public int hashCode()
        {
            return this.id + this.meta * 4097;
        }

        public Key(int var1, int var2)
        {
            this.id = var1;
            this.meta = var2;
        }
    }
}
