package immibis.chunkloader;

import immibis.core.BasicInventory;
import immibis.core.api.porting.SidedProxy;
import immibis.core.net.AbstractSyncedContainer;
import immibis.core.net.IPacket;
import java.util.Iterator;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ICrafting;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Slot;

public class ContainerChunkLoader extends AbstractSyncedContainer
{
    public EntityHuman player;
    public TileChunkLoader tile;
    public final boolean useFuel;
    private String lastOwner = null;
    private int lastMaxQuota = -1;
    private int lastCurQuota = -1;
    private int lastRadius = -2;
    private boolean lastAmIOp;
    private boolean lastServerOwned;
    public boolean ownedByMe;
    public boolean amIOp;
    private int maxQuota;
    private int curQuota;
    private int lastScaledFuelTime;
    private int lastMaxFuelTime;

    public ContainerChunkLoader(EntityHuman var1, TileChunkLoader var2, boolean var3)
    {
        super(var1, var2);
        this.player = var1;
        this.tile = var2;
        this.useFuel = var3;

        if (var3)
        {
            int var4;

            for (var4 = 0; var4 < 9; ++var4)
            {
                this.a(new Slot(var1.inventory, var4, 13 + 18 * var4, 178));
            }

            for (var4 = 0; var4 < 3; ++var4)
            {
                for (int var5 = 0; var5 < 9; ++var5)
                {
                    this.a(new Slot(var1.inventory, var5 + var4 * 9 + 9, 13 + 18 * var5, 120 + 18 * var4));
                }
            }

            this.a(new Slot(var2, 0, 192, 48));
        }
    }

    /**
     * Called to transfer a stack from one inventory to the other eg. when shift clicking.
     */
    public ItemStack a(int var1)
    {
        if (var1 < 36)
        {
            BasicInventory.mergeStackIntoRange(this.player.inventory, this.tile, var1, 0, 1);
        }
        else
        {
            BasicInventory.mergeStackIntoRange(this.tile, this.player.inventory, 0, 0, 36);
        }

        return null;
    }

    public boolean canEdit()
    {
        return this.tile.owner != null && (this.ownedByMe && !this.tile.isServerOwned || this.amIOp);
    }

    public void onButtonPressed(int var1)
    {
        if (this.canEdit())
        {
            if (var1 == 3)
            {
                if (this.tile.radius > 0)
                {
                    --this.tile.radius;
                    this.tile.loaderChanged(this.player.name);
                }
            }
            else if (var1 == 4)
            {
                if (this.tile.radius < 4)
                {
                    ++this.tile.radius;
                    this.tile.loaderChanged(this.player.name);
                    this.tile.loadChunks();
                }
            }
            else if (var1 == 5 && this.amIOp)
            {
                this.tile.isServerOwned = !this.tile.isServerOwned;

                if (!this.tile.isServerOwned)
                {
                    this.tile.owner = this.player.name;
                }

                this.tile.loaderChanged(this.player.name);
            }
        }
    }

    public int getMaxQuota()
    {
        return this.tile.world.isStatic ? this.maxQuota : (this.tile.owner == null ? 0 : mod_DimensionalAnchors.instance.getMaxQuota(this.tile.owner));
    }

    public int getCurQuota()
    {
        return this.tile.world.isStatic ? this.curQuota : (this.tile.owner == null ? 0 : mod_DimensionalAnchors.instance.getCurQuota(this.tile.owner));
    }

    public void updateFields()
    {
        this.maxQuota = this.getMaxQuota();
        this.curQuota = this.getCurQuota();
        this.ownedByMe = this.tile.owner != null && this.tile.owner.equals(this.player.name);
        this.amIOp = SidedProxy.instance.isOp(this.player.name);
    }

    /**
     * Updates crafting matrix; called from onCraftMatrixChanged. Args: none
     */
    public void a()
    {
        super.a();
        this.updateFields();

        if (this.lastMaxFuelTime != 14)
        {
            this.lastMaxFuelTime = 14;
            Iterator var2 = this.listeners.iterator();

            while (var2.hasNext())
            {
                ICrafting var1 = (ICrafting)var2.next();
                var1.setContainerData(this, 0, this.lastMaxFuelTime);
            }
        }

        int var4 = this.tile.getScaledFuelTime(this.lastMaxFuelTime);

        if (this.lastScaledFuelTime != var4)
        {
            this.lastScaledFuelTime = var4;
            Iterator var3 = this.listeners.iterator();

            while (var3.hasNext())
            {
                ICrafting var5 = (ICrafting)var3.next();
                var5.setContainerData(this, 1, var4);
            }
        }

        if (this.lastOwner != this.tile.owner || this.lastMaxQuota != this.maxQuota || this.lastCurQuota != this.curQuota || this.lastRadius != this.tile.radius || this.lastAmIOp != this.amIOp || this.lastServerOwned != this.tile.isServerOwned)
        {
            PacketGUIUpdate var6 = new PacketGUIUpdate(this.tile.owner == null ? "" : this.tile.owner, this.curQuota, this.maxQuota, this.tile.radius, this.amIOp, this.tile.isServerOwned);
            this.sendUpdatePacket(var6);
            this.lastOwner = this.tile.owner;
            this.lastCurQuota = this.curQuota;
            this.lastMaxQuota = this.maxQuota;
            this.lastRadius = this.tile.radius;
            this.lastAmIOp = this.amIOp;
            this.lastServerOwned = this.tile.isServerOwned;
        }
    }

    public void onUpdatePacket(IPacket var1)
    {
        if (var1 instanceof PacketGUIUpdate)
        {
            PacketGUIUpdate var2 = (PacketGUIUpdate)var1;
            this.tile.owner = var2.owner.equals("") ? null : var2.owner;
            this.tile.radius = var2.radius;
            this.curQuota = var2.curQuota;
            this.maxQuota = var2.maxQuota;
            this.amIOp = var2.amIOp;
            this.tile.isServerOwned = var2.isServerOwned;
            this.ownedByMe = this.tile.owner != null && this.tile.owner.equals(this.player.name);
        }
    }

    public String getChannel()
    {
        return "immibis.chunkldr";
    }
}
