package immibis.tubestuff;

/* $if client2$ */
import net.minecraft.client.Minecraft;
/* $endif$ */
/* $if server2$ */
import net.minecraft.server.MinecraftServer;
/* $endif$ */
import net.minecraft.src.*;
import net.minecraft.src.forge.*;
/* $if mc >= 1.3$ */
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
/* $endif$ */
import ic2.api.Ic2Recipes;
import immibis.core.*;
import immibis.core.api.IBlockIDCallback;
import immibis.core.api.IDAllocator;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.api.porting.SidedProxy;

public class mod_TubeStuff extends PortableBaseMod {
	public static mod_TubeStuff instance;
	public static BlockTubestuff block;
	public static BlockStorage blockStorage;
	public static Item itemUseless;
	
	private static EntityPlayerFakeTS fakePlayer;
	
	public static final int GUI_BUFFER = 0;
	public static final int GUI_TABLE = 1;
	public static final int GUI_CHEST = 2;
	public static final int GUI_LOGICCRAFTER = 3;
	public static final int GUI_RETRIEVULATOR = 4;
	public static final int GUI_DUPLICATOR = 5;
	
	public static EntityPlayerFakeTS fakePlayer(World world) {
		if(fakePlayer == null)
			fakePlayer = new EntityPlayerFakeTS(world);
		return fakePlayer;
	}
	
	public mod_TubeStuff() {
		instance = this;
	}
	
	public String getPriorities() {
		return "after:mod_ImmibisCore";
	}

	@Override
	public String getVersion() {
		return ModInfoReader.getModInfoField("/immibis/tubestuff/mod_TubeStuff.info.txt", "version");
	}
	
	private boolean hadFirstTick = false;
	@Override
	public boolean onTickInGame() {
		if(!hadFirstTick) {
			SharedProxy.FirstTick();
			hadFirstTick = true;
		}
		return false;
	}

	@Override
	public void load() {
		BlockTubestuff.model = SidedProxy.instance.getUniqueBlockModelID("immibis.tubestuff.BlockRenderer", true);
		
		enableClockTicks(true);
		
		SidedProxy.instance.setGuiHandler(this, new PortableGuiHandler() {
			
			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity tile = world.getBlockTileEntity(x, y, z);
				switch(ID) {
				case GUI_BUFFER:
					return new ContainerChest(player.inventory, (TileBuffer)tile);
				case GUI_TABLE:
					return new ContainerAutoCraftingMk2(player, (TileAutoCraftingMk2)tile);
				case GUI_CHEST:
					return new ContainerBlackHoleChest(player, (TileBlackHoleChest)tile);
				case GUI_LOGICCRAFTER:
					return new ContainerLogicCrafter(player, (TileLogicCrafter)tile);
				case GUI_DUPLICATOR:
					return new ContainerOneSlot(player, ((TileDuplicator)tile).getGuiInventory());
				case GUI_RETRIEVULATOR:
					return new ContainerRetrievulator(player, (TileRetrievulator)tile);
				}
				return null;
			}
			
			/* $if jclient$ */
			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity tile = world.getBlockTileEntity(x, y, z);
				switch(ID) {
				case GUI_BUFFER:
					return new GuiChest(player.inventory, (TileBuffer)tile);
				case GUI_TABLE:
					return new GuiAutoCraftingMk2(player, (TileAutoCraftingMk2)tile);
				case GUI_CHEST:
					return new GuiBlackHoleChest(player, (TileBlackHoleChest)tile);
				case GUI_LOGICCRAFTER:
					return new GuiLogicCrafter(player, (TileLogicCrafter)tile);
				case GUI_DUPLICATOR:
					return new GuiOneSlot(new ContainerOneSlot(player, ((TileDuplicator)tile).getGuiInventory()), "Duplicator");
				case GUI_RETRIEVULATOR:
					return new GuiRetrievulator(player, (TileRetrievulator)tile);
				}
				return null;
			}
			/* $endif$ */
		});
		
		IDAllocator.RegisterBlockID("tubestuff", new IBlockIDCallback() {
			@Override
			public void registerBlock(int id) {
				block = new BlockTubestuff(id);
				ModLoader.registerBlock(block, ItemTubestuff.class);
				ModLoader.registerTileEntity(TileBuffer.class, "TubeStuff buffer");
				ModLoader.registerTileEntity(TileAutoCraftingMk2.class, "TubeStuff crafting table");
				ModLoader.registerTileEntity(TileLogicCrafter.class, "TubeStuff logic crafter");
				ModLoader.registerTileEntity(TileRetrievulator.class, "TubeStuff retrievulator");
				ModLoader.registerTileEntity(TileIncinerator.class, "TubeStuff incinerator");
				ModLoader.registerTileEntity(TileDuplicator.class, "TubeStuff duplicator");
				SidedProxy.instance.registerTileEntity(TileBlackHoleChest.class, "TubeStuff infinite chest", "immibis.tubestuff.RenderTileBlackHoleChest");
			}
		});
		
		SharedProxy.enableStorageBlocks = Config.getBoolean("tubestuff.enableStorageBlocks", true);
		SharedProxy.enableStorageBlocksVanilla = Config.getBoolean("tubestuff.enableStorageBlocks.vanilla", true);
		
		if(SharedProxy.enableStorageBlocks) {
			IDAllocator.RegisterBlockID("tubestuff.storage", new IBlockIDCallback() {
				
				@Override
				public void registerBlock(int id) {
					blockStorage = new BlockStorage(id);
					ModLoader.registerBlock(blockStorage, ItemStorage.class);
				}
			});
		}
		
		itemUseless = (new ItemTS(Config.getItemID("tubestuff.uselessItem", 7614)-256));
		itemUseless.setTextureFile("/immibis/tubestuff/blocks.png");
		itemUseless.setItemName("tubestuff.uselessItem");
		itemUseless.setIconIndex(5);
		itemUseless.setMaxStackSize(1);
		ModLoader.addName(itemUseless, "Retriever jammer");
		
		/* $if mc < 1.3$
		MinecraftForge.registerPickupHandler(new IPickupHandler() {
			@Override
			public boolean onItemPickup(EntityPlayer player, EntityItem item) {
				if(item.item != null && item.item.stackSize > 0 && item.item.itemID == itemUseless.shiftedIndex) {
					// Players do not collect retriever jammers
					item.setDead();
					return false;
				}
				return true;
			}
		});
		$else$ */
		MinecraftForge.EVENT_BUS.register(this);
		/* $endif$ */
		
		try {
			Ic2Recipes.addRecyclerBlacklistItem(itemUseless);
		} catch(Throwable e) {
			
		}
	}
	
	public static final boolean areItemsEqual(ItemStack recipe, ItemStack input)
	{
		return input.itemID == recipe.itemID && (!input.getHasSubtypes() || input.getItemDamage() == recipe.getItemDamage());
	}
	
	/* $if mc > 1.3$ */
	@ForgeSubscribe
	public void onPickup(EntityItemPickupEvent evt) {
		if(evt.item.item != null && evt.item.item.stackSize > 0 && evt.item.item.itemID == itemUseless.shiftedIndex) {
			evt.item.setDead();
			evt.setCanceled(true);
		}
	}
	/* $endif$ */
}
