package immibis.tubestuff;

import immibis.core.api.porting.SidedProxy;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;

public class ItemStorage extends ItemBlock {
	public ItemStorage(int id_minus_256) {
		super(id_minus_256);
		
		setMaxDamage(0);
	    setHasSubtypes(true);
	    
	    SidedProxy.instance.addLocalization("tubestuff.storage.0.name", "Silver block");
	    SidedProxy.instance.addLocalization("tubestuff.storage.1.name", "Tin block");
	    SidedProxy.instance.addLocalization("tubestuff.storage.2.name", "Copper block");
	    SidedProxy.instance.addLocalization("tubestuff.storage.3.name", "Nikolite block");
	    SidedProxy.instance.addLocalization("tubestuff.storage.4.name", "Coal block");
	    SidedProxy.instance.addLocalization("tubestuff.storage.5.name", "Redstone block");
	    SidedProxy.instance.addLocalization("tubestuff.storage.6.name", "Blue alloy block");
	    SidedProxy.instance.addLocalization("tubestuff.storage.7.name", "Red alloy block");
	    SidedProxy.instance.addLocalization("tubestuff.storage.8.name", "Brass block");
	}
	
	@Override
    public int getMetadata(int meta) {
        return meta;
    }
	
	@Override
	public String getItemNameIS(ItemStack s) {
		return "tubestuff.storage."+s.getItemDamage();
	}
}
