package immibis.tubestuff;

import immibis.core.BasicInventory;
import immibis.core.BlockCombined;
import immibis.core.TileBasicInventory;
import immibis.core.TileCombined;
import immibis.core.api.Dir;
import immibis.core.aspects.ClientOnly;

import java.util.ArrayList;
import java.util.Random;

import net.minecraft.src.*;

public class BlockTubestuff extends BlockCombined {
	public BlockTubestuff(int i) {
		super(i, Material.iron, "/immibis/tubestuff/blocks.png");
		setHardness(2.0F);
		
		//if(NonSharedProxy.CLIENT)
			setTickRandomly(true);
	}
	
	public static int model;
	
	@Override
	public boolean renderAsNormalBlock() {
		return false;
	}
	
	@Override
	public int getRenderType() {
		return model;
	}
	
	/* $if jclient$ */
	@Override @ClientOnly
	public void randomDisplayTick(World world, int x, int y, int z, Random random)
	{
	    int meta = world.getBlockMetadata(x, y, z);
	    
	    if(meta == 2)
	    {
	    	if(SharedProxy.enableBHCParticles)
	    	{
		    	for(int k = 0; k < 1 + world.rand.nextInt(3); k++)
		    	{
		    		EntityFX fx = new EntityBlackHoleFX(world, x + 0.5, y + 0.5, z + 0.5); 
		    		ModLoader.getMinecraftInstance().effectRenderer.addEffect(fx);
		    	}
	    	}
	    }
	}
	/* $endif$ */
	
	@Override
	public TileEntity getBlockEntity(int data)
	{
		if(data == 0)
			return new TileBuffer();
		else if(data == 1)
			return new TileAutoCraftingMk2();
		else if(data == 2)
			return new TileBlackHoleChest();
		/*else if(data == 3)
			return new TileLogicCrafter();*/
		else if(data == 3)
			return new TileIncinerator();
		else if(data == 4)
			return new TileDuplicator();
		else if(data == 5)
			return new TileRetrievulator();
		else
			return null;
	}
	
	@Override
	public int getBlockTextureFromSideAndMetadata(int side, int data)
	{
		int index = 0;
		if(data == 0) {
			// buffer
			return 3;
		} else if(data == 1) {
			// auto crafting table mk2
			if(side == 0)
				return 1;
			else if(side == 1)
				return 0;
			else
				return 2;
		} else if(data == 2) {
			// black hole chest
			return 4;
		/*} else if(data == 3) {
			// logic crafter
			return 5;*/
		} else if(data == 3) {
			// incinerator
			return (side == Dir.PY ? 7 : side == Dir.NY ? 1 : 6);
		} else if(data == 4) {
			// duplicator
			return 8;
		} else if(data == 5) {
			// retrievulator
			return (side == Dir.PY ? 9 : 10);
		}
		return 0; // unknown
	}
	
	public int getBlockTexture(IBlockAccess w, int x, int y, int z, int side) {
		int meta = w.getBlockMetadata(x, y, z);
		if(meta == 5) {
			// retrievulator
			TileRetrievulator te = (TileRetrievulator)w.getBlockTileEntity(x, y, z);
			if(side == te.outputFace)
				return 11;
			else if(side == (te.outputFace ^ 1))
				return 9;
			else
				return 10;
		} else {
			return getBlockTextureFromSideAndMetadata(side, meta);
		}
	}
	
	@Override
    public void addCreativeItems(ArrayList arraylist)
    {
		arraylist.add(new ItemStack(this, 1, 0));
		arraylist.add(new ItemStack(this, 1, 1));
		arraylist.add(new ItemStack(this, 1, 2));
		arraylist.add(new ItemStack(this, 1, 3));
		arraylist.add(new ItemStack(this, 1, 4));
		arraylist.add(new ItemStack(this, 1, 5));
    }
}
