package immibis.tubestuff;

import forge.IPickupHandler;
import forge.MinecraftForge;
import ic2.api.Ic2Recipes;
import immibis.core.Config;
import immibis.core.ModInfoReader;
import immibis.core.api.IBlockIDCallback;
import immibis.core.api.IDAllocator;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.api.porting.SidedProxy;
import net.minecraft.server.ContainerChest;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ModLoader;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class mod_TubeStuff extends PortableBaseMod
{
    public static mod_TubeStuff instance;
    public static BlockTubestuff block;
    public static BlockStorage blockStorage;
    public static Item itemUseless;
    private static EntityPlayerFakeTS fakePlayer;
    public static final int GUI_BUFFER = 0;
    public static final int GUI_TABLE = 1;
    public static final int GUI_CHEST = 2;
    public static final int GUI_LOGICCRAFTER = 3;
    public static final int GUI_RETRIEVULATOR = 4;
    public static final int GUI_DUPLICATOR = 5;
    private boolean hadFirstTick = false;

    public static EntityPlayerFakeTS fakePlayer(World var0)
    {
        if (fakePlayer == null)
        {
            fakePlayer = new EntityPlayerFakeTS(var0);
        }

        return fakePlayer;
    }

    public mod_TubeStuff()
    {
        instance = this;
    }

    public String getPriorities()
    {
        return "after:mod_ImmibisCore";
    }

    public String getVersion()
    {
        return ModInfoReader.getModInfoField("/immibis/tubestuff/mod_TubeStuff.info.txt", "version");
    }

    public boolean onTickInGame()
    {
        if (!this.hadFirstTick)
        {
            SharedProxy.FirstTick();
            this.hadFirstTick = true;
        }

        return false;
    }

    public void load()
    {
        BlockTubestuff.model = SidedProxy.instance.getUniqueBlockModelID("immibis.tubestuff.BlockRenderer", true);
        this.enableClockTicks(true);
        SidedProxy.instance.setGuiHandler(this, new PortableGuiHandler()
        {
            public Object getServerGuiElement(int var1, EntityHuman var2, World var3, int var4, int var5, int var6)
            {
                TileEntity var7 = var3.getTileEntity(var4, var5, var6);

                switch (var1)
                {
                    case 0:
                        return new ContainerChest(var2.inventory, (TileBuffer)var7);

                    case 1:
                        return new ContainerAutoCraftingMk2(var2, (TileAutoCraftingMk2)var7);

                    case 2:
                        return new ContainerBlackHoleChest(var2, (TileBlackHoleChest)var7);

                    case 3:
                        return new ContainerLogicCrafter(var2, (TileLogicCrafter)var7);

                    case 4:
                        return new ContainerRetrievulator(var2, (TileRetrievulator)var7);

                    case 5:
                        return new ContainerOneSlot(var2, ((TileDuplicator)var7).getGuiInventory());

                    default:
                        return null;
                }
            }
        });
        IDAllocator.RegisterBlockID("tubestuff", new IBlockIDCallback()
        {
            public void registerBlock(int var1)
            {
                mod_TubeStuff.block = new BlockTubestuff(var1);
                ModLoader.registerBlock(mod_TubeStuff.block, ItemTubestuff.class);
                ModLoader.registerTileEntity(TileBuffer.class, "TubeStuff buffer");
                ModLoader.registerTileEntity(TileAutoCraftingMk2.class, "TubeStuff crafting table");
                ModLoader.registerTileEntity(TileLogicCrafter.class, "TubeStuff logic crafter");
                ModLoader.registerTileEntity(TileRetrievulator.class, "TubeStuff retrievulator");
                ModLoader.registerTileEntity(TileIncinerator.class, "TubeStuff incinerator");
                ModLoader.registerTileEntity(TileDuplicator.class, "TubeStuff duplicator");
                SidedProxy.instance.registerTileEntity(TileBlackHoleChest.class, "TubeStuff infinite chest", "immibis.tubestuff.RenderTileBlackHoleChest");
            }
        });
        SharedProxy.enableStorageBlocks = Config.getBoolean("tubestuff.enableStorageBlocks", true);
        SharedProxy.enableStorageBlocksVanilla = Config.getBoolean("tubestuff.enableStorageBlocks.vanilla", true);

        if (SharedProxy.enableStorageBlocks)
        {
            IDAllocator.RegisterBlockID("tubestuff.storage", new IBlockIDCallback()
            {
                public void registerBlock(int var1)
                {
                    mod_TubeStuff.blockStorage = new BlockStorage(var1);
                    ModLoader.registerBlock(mod_TubeStuff.blockStorage, ItemStorage.class);
                }
            });
        }

        itemUseless = new ItemTS(Config.getItemID("tubestuff.uselessItem", 7614) - 256);
        itemUseless.a("tubestuff.uselessItem");
        itemUseless.d(5);
        itemUseless.e(1);
        ModLoader.addName(itemUseless, "Retriever jammer");
        MinecraftForge.registerPickupHandler(new IPickupHandler()
        {
            public boolean onItemPickup(EntityHuman var1, EntityItem var2)
            {
                if (var2.itemStack != null && var2.itemStack.count > 0 && var2.itemStack.id == mod_TubeStuff.itemUseless.id)
                {
                    var2.die();
                    return false;
                }
                else
                {
                    return true;
                }
            }
        });

        try
        {
            Ic2Recipes.addRecyclerBlacklistItem(itemUseless);
        }
        catch (Throwable var1)
        {
            ;
        }
    }

    public static final boolean areItemsEqual(ItemStack var0, ItemStack var1)
    {
        return var1.id == var0.id && (!var1.usesData() || var1.getData() == var0.getData());
    }
}
