package immibis.tubestuff;

import forge.ISidedInventory;
import immibis.core.BasicInventory;
import immibis.core.TileBasicInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NetworkManager;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet132TileEntityData;
import net.minecraft.server.TileEntity;

public class TileRetrievulator extends TileBasicInventory implements ISidedInventory
{
    public int outputFace;
    private int ticksSinceItemPassed = 0;
    private int pulseInterval = 10;
    private int ticksToNextPulse = 0;
    private boolean incorrectSetup = true;
    private boolean needAnyItems = false;
    public static final int SLOT_RETRIEVER_SETUP = 0;
    public static final int SLOT_TARGET = 9;
    public static final int SLOT_BUFFER = 18;
    private int updateTicks = 0;
    private TileEntity retriever;
    private IInventory target;
    private int targetSlotsStart;
    private int targetSlotsEnd;

    public List getInventoryDrops()
    {
        ArrayList var1 = new ArrayList();

        for (int var2 = 0; var2 < 9; ++var2)
        {
            this.dropStack(var2 + 0, var1);
        }

        this.dropStack(18, var1);
        return var1;
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("outputFace", this.outputFace);
        var1.setInt("itemTicks", this.ticksSinceItemPassed);
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.outputFace = var1.getInt("outputFace");
        this.ticksSinceItemPassed = var1.getInt("itemTicks");
    }

    public void onDataPacket(NetworkManager var1, Packet132TileEntityData var2)
    {
        this.outputFace = var2.d;
        this.world.notify(this.x, this.y, this.z);
    }

    /**
     * Overriden in a sign to provide the text
     */
    public Packet d()
    {
        Packet132TileEntityData var1 = new Packet132TileEntityData();
        var1.d = this.outputFace;
        var1.a = this.x;
        var1.b = this.y;
        var1.c = this.z;
        var1.lowPriority = true;
        return var1;
    }

    public TileRetrievulator()
    {
        super(19, "Retrievulator");
    }

    public void onPlaced(EntityLiving var1, int var2)
    {
        this.outputFace = var2;
    }

    private TileEntity getTarget(int var1)
    {
        int var2 = this.x;
        int var3 = this.y;
        int var4 = this.z;

        switch (var1)
        {
            case 0:
                --var3;
                break;

            case 1:
                ++var3;
                break;

            case 2:
                --var4;
                break;

            case 3:
                ++var4;
                break;

            case 4:
                --var2;
                break;

            case 5:
                ++var2;
        }

        return this.world.getTileEntity(var2, var3, var4);
    }

    public void onBlockNeighbourChange()
    {
        this.updateTicks = 0;
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (this.updateTicks <= 0)
            {
                this.updateTicks = 20;
                TileEntity var1 = this.getTarget(this.outputFace);
                this.retriever = this.getTarget(this.outputFace ^ 1);

                if (this.retriever != null && !this.isValidRetrieverClass(this.retriever.getClass().getName()))
                {
                    this.retriever = null;
                }

                if (!(var1 instanceof IInventory))
                {
                    this.target = null;
                }
                else
                {
                    this.target = (IInventory)var1;
                }
            }

            --this.updateTicks;

            if (this.target != null && this.retriever != null)
            {
                if (this.target instanceof ISidedInventory)
                {
                    ISidedInventory var3 = (ISidedInventory)this.target;
                    int var2 = this.outputFace ^ 1;
                    this.targetSlotsStart = var3.getStartInventorySide(var2);
                    this.targetSlotsEnd = this.targetSlotsStart + var3.getSizeInventorySide(var2);
                }
                else
                {
                    this.targetSlotsStart = 0;
                    this.targetSlotsEnd = this.target.getSize();
                }

                if (this.inv.contents[18] != null)
                {
                    BasicInventory.mergeStackIntoRange(this.inv, this.target, 18, this.targetSlotsStart, this.targetSlotsEnd);

                    if (this.inv.contents[18] != null)
                    {
                        return;
                    }

                    this.shuffleInventories();
                    this.ticksSinceItemPassed = 0;
                }
                else
                {
                    ++this.ticksSinceItemPassed;
                }

                if (this.ticksToNextPulse == 0)
                {
                    if (!this.redstone_output)
                    {
                        this.shuffleInventories();
                    }

                    boolean var4 = this.redstone_output;

                    if (!this.needAnyItems)
                    {
                        this.redstone_output = false;
                    }
                    else
                    {
                        this.redstone_output = !this.redstone_output;
                    }

                    if (this.redstone_output != var4)
                    {
                        this.notifyNeighbouringBlocks();
                        this.world.notify(this.retriever.x, this.retriever.y, this.retriever.z);
                    }

                    if (!this.redstone_output)
                    {
                        this.pulseInterval = this.calcPulseInterval();
                        this.ticksToNextPulse = this.pulseInterval;
                    }
                    else
                    {
                        this.ticksToNextPulse = 10;
                    }
                }
                else
                {
                    --this.ticksToNextPulse;
                }
            }
        }
    }

    private int calcPulseInterval()
    {
        boolean var10000 = true;
        var10000 = true;
        return Math.min(400, Math.max(10, this.ticksSinceItemPassed / 3));
    }

    private void shuffleInventories()
    {
        this.incorrectSetup = false;
        this.needAnyItems = false;
        IInventory var1 = (IInventory)this.retriever;

        for (int var2 = 0; var2 < 9; ++var2)
        {
            boolean var3 = var1.getItem(var2) != null && var1.getItem(var2).id != mod_TubeStuff.itemUseless.id;
            boolean var4 = this.inv.contents[0 + var2] != null;

            if (this.inv.contents[9 + var2] == null)
            {
                this.incorrectSetup |= var3;
            }
            else if (!this.checkTarget(this.targetSlotsStart, this.targetSlotsEnd, this.target, this.inv.contents[9 + var2]))
            {
                if (var4 && !var3)
                {
                    var1.setItem(var2, this.getItem(0 + var2));
                    this.setItem(0 + var2, (ItemStack)null);
                }
                else if (var4 || !var3)
                {
                    this.incorrectSetup = true;
                }

                this.needAnyItems = true;
            }
            else if (var3 && !var4)
            {
                this.setItem(0 + var2, var1.getItem(var2));
                var1.setItem(var2, (ItemStack)null);
            }
            else if (!var4 || var3)
            {
                this.incorrectSetup = true;
            }
        }

        if (!this.incorrectSetup)
        {
            ItemStack var5 = var1.getItem(0);

            if (this.needAnyItems)
            {
                if (var5 != null && var5.id == mod_TubeStuff.itemUseless.id)
                {
                    var1.setItem(0, (ItemStack)null);
                }
            }
            else if (var5 == null)
            {
                var1.setItem(0, new ItemStack(mod_TubeStuff.itemUseless, 1, 0));
            }
        }
    }

    private boolean isValidRetrieverClass(String var1)
    {
        return var1.equals("eloraam.machine.TileRetriever") ? true : var1.equals("eloraam.machine.TileFilter");
    }

    private boolean checkTarget(int var1, int var2, IInventory var3, ItemStack var4)
    {
        if (var4 == null)
        {
            return true;
        }
        else
        {
            int var5 = var4.count;

            for (int var6 = var1; var6 < var2 && var5 > 0; ++var6)
            {
                ItemStack var7 = var3.getItem(var6);

                if (var7 != null && mod_TubeStuff.areItemsEqual(var4, var7))
                {
                    var5 -= var7.count;
                }
            }

            return var5 <= 0;
        }
    }

    public int getStartInventorySide(int var1)
    {
        return 18;
    }

    public int getSizeInventorySide(int var1)
    {
        return 1;
    }

    public boolean onBlockActivated(EntityHuman var1)
    {
        if (this.world.isStatic)
        {
            return true;
        }
        else
        {
            ItemStack var2 = var1.U();

            if (RedPowerItems.useScrewdriver(var2))
            {
                this.outputFace = (this.outputFace + 1) % 6;
                this.resendDescriptionPacket();
                return true;
            }
            else
            {
                var1.openGui(mod_TubeStuff.instance, 4, this.world, this.x, this.y, this.z);
                return true;
            }
        }
    }
}
