package immibis.tubestuff;

import immibis.core.Config;
import immibis.core.config.ExtendedForgeConfigReader;
import immibis.core.config.IConfigReader;
import java.io.IOException;
import net.minecraft.server.Block;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ModLoader;

public class SharedProxy
{
    public static final boolean DEBUG_MODE = mod_TubeStuff.class.getName().equals("net.minecraft.server.mod_TubeStuff");
    public static boolean enableBHCParticles;
    public static boolean enableBHC;
    public static boolean enableBHCAnim;
    public static boolean enableCraftingIncinerator;
    public static boolean enableCraftingRetrievulator;
    public static boolean enableStorageBlocks;
    public static boolean enableStorageBlocksVanilla;
    public static IConfigReader redpowerConfig = null;

    static boolean CC_CheckArgs(Object[] var0, Class[] var1)
    {
        if (var0.length != var1.length)
        {
            return false;
        }
        else
        {
            for (int var2 = 0; var2 < var0.length; ++var2)
            {
                if (var0[var2].getClass() != var1[var2])
                {
                    return false;
                }
            }

            return true;
        }
    }

    private static Class findClass(String var0)
    {
        try
        {
            return SharedProxy.class.getClassLoader().loadClass("net.minecraft.server." + var0);
        }
        catch (ClassNotFoundException var2)
        {
            try
            {
                return SharedProxy.class.getClassLoader().loadClass(var0);
            }
            catch (ClassNotFoundException var1)
            {
                return null;
            }
        }
    }

    public static void FirstTick()
    {
        boolean var0 = true;
        int var1 = -1;
        int var2 = -1;
        boolean var3 = true;
        int var4 = -1;
        int var14;
        int var15;

        try
        {
            ExtendedForgeConfigReader var5 = new ExtendedForgeConfigReader("redpower/redpower.cfg");
            redpowerConfig = var5;

            try
            {
                var14 = Integer.parseInt(var5.getConfigEntry("blocks.machine.machine.id"));

                if (!Block.byId[var14].getClass().getName().equals("eloraam.machine.BlockMachine"))
                {
                    var14 = -1;
                }
            }
            catch (Exception var12)
            {
                System.out.println(mod_TubeStuff.class.getSimpleName() + ": RP2 Machine doesn\'t seem to be installed");
                var14 = -1;
            }

            try
            {
                var15 = Integer.parseInt(var5.getConfigEntry("blocks.logic.logic.id"));

                if (!Block.byId[var15].getClass().getName().equals("eloraam.logic.BlockLogic"))
                {
                    var15 = -1;
                }
            }
            catch (Exception var11)
            {
                System.out.println(mod_TubeStuff.class.getSimpleName() + ": RP2 Logic doesn\'t seem to be installed");
                var15 = -1;
            }
        }
        catch (IOException var13)
        {
            System.out.println(mod_TubeStuff.class.getSimpleName() + ": RP2 doesn\'t seem to be installed");
            var15 = -1;
            var14 = -1;
        }

        Class var16;

        try
        {
            var16 = findClass("BuildCraftTransport");

            if (var16 != null)
            {
                var1 = ((Item)var16.getDeclaredField("pipeItemsWood").get((Object)null)).id;
            }
        }
        catch (Exception var10)
        {
            System.out.println(mod_TubeStuff.class.getSimpleName() + ": BC Transport doesn\'t seem to be installed");
        }

        try
        {
            var16 = findClass("BuildCraftEnergy");

            if (var16 != null)
            {
                var2 = ((Block)var16.getDeclaredField("engineBlock").get((Object)null)).id;
            }
        }
        catch (Exception var9)
        {
            System.out.println(mod_TubeStuff.class.getSimpleName() + ": BC Energy doesn\'t seem to be installed");
        }

        try
        {
            var16 = findClass("BuildCraftFactory");

            if (var16 != null)
            {
                var4 = ((Block)var16.getDeclaredField("autoWorkbenchBlock").get((Object)null)).id;
            }
        }
        catch (Exception var8)
        {
            System.out.println(mod_TubeStuff.class.getSimpleName() + ": BC Factory doesn\'t seem to be installed");
        }

        ItemStack var17 = new ItemStack(mod_TubeStuff.block, 1, 0);
        ItemStack var6 = new ItemStack(mod_TubeStuff.block, 1, 1);
        ItemStack var7 = new ItemStack(mod_TubeStuff.block, 1, 2);

        if (var14 != -1)
        {
            if (var15 != -1)
            {
                ModLoader.addShapelessRecipe(var17, new Object[] {new ItemStack(var14, 1, 3), Block.CHEST, new ItemStack(var15, 1, 0)});
            }
            else
            {
                ModLoader.addShapelessRecipe(var17, new Object[] {new ItemStack(var14, 1, 3), Block.CHEST});
            }

            ModLoader.addRecipe(var6, new Object[] {"GFG", "WCW", "WcW", 'F', new ItemStack(var14, 1, 3), 'G', Item.GOLD_INGOT, 'C', Block.WORKBENCH, 'c', Block.CHEST, 'W', Block.WOOD});
        }
        else
        {
            ModLoader.addRecipe(var6, new Object[] {"GGG", "WCW", "WcW", 'G', Item.GOLD_INGOT, 'C', Block.WORKBENCH, 'c', Block.CHEST, 'W', Block.WOOD});
        }

        if (var1 != -1)
        {
            if (var2 != -1)
            {
                ModLoader.addShapelessRecipe(var17, new Object[] {Item.byId[var1], Block.CHEST, new ItemStack(var2, 1, 0)});
            }
            else
            {
                ModLoader.addShapelessRecipe(var17, new Object[] {Item.byId[var1], Block.CHEST});
            }

            ModLoader.addRecipe(var6, new Object[] {"PWP", "WCW", "PcP", 'G', Item.GOLD_INGOT, 'C', var4 == -1 ? Block.WORKBENCH : Block.byId[var4], 'c', Block.CHEST, 'W', Item.byId[var1], 'P', Block.WOOD});
        }

        enableBHC = Config.getBoolean("tubestuff.enableBlackHoleChest", false);

        if (enableBHC)
        {
            ModLoader.addRecipe(var7, new Object[] {"ODO", "OCO", "ODO", 'O', Block.OBSIDIAN, 'C', Block.CHEST, 'D', Block.DIAMOND_BLOCK});
        }

        if (enableCraftingIncinerator = Config.getBoolean("tubestuff.enableCraftingIncinerator", true))
        {
            ModLoader.addRecipe(new ItemStack(mod_TubeStuff.block, 1, 3), new Object[] {"CCC", "CLC", "CCC", 'C', Block.COBBLESTONE, 'L', Item.LAVA_BUCKET});
        }

        enableCraftingRetrievulator = Config.getBoolean("tubestuff.enableCraftingRetrievulator", true);

        if (var14 != -1 && enableCraftingRetrievulator)
        {
            ModLoader.addRecipe(new ItemStack(mod_TubeStuff.block, 1, 5), new Object[] {"WWW", "R T", "WWW", 'R', new ItemStack(var14, 1, 10), 'T', new ItemStack(var14, 1, 2), 'W', new ItemStack(Block.WOOD, 1, -1)});
        }

        if (enableStorageBlocks)
        {
            addStorageRecipes(0, RedPowerItems.silverIS, enableStorageBlocks);
            addStorageRecipes(1, RedPowerItems.tinIS, enableStorageBlocks);
            addStorageRecipes(2, RedPowerItems.copperIS, enableStorageBlocks);
            addStorageRecipes(3, RedPowerItems.nikoliteIS, enableStorageBlocks);
            addStorageRecipes(4, new ItemStack(Item.COAL, 1, 0), enableStorageBlocksVanilla);
            addStorageRecipes(5, new ItemStack(Item.REDSTONE, 1, 0), enableStorageBlocksVanilla);
            addStorageRecipes(6, RedPowerItems.blueAlloyIS, enableStorageBlocks);
            addStorageRecipes(7, RedPowerItems.redAlloyIS, enableStorageBlocks);
            addStorageRecipes(8, RedPowerItems.brassIS, enableStorageBlocks);
        }
    }

    private static void addStorageRecipes(int var0, ItemStack var1, boolean var2)
    {
        if (var1 != null)
        {
            if (var2)
            {
                ModLoader.addRecipe(new ItemStack(mod_TubeStuff.blockStorage, 1, var0), new Object[] {"###", "###", "###", '#', var1});
            }

            ItemStack var3 = var1.cloneItemStack();
            var3.count = 9;
            ModLoader.addRecipe(var3, new Object[] {"#", '#', new ItemStack(mod_TubeStuff.blockStorage, 1, var0)});
        }
    }
}
