package immibis.tubestuff;

import immibis.core.api.porting.PortableContainer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.InventoryCraftResult;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Slot;

public class ContainerLogicCrafter extends PortableContainer
{
    public TileLogicCrafter tile;

    public int countIngredients(int var1)
    {
        int var2 = 0;

        for (int var3 = var1; var3 < var1 + 4; ++var3)
        {
            var2 += this.tile.inv.contents[var3] != null ? this.tile.inv.contents[var3].count : 0;
        }

        return var2;
    }

    public ContainerLogicCrafter(EntityHuman var1, TileLogicCrafter var2)
    {
        super(var1, var2);
        this.tile = var2;
        int var3;
        int var4;

        for (var3 = 0; var3 < 4; ++var3)
        {
            var4 = 34 + var3 * 18;
            this.a(new SlotFiltered(var2, 0 + var3, var4, 10, RedPowerItems.stoneWaferIS));
            this.a(new SlotFiltered(var2, 4 + var3, var4, 29, RedPowerItems.stoneWireIS));
            this.a(new SlotFiltered(var2, 8 + var3, var4, 48, RedPowerItems.stoneAnodeIS));
            this.a(new SlotFiltered(var2, 12 + var3, var4, 67, RedPowerItems.stoneCathodeIS));
            this.a(new SlotFiltered(var2, 16 + var3, var4, 86, RedPowerItems.stonePointerIS));
            this.a(new SlotFiltered(var2, 20 + var3, var4, 105, RedPowerItems.siliconChipIS));
        }

        for (var3 = 0; var3 < 9; ++var3)
        {
            for (var4 = 0; var4 < 3; ++var4)
            {
                this.a(new Slot(var1.inventory, var3 + var4 * 9 + 9, var3 * 18 + 13, var4 * 18 + 168));
            }

            this.a(new Slot(var1.inventory, var3, var3 * 18 + 13, 226));
        }

        this.a(new ContainerLogicCrafter.SlotCrafting(115, 10, RedPowerItems.timerIS, new int[] {0, 0, 4, 4, 4, 16, 12, 8, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(137, 10, RedPowerItems.sequencerIS, new int[] {0, 0, 0, 0, 12, 12, 12, 12, 16}));
        this.a(new ContainerLogicCrafter.SlotCrafting(159, 10, RedPowerItems.stateCellIS, new int[] {0, 0, 0, 4, 4, 16, 20, 12, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(115, 32, RedPowerItems.rsLatchIS, new int[] {0, 4, 4, 4, 4, 12, 12, 8, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(137, 32, RedPowerItems.norIS, new int[] {0, 0, 0, 0, 4, 4, 4, 12, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(159, 32, RedPowerItems.orIS, new int[] {0, 0, 0, 0, 4, 4, 4, 12, 12}));
        this.a(new ContainerLogicCrafter.SlotCrafting(115, 54, RedPowerItems.nandIS, new int[] {0, 0, 4, 12, 12, 12, 8, 8, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(137, 54, RedPowerItems.andIS, new int[] {0, 0, 4, 12, 12, 12, 12, 8, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(159, 54, RedPowerItems.xnorIS, new int[] {4, 4, 12, 12, 12, 12, 8, 8, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(115, 76, RedPowerItems.xorIS, new int[] {4, 4, 4, 12, 12, 12, 8, 8, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(137, 76, RedPowerItems.pulseFormerIS, new int[] {0, 4, 4, 12, 12, 12, 8, 8, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(159, 76, RedPowerItems.notIS, new int[] {0, 0, 0, 0, 4, 12, 8, 8, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(115, 98, RedPowerItems.bufferGateIS, new int[] {0, 0, 4, 4, 4, 12, 12, 8, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(137, 98, RedPowerItems.multiplexerIS, new int[] {0, 4, 12, 12, 12, 12, 8, 8, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(159, 98, RedPowerItems.repeaterIS, new int[] {0, 0, 0, 4, 4, 4, 12, 12, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(115, 120, RedPowerItems.synchronizerIS, new int[] {4, 4, 4, 4, 4, 8, 12, 20, 20}));
        this.a(new ContainerLogicCrafter.SlotCrafting(137, 120, RedPowerItems.transLatchIS, new int[] {0, 4, 4, 12, 12, 12, 12, 12, 8}));
        this.a(new ContainerLogicCrafter.SlotCrafting(159, 120, RedPowerItems.counterIS, new int[] {0, 0, 0, 0, 4, 4, 16, 12, 12}));
    }

    public ItemStack clickItem(int var1, int var2, boolean var3, EntityHuman var4)
    {
        ItemStack var5 = super.clickItem(var1, var2, var3, var4);
        this.updateCrafting();
        return var5;
    }

    /**
     * Called to transfer a stack from one inventory to the other eg. when shift clicking.
     */
    public ItemStack a(int var1)
    {
        return null;
    }

    public void updateCrafting()
    {
        Iterator var2 = this.e.iterator();

        while (var2.hasNext())
        {
            Slot var1 = (Slot)var2.next();

            if (var1 instanceof ContainerLogicCrafter.SlotCrafting)
            {
                ((ContainerLogicCrafter.SlotCrafting)var1).updateSlot();
            }
        }
    }

    public class SlotCrafting extends Slot
    {
        private int[] ingredients;
        private InventoryCraftResult inv;
        private ItemStack result;
        private Map ingred_counts = new HashMap();

        public SlotCrafting(int var2, int var3, ItemStack var4, int[] var5)
        {
            super(new InventoryCraftResult(), 0, var2, var3);

            if (var5.length != 9)
            {
                throw new IllegalArgumentException("Not 9 ingredients - typoed recipe?");
            }
            else
            {
                this.inv = (InventoryCraftResult)this.inventory;
                this.ingredients = var5;
                this.result = var4;
                int[] var9 = var5;
                int var8 = var5.length;

                for (int var7 = 0; var7 < var8; ++var7)
                {
                    int var6 = var9[var7];

                    if (this.ingred_counts.containsKey(Integer.valueOf(var6)))
                    {
                        this.ingred_counts.put(Integer.valueOf(var6), Integer.valueOf(((Integer)this.ingred_counts.get(Integer.valueOf(var6))).intValue() + 1));
                    }
                    else
                    {
                        this.ingred_counts.put(Integer.valueOf(var6), Integer.valueOf(1));
                    }
                }
            }
        }

        public boolean isAllowed(ItemStack var1)
        {
            return false;
        }

        public void updateSlot()
        {
            this.inv.setItem(0, this.checkIngredients() ? this.result.cloneItemStack() : null);
        }

        public boolean checkIngredients()
        {
            Iterator var2 = this.ingred_counts.entrySet().iterator();

            while (var2.hasNext())
            {
                Entry var1 = (Entry)var2.next();

                if (ContainerLogicCrafter.this.countIngredients(((Integer)var1.getKey()).intValue()) < ((Integer)var1.getValue()).intValue())
                {
                    return false;
                }
            }

            return true;
        }

        private boolean removeIngredients()
        {
            int[] var4 = this.ingredients;
            int var3 = this.ingredients.length;
            int var2 = 0;

            while (var2 < var3)
            {
                int var1 = var4[var2];
                boolean var5 = false;
                int var6 = var1;

                while (true)
                {
                    if (var6 < var1 + 4)
                    {
                        ItemStack var7 = ContainerLogicCrafter.this.tile.inv.splitStack(var6, 1);

                        if (var7 == null || var7.count <= 0)
                        {
                            ++var6;
                            continue;
                        }

                        var5 = true;
                    }

                    if (!var5)
                    {
                        return false;
                    }

                    ++var2;
                    break;
                }
            }

            return true;
        }

        public void c(ItemStack var1)
        {
            var1.a(ContainerLogicCrafter.this.player.world, ContainerLogicCrafter.this.player, var1.count);

            if (!this.removeIngredients())
            {
                throw new IllegalStateException("Items were removed from crafting slot, but ingredients were not available.");
            }
            else
            {
                ContainerLogicCrafter.this.tile.update();
            }
        }
    }
}
