package immibis.tubestuff;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.BlockSand;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.World;

public class BlockStorage extends Block
{
    public BlockStorage(int var1)
    {
        super(var1, Material.ORE);
        this.c(5.0F);
        this.b(10.0F);
        this.a(Block.i);
        this.setTextureFile("/immibis/tubestuff/blocks.png");
    }

    public void addCreativeItems(ArrayList var1)
    {
        for (int var2 = 0; var2 < 9; ++var2)
        {
            var1.add(new ItemStack(this, 1, var2));
        }
    }

    /**
     * Called whenever the block is added into the world. Args: world, x, y, z
     */
    public void onPlace(World var1, int var2, int var3, int var4)
    {
        if (this.canFall(var1.getData(var2, var3, var4)))
        {
            var1.c(var2, var3, var4, this.id, this.d());
        }
    }

    /**
     * Lets the block know when one of its neighbor changes. Doesn't know which neighbor changed (coordinates passed are
     * their own) Args: x, y, z, neighbor blockID
     */
    public void doPhysics(World var1, int var2, int var3, int var4, int var5)
    {
        if (this.canFall(var1.getData(var2, var3, var4)))
        {
            var1.c(var2, var3, var4, this.id, this.d());
        }
    }

    private boolean canFall(int var1)
    {
        return var1 == 3 || var1 == 5;
    }

    /**
     * Ticks the block if it's been scheduled
     */
    public void a(World var1, int var2, int var3, int var4, Random var5)
    {
        if (this.canFall(var1.getData(var2, var3, var4)))
        {
            this.tryToFall(var1, var2, var3, var4);
        }
    }

    private void tryToFall(World var1, int var2, int var3, int var4)
    {
        if (BlockSand.canFall(var1, var2, var3 - 1, var4) && var3 >= 0)
        {
            int var5 = var1.getData(var2, var3, var4);
            var1.setTypeId(var2, var3, var4, 0);

            while (BlockSand.canFall(var1, var2, var3 - 1, var4) && var3 > 0)
            {
                --var3;
            }

            if (var3 > 0)
            {
                var1.setTypeIdAndData(var2, var3, var4, this.id, var5);
            }
        }
    }

    /**
     * How many world ticks before ticking
     */
    public int d()
    {
        return 3;
    }

    /**
     * Determines the damage on the item the block drops. Used in cloth and wood.
     */
    public int getDropData(int var1)
    {
        return var1;
    }

    /**
     * From the specified side and block metadata retrieves the blocks texture. Args: side, metadata
     */
    public int a(int var1, int var2)
    {
        return 32 + var2;
    }

    public static enum Meta
    {
        SILVER("SILVER", 0),
        TIN("TIN", 1),
        COPPER("COPPER", 2),
        NIKOLITE("NIKOLITE", 3),
        COAL("COAL", 4),
        REDSTONE("REDSTONE", 5),
        BLUE_ALLOY("BLUE_ALLOY", 6),
        RED_ALLOY("RED_ALLOY", 7),
        BRASS("BRASS", 8);

        private static final BlockStorage.Meta[] ENUM$VALUES = new BlockStorage.Meta[]{SILVER, TIN, COPPER, NIKOLITE, COAL, REDSTONE, BLUE_ALLOY, RED_ALLOY, BRASS};

        private Meta(String var1, int var2) {}
    }
}
