package immibis.tubestuff;

import java.util.ArrayList;
import java.util.Random;

import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockStorage extends Block {
	
	public static enum Meta {
		SILVER, TIN, COPPER, NIKOLITE, COAL, REDSTONE, BLUE_ALLOY, RED_ALLOY, BRASS
	}

	public BlockStorage(int id) {
		super(id, Material.iron);
		setHardness(5.0F);
		setResistance(10.0F);
		setStepSound(soundMetalFootstep);
		setTextureFile("/immibis/tubestuff/blocks.png");
		
		/* $if mc > 1.3$ */
		setCreativeTab(net.minecraft.src.CreativeTabs.tabMisc);
		/* $endif$ */
	}
	
	@Override
	public void addCreativeItems(ArrayList l) {
		for(int k = 0; k < 9; k++)
			l.add(new ItemStack(this, 1, k));
	}
	
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
    	if(canFall(par1World.getBlockMetadata(par2, par3, par4)))
    		par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
    }

    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
    	if(canFall(par1World.getBlockMetadata(par2, par3, par4)))
        	par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
    }

    private boolean canFall(int meta) {
		return meta == 3 || meta == 5; // nikolite or redstone
	}

	public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
		if(canFall(par1World.getBlockMetadata(par2, par3, par4)))
		   tryToFall(par1World, par2, par3, par4);
    }

    private void tryToFall(World par1World, int par2, int par3, int par4) {
        if (BlockSand.canFallBelow(par1World, par2, par3 - 1, par4) && par3 >= 0)
        {
        	int meta = par1World.getBlockMetadata(par2, par3, par4);
        	
            par1World.setBlockWithNotify(par2, par3, par4, 0);

            while (BlockSand.canFallBelow(par1World, par2, par3 - 1, par4) && par3 > 0)
                --par3;

            if (par3 > 0)
                par1World.setBlockAndMetadataWithNotify(par2, par3, par4, this.blockID, meta);
        }
    }

    @Override
    public int tickRate() {
        return 3;
    }
	
	@Override
	public int damageDropped(int meta) {
		return meta;
	}
	
	@Override
	public int getBlockTextureFromSideAndMetadata(int side, int data) {
		return 32 + data;
	}

}
