package immibis.tubestuff;

import net.minecraft.src.*;
import net.minecraft.src.forge.ISidedInventory;
import immibis.core.BasicInventory;
import immibis.core.NonSharedProxy;
import immibis.core.Side;
import immibis.core.TileBasicInventory;

public class TileRetrievulator extends TileBasicInventory implements ISidedInventory {
	
	public int outputFace;
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		tag.setInteger("outputFace", outputFace);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		outputFace = tag.getInteger("outputFace");
	}
	
	// client-only override
	public void onDataPacket(NetworkManager net, Packet132TileEntityData pkt) {
		outputFace = pkt.customParam1;
		worldObj.markBlockNeedsUpdate(xCoord, yCoord, zCoord);
	}
	
	// server-only override
	public Packet getDescriptionPacket() {
		Packet132TileEntityData p = new Packet132TileEntityData();
		p.actionType = 0;
		p.customParam1 = outputFace;
		p.customParam2 = 0;
		p.customParam3 = 0;
		p.xPosition = xCoord;
		p.yPosition = yCoord;
		p.zPosition = zCoord;
		p.isChunkDataPacket = true;
		return p;
	}
	
	public static final int SLOT_RETRIEVER_SETUP = 0;
	public static final int SLOT_TARGET = 9;
	public static final int SLOT_BUFFER = 18;

	public TileRetrievulator() {
		super(19, "Retrievulator");
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		player.openGui(mod_TubeStuff.instance, mod_TubeStuff.GUI_RETRIEVULATOR, worldObj, xCoord, yCoord, zCoord);
		return true;
	}
	
	@Override
	public void onPlaced(EntityLiving player, int dir) {
		outputFace = dir;
	}
	
	private TileEntity getTarget(int side) {
		int x = xCoord;
		int y = yCoord;
		int z = zCoord;
		switch(side) {
		case Side.NX: x--; break;
		case Side.NY: y--; break;
		case Side.NZ: z--; break;
		case Side.PX: x++; break;
		case Side.PY: y++; break;
		case Side.PZ: z++; break;
		}
		return worldObj.getBlockTileEntity(x, y, z);
	}
	
	private int updateTicks = 0;
	private TileEntity retriever;
	private IInventory target;
	
	@Override
	public void onBlockNeighbourChange() {
		updateTicks = 0;
	}
	
	@Override
	public void updateEntity() {
		if(updateTicks <= 0) {
			updateTicks = 20;
			TileEntity tetarget = getTarget(outputFace);
			retriever = getTarget(outputFace ^ 1);
			if(retriever != null && !retriever.getClass().getName().equals("eloraam.machine.TileRetriever"))
				retriever = null;
			if(!(tetarget instanceof IInventory))
				target = null;
			else
				target = ((IInventory)tetarget);
		}
		updateTicks--;
		if(target == null || retriever == null)
			return;
		int start, end;
		if(target instanceof ISidedInventory) {
			ISidedInventory isi = (ISidedInventory)target;
			int side = outputFace ^ 1;
			start = isi.getStartInventorySide(side);
			end = start + isi.getSizeInventorySide(side);
		} else {
			start = 0;
			end = ((IInventory)target).getSizeInventory();
		}
		
		IInventory iinv = (IInventory)target;
		
		if(inv.contents[SLOT_BUFFER] != null) {
			BasicInventory.mergeStackIntoRange(inv, target, SLOT_BUFFER, start, end);
			if(inv.contents[SLOT_BUFFER] != null) {
				return;
			}
		}
		
		if((updateTicks % 5) == 0)
		{
			boolean[] itemsOK = new boolean[9];
			boolean error = false;
			boolean any = false;
			IInventory iir = (IInventory)retriever;
			for(int k = 0; k < 9; k++) {
				boolean retriever_filled = iir.getStackInSlot(k) != null && iir.getStackInSlot(k).itemID != mod_TubeStuff.itemUseless.shiftedIndex;
				boolean this_filled = inv.contents[SLOT_RETRIEVER_SETUP + k] != null;
				if(inv.contents[SLOT_TARGET + k] == null) {
					error = error || this_filled || retriever_filled;
					continue;
				}
				if(!checkTarget(start, end, iinv, inv.contents[SLOT_TARGET + k])) {
					//System.out.println("slot "+k+": this "+this_filled+", retriever "+retriever_filled+", checkTarget false");
					if(this_filled && !retriever_filled) {
						iir.setInventorySlotContents(k, getStackInSlot(SLOT_RETRIEVER_SETUP + k));
						setInventorySlotContents(SLOT_RETRIEVER_SETUP + k, null);
					} else if(this_filled || !retriever_filled)
						error = true;
					any = true;
				} else {
					//System.out.println("slot "+k+": this "+this_filled+", retriever "+retriever_filled+", checkTarget true");
					if(retriever_filled && !this_filled) {
						setInventorySlotContents(SLOT_RETRIEVER_SETUP + k, iir.getStackInSlot(k));
						iir.setInventorySlotContents(k, null);
					} else if(!this_filled || retriever_filled)
						error = true;
				}
			}
			
			//System.out.println("error = "+error+", any = "+any+", redstone_output = " + redstone_output);
			
			if(!error) {
				if(!any) {
					iir.setInventorySlotContents(0, new ItemStack(mod_TubeStuff.itemUseless, 1, 0));
				} else if((updateTicks % 10) == 0) {
					ItemStack slot1 = iir.getStackInSlot(0);
					if(slot1 != null && slot1.itemID == mod_TubeStuff.itemUseless.shiftedIndex)
						iir.setInventorySlotContents(0, null);
					redstone_output = !redstone_output;
					notifyNeighbouringBlocks();
				}
			}
		}
	}

	private boolean checkTarget(int start, int end, IInventory iinv, ItemStack tis) {
		if(tis == null)
			return true;
		int need = tis.stackSize;
		for(int slot = start; slot < end && need > 0; slot++) {
			ItemStack ais = iinv.getStackInSlot(slot);
			if(ais == null)
				continue;
			if(mod_TubeStuff.areItemsEqual(tis, ais))
				need -= ais.stackSize;
		}
		return need <= 0;
	}

	@Override
	public int getStartInventorySide(int side) {
		return SLOT_BUFFER;
	}

	@Override
	public int getSizeInventorySide(int side) {
		return 1;
	}
}
