package immibis.tubestuff;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

import cpw.mods.fml.common.FMLCommonHandler;

import net.minecraft.src.forge.ForgeHooks;
import net.minecraft.src.forge.ISidedInventory;
import net.minecraft.src.AchievementList;
import net.minecraft.src.Block;
import net.minecraft.src.Container;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import immibis.core.TileBasicInventory;
import immibis.core.TileCombined;

public class TileCraftingTable extends TileBasicInventory implements ISidedInventory {
	// 1 slot output (0)
	// 9 slots recipe (1-9)
	// 9x4 slots input (10-45)
	// 9 slots overflow/input (46-54)
	static final int SLOT_OUTPUT = 0;
	static final int START_RECIPE = SLOT_OUTPUT + 1;
	static final int SIZE_RECIPE = 9;
	static final int START_INPUT = START_RECIPE + SIZE_RECIPE;
	static final int SIZE_INPUT = 9*5;
	static final int START_OVERFLOW = START_INPUT + 9*4;
	static final int SIZE_OVERFLOW = 9;
	static final int INVSIZE = START_INPUT + SIZE_INPUT;
	
	private IRecipe cachedRecipe;
	private boolean invChanged = true;
	private boolean recipeChanged = true;
	private boolean outputFull = false;
	private boolean insufficientInput = false;
	
	private int pulse_ticks = 0;
	
	@Override
	public int getStartInventorySide(int i) {
		switch(i) {
		case 1: return SLOT_OUTPUT;
		case 0: return START_OVERFLOW;
		default: return START_INPUT + 9 * (i - 2);
		}
	}

	@Override
	public int getSizeInventorySide(int i) {
		return i == 1 ? (inv.contents[SLOT_OUTPUT] != null ? 1 : 0) : 9;
	}
	
	public TileCraftingTable() {
		super(INVSIZE, "ACT Mk II");
	}
	
	private InventoryCrafting makeInventoryCrafting(int start) {
		InventoryCraftingACT2 ic = new InventoryCraftingACT2();
		for(int k = 0; k < 9; k++)
			ic.setInventorySlotContents(k, inv.contents[k + start]);
		return ic;
	}
	
	private void cacheOutput() {
		InventoryCrafting ic = makeInventoryCrafting(START_RECIPE);
		for(IRecipe r : (List<IRecipe>)CraftingManager.getInstance().getRecipeList())
		{
			if(r.matches(ic))
			{
				cachedRecipe = r;
				return;
			}
		}
		cachedRecipe = null;
	}
	
	private void makeOutput() {
		if(inv.contents[SLOT_OUTPUT] != null)
			return;
		if(cachedRecipe == null)
			return;
		
		// slotMap[recipe slot] == input slot or -1
		int[] slotMap = new int[9];
		// used[input slot] == number of items to be used from this slot
		int[] used = new int[45];
		for(int k = 0; k < 9; k++)
		{
			ItemStack recipe = inv.contents[k + START_RECIPE];
			slotMap[k] = -1;
			if(recipe == null)
				continue;
			for(int i = 0; i < 45; i++)
			{
				ItemStack input = inv.contents[i + START_INPUT];
				if(input == null || used[i] >= input.stackSize)
					continue;
				if(mod_TubeStuff.areItemsEqual(recipe, input))
				{ 
					slotMap[k] = i;
					used[i]++;
					break;
				}
			}
			if(slotMap[k] == -1)
			{
				insufficientInput = true;
				return;
			}
		}
		
		InventoryCraftingACT2 ic = new InventoryCraftingACT2();
		for(int k = 0; k < 9; k++)
			if(slotMap[k] != -1)
				ic.setInventorySlotContents(k, inv.contents[slotMap[k] + START_INPUT]);
		if(!cachedRecipe.matches(ic))
		{
			insufficientInput = true;
			return;
		}
		for(int k = 0; k < 9; k++)
			if(slotMap[k] != -1)
				ic.setInventorySlotContents(k, inv.decrStackSize(slotMap[k] + START_INPUT, 1));
		inv.contents[SLOT_OUTPUT] = cachedRecipe.getCraftingResult(ic);
		decreaseInput(ic, inv.contents[SLOT_OUTPUT]);
		for(int k = 0; k < 9; k++)
		{
			ItemStack leftover = ic.getStackInSlot(k);
			if(leftover != null)
				// if this fails, the item is destroyed as there's nowhere to put it
				inv.mergeStackIntoRange(leftover, START_OVERFLOW, START_OVERFLOW + SIZE_OVERFLOW);
		}
		
		invChanged = true;
		onInventoryChanged();
	}
	
	private static boolean allowCraftingHook = true;
	
	private static int usingFML = -1;
	
	private void decreaseInput(InventoryCrafting ic, ItemStack output)
	{
		if(allowCraftingHook) {
			try {
				if(usingFML == -1) {
					try {
						Class.forName("cpw.mods.fml.client.FMLClientHandler");
						usingFML = 1;
					} catch(ClassNotFoundException e) {
						usingFML = 0;
					}
				}
				
				if(usingFML == 1)
					/* $if client$ */
					cpw.mods.fml.client.FMLClientHandler.instance().onItemCrafted(mod_TubeStuff.fakePlayer(worldObj), output, ic);
					/* $else$
					cpw.mods.fml.server.FMLServerHandler.instance().onItemCrafted(mod_TubeStuff.fakePlayer(worldObj), output, ic);
					$endif$ */
				else
					ModLoader.takenFromCrafting(mod_TubeStuff.fakePlayer(worldObj), output, ic);
				ForgeHooks.onTakenFromCrafting(mod_TubeStuff.fakePlayer(worldObj), output, ic);
				Item.itemsList[output.itemID].onCreated(output, worldObj, null);
			} catch(Exception e) {
				allowCraftingHook = false;
				e.printStackTrace();
				ModLoader.getLogger().log(Level.WARNING, "TubeStuff: This happened when trying to call a crafting hook with a null player. I won't try that again, but this may cause some bugs. If you can tell which mod caused the problem, bug its author to fix it.");
			}
		}
		
        for(int i = 0; i < ic.getSizeInventory(); i++)
        {
            ItemStack input = ic.getStackInSlot(i);
            if (input == null)
                continue;
            ic.decrStackSize(i, 1);
            if(input.getItem().hasContainerItem())
            {
            	ItemStack container = new ItemStack(input.getItem().getContainerItem());
            	if(ic.getStackInSlot(i) == null)
            		ic.setInventorySlotContents(i, container);
            	else
            	{
            		// if this fails, item is lost because there's nowhere to put it
            		inv.mergeStackIntoRange(container, START_OVERFLOW, START_OVERFLOW + SIZE_OVERFLOW);
            	}
            }
        }
	}
	
	@Override
	public void updateEntity() {
		// workaround for some things not triggering slotChanging
		insufficientInput = false;
		
		if(inv.contents[SLOT_OUTPUT] == null)
		{
			if(recipeChanged)
			{
				cacheOutput();
				recipeChanged = false;
			}
			if(cachedRecipe != null && !insufficientInput)
				makeOutput();
		}
		if(inv.contents[SLOT_OUTPUT] != null) {
			/*pulse_ticks = (pulse_ticks + 1) % 20;
			if(pulse_ticks == 0) {
				redstone_output = !redstone_output;
				notifyNeighbouringBlocks();
			}*/
		} else if(redstone_output) {
			redstone_output = false;
			notifyNeighbouringBlocks();
		}
		if(invChanged)
		{
			invChanged = false;
			insufficientInput = false;
		}
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		player.openGui(mod_TubeStuff.instance, mod_TubeStuff.GUI_TABLE, worldObj, xCoord, yCoord, zCoord);
		return true;
	}
	
	private void slotChanging(int i)
	{
		if(i == SLOT_OUTPUT)
			outputFull = false;
		if(i >= START_RECIPE && i < START_RECIPE + SIZE_RECIPE)
			recipeChanged = true;
		invChanged = true;
		insufficientInput = false;
		//System.out.println("slotChanging("+i+")");
	}
	
	@Override
	public ItemStack decrStackSize(int i, int j) {
		slotChanging(i);
		return super.decrStackSize(i, j);
	}
	
	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack) {
		slotChanging(i);
		super.setInventorySlotContents(i, itemstack);
	}
}
