package immibis.tubestuff;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

import net.minecraft.src.*;
import net.minecraft.src.forge.MinecraftForge;
import immibis.core.Config;
import immibis.core.CoreProxy;
import immibis.core.ModInfoReader;
import immibis.core.NonSharedProxy;
import immibis.core.config.ExtendedForgeConfigReader;
import immibis.core.config.IConfigReader;

public class SharedProxy {
	static boolean CC_CheckArgs(Object[] objs, Class[] types)
	{
		if(objs.length != types.length)
			return false;
		for(int k = 0; k < objs.length; k++)
			if(objs[k].getClass() != types[k])
				return false;
		return true;
	}
	
	public static final boolean DEBUG_MODE = mod_TubeStuff.class.getName().equals("net.minecraft.src.mod_TubeStuff");
	
	public static boolean enableBHCParticles, enableBHC, enableBHCAnim, enableCraftingIncinerator;
	
	private static Class findClass(String name)
	{
		try
		{
			return SharedProxy.class.getClassLoader().loadClass("net.minecraft.src."+name);
		}
		catch(ClassNotFoundException e)
		{
			try
			{
				return SharedProxy.class.getClassLoader().loadClass(name);
			}
			catch(ClassNotFoundException e2)
			{
				return null;
			}
		}
	}
	
	public static IConfigReader redpowerConfig = null;
	
	public static void FirstTick() {
		int machineID = -1;
		int woodenPipeID = -1;
		int engineID = -1;
		int logicID = -1;
		int actID = -1;
		
		try
		{
			ExtendedForgeConfigReader reader = new ExtendedForgeConfigReader("redpower/redpower.cfg");
			
			redpowerConfig = reader;
		
			try
			{
				machineID = Integer.parseInt(reader.getConfigEntry("blocks.machine.machine.id"));
				if(!Block.blocksList[machineID].getClass().getName().equals("eloraam.machine.BlockMachine"))
					machineID = -1;
			}
			catch(Exception e)
			{
				System.out.println(mod_TubeStuff.class.getSimpleName()+": RP2 Machine doesn't seem to be installed");
				machineID = -1;
			}

			try
			{
				logicID = Integer.parseInt(reader.getConfigEntry("blocks.logic.logic.id"));
				if(!Block.blocksList[logicID].getClass().getName().equals("eloraam.logic.BlockLogic"))
					logicID = -1;
			}
			catch(Exception e)
			{
				System.out.println(mod_TubeStuff.class.getSimpleName()+": RP2 Logic doesn't seem to be installed");
				logicID = -1;
			}
		}
		catch(IOException e)
		{
			System.out.println(mod_TubeStuff.class.getSimpleName()+": RP2 doesn't seem to be installed");
			logicID = -1;
			machineID = -1;
		}
		
		ClassLoader loader = SharedProxy.class.getClassLoader();
		
		try
		{
			Class bcTransport = findClass("BuildCraftTransport");
			if(bcTransport != null)
				woodenPipeID = ((Item)bcTransport.getDeclaredField("pipeItemsWood").get(null)).shiftedIndex;
		}
		catch(Exception e)
		{
			System.out.println(mod_TubeStuff.class.getSimpleName()+": BC Transport doesn't seem to be installed");
		}

		try
		{
			Class bcEnergy = findClass("BuildCraftEnergy");
			if(bcEnergy != null)
				engineID = ((Block)bcEnergy.getDeclaredField("engineBlock").get(null)).blockID;
		}
		catch(Exception e)
		{
			System.out.println(mod_TubeStuff.class.getSimpleName()+": BC Energy doesn't seem to be installed");
		}
		
		try
		{
			Class bcFactory = findClass("BuildCraftFactory");
			if(bcFactory != null)
				actID = ((Block)bcFactory.getDeclaredField("autoWorkbenchBlock").get(null)).blockID;
		}
		catch(Exception e)
		{
			System.out.println(mod_TubeStuff.class.getSimpleName()+": BC Factory doesn't seem to be installed");
		}
		
		ItemStack bufferIS = new ItemStack(mod_TubeStuff.block, 1, 0);
		ItemStack actIS = new ItemStack(mod_TubeStuff.block, 1, 1);
		ItemStack infChestIS = new ItemStack(mod_TubeStuff.block, 1, 2);
		ItemStack incineratorIS = new ItemStack(mod_TubeStuff.block, 1, 3);
		ItemStack duplicatorIS = new ItemStack(mod_TubeStuff.block, 1, 4);
		
		if(machineID != -1)
		{
			if(logicID != -1)
				ModLoader.addShapelessRecipe(bufferIS, new Object[] {
					new ItemStack(machineID, 1, 3), // filter
					Block.chest,
					new ItemStack(logicID, 1, 0) // timer
				});
			else
				ModLoader.addShapelessRecipe(bufferIS, new Object[] {
					new ItemStack(machineID, 1, 3), // filter
					Block.chest
				});
			ModLoader.addRecipe(actIS, new Object[] {
				"GFG",
				"WCW",
				"WcW",
				'F', new ItemStack(machineID, 1, 3), // filter
				'G', Item.ingotGold,
				'C', Block.workbench,
				'c', Block.chest,
				'W', Block.planks
			});
		}
		else
		{
			ModLoader.addRecipe	(actIS, new Object[] {
				"GGG",
				"WCW",
				"WcW",
				'G', Item.ingotGold,
				'C', Block.workbench,
				'c', Block.chest,
				'W', Block.planks
			});
		}
		if(woodenPipeID != -1)
		{
			if(engineID != -1)
				ModLoader.addShapelessRecipe(bufferIS, new Object[] {
					Item.itemsList[woodenPipeID],
					Block.chest,
					new ItemStack(engineID, 1, 0) // redstone engine
				});
			else
				ModLoader.addShapelessRecipe(bufferIS, new Object[] {
					Item.itemsList[woodenPipeID],
					Block.chest
				});
			
			ModLoader.addRecipe(actIS, new Object[] {
				"PWP",
				"WCW",
				"PcP",
				'G', Item.ingotGold,
				'C', actID == -1 ? Block.workbench : Block.blocksList[actID],
				'c', Block.chest,
				'W', Item.itemsList[woodenPipeID],
				'P', Block.planks
			});
		}
		
		if(NonSharedProxy.CLIENT) {
			enableBHC = Config.getBoolean("tubestuff.enableBlackHoleChest", false);
			enableBHCAnim = Config.getBoolean("tubestuff.enableBHCAnim", true);
			enableBHCParticles = Config.getBoolean("tubestuff.enableBHCParticles", true);
			if(enableBHC) {
				ModLoader.addRecipe(infChestIS, new Object[] {
					"ODO",
					"OCO",
					"ODO",
					'O', Block.obsidian,
					'C', Block.chest,
					'D', Block.blockDiamond
				});
			}
		}
		
		if(enableCraftingIncinerator = Config.getBoolean("tubestuff.enableCraftingIncinerator", true))
		{
			// Incinerator
			
			/*ModLoader.addRecipe(new ItemStack(mod_TubeStuff.block, 1, 3), new Object[] {
				"BBB",
				"BLB",
				"BBB",
				'B', Item.brick,
				'L', Item.bucketLava
			});*/
			
			ModLoader.addRecipe(new ItemStack(mod_TubeStuff.block, 1, 3), new Object[] {
				"CCC",
				"CLC",
				"CCC",
				'C', Block.cobblestone,
				'L', Item.bucketLava
			});
		}
		
		if(machineID != -1) {
			// Retrievulator
			ModLoader.addRecipe(new ItemStack(mod_TubeStuff.block, 1, 5), new Object[] {
				"WWW",
				"R T",
				"WWW",
				'R', new ItemStack(machineID, 1, 10), // regulator
				'T', new ItemStack(machineID, 1, 2), // transposer
				'W', new ItemStack(Block.planks, 1, -1)
			});
		}
	}
	
	/* $if client$ */
	public static boolean enableBHCAnim() {
		GameSettings gs = ModLoader.getMinecraftInstance().gameSettings;
		return enableBHCAnim && !gs.anaglyph && gs.fancyGraphics;
	}
	/* $endif$ */
}
