package immibis.tubestuff;

import org.lwjgl.opengl.GL11;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GuiChest;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.IInventory;

public class GuiInfiniteChest extends GuiContainer {
	private IInventory chest;
	private ContainerInfiniteChest container;
	public GuiInfiniteChest(EntityPlayer player, TileInfiniteChest chest) {
		super(new ContainerInfiniteChest(player, chest));
		this.container = (ContainerInfiniteChest)inventorySlots;
		this.chest = chest;
		xSize = 242;
		ySize = 203; 
	}
	
	private void sendButton(int button)
	{
		this.mc.playerController.windowClick(this.inventorySlots.windowId, 0, button, false, this.mc.thePlayer);
	}
	
	protected void mouseClicked(int real_x, int real_y, int button)
    {
		int x = (real_x - this.guiLeft);
		int y = (real_y - this.guiTop);
		if(button == 0)
		{
			if(x >= 194 && y >= 122 && x <= 212 && y <= 139)
				// previous page button
				sendButton(3);
			else if(x >= 220 && y >= 122 && x <= 238 && y <= 139)
				// next page button
				sendButton(4);
			else
				super.mouseClicked(real_x, real_y, button);
		}
		else
			super.mouseClicked(real_x, real_y, button);
    }
	
	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
		int k = mc.renderEngine.getTexture("/immibis/tubestuff/black-hole-chest.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        mc.renderEngine.bindTexture(k);
        int l = (width - xSize) / 2;
        int i1 = (height - ySize) / 2;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
        
        if(container.chest.maxPages == -1)
        	container.chest.updateMaxPages();
        
        fontRenderer.drawString("Page "+(container.page+1)+" of "+container.chest.maxPages, 172 + l, 156 + i1, 0x404040);
	}
}
