package immibis.tubestuff;

import forge.IGuiHandler;
import forge.MinecraftForge;
import ic2.api.Ic2Recipes;
import immibis.core.CompatibleBaseMod;
import immibis.core.Config;
import immibis.core.CoreProxy;
import immibis.core.IBlockIDCallback;
import immibis.core.ModInfoReader;
import immibis.core.NonSharedProxy;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ContainerChest;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ModLoader;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class mod_TubeStuff extends CompatibleBaseMod implements IGuiHandler
{
    public static mod_TubeStuff instance;
    public static BlockTubestuff block;
    public static Item itemUseless;
    private static EntityPlayerFakeTS fakePlayer;
    public static final int GUI_BUFFER = 0;
    public static final int GUI_TABLE = 1;
    public static final int GUI_CHEST = 2;
    public static final int GUI_LOGICCRAFTER = 3;
    public static final int GUI_RETRIEVULATOR = 4;
    public static final int GUI_DUPLICATOR = 5;

    public static EntityPlayerFakeTS fakePlayer(World var0)
    {
        if (fakePlayer == null)
        {
            fakePlayer = new EntityPlayerFakeTS(var0);
        }

        return fakePlayer;
    }

    public mod_TubeStuff()
    {
        instance = this;
    }

    public String getPriorities()
    {
        return "after:mod_ImmibisCore";
    }

    public String getVersion()
    {
        return ModInfoReader.getModInfoField("/immibis/mod_TubeStuff.info.txt", "version");
    }

    public boolean onTickInGame(MinecraftServer var1)
    {
        SharedProxy.FirstTick();
        return false;
    }

    public void load()
    {
        BlockTubestuff.model = NonSharedProxy.getUniqueBlockModelID(this, true);
        ModLoader.setInGameHook(this, true, true);
        MinecraftForge.setGuiHandler(this, this);
        CoreProxy.RegisterBlockID("tubestuff", new IBlockIDCallback()
        {
            public void registerBlock(int var1)
            {
                mod_TubeStuff.block = new BlockTubestuff(var1);
                ModLoader.registerBlock(mod_TubeStuff.block, ItemTubestuff.class);
                ModLoader.registerTileEntity(TileBuffer.class, "TubeStuff buffer");
                ModLoader.registerTileEntity(TileCraftingTable.class, "TubeStuff crafting table");
                ModLoader.registerTileEntity(TileLogicCrafter.class, "TubeStuff logic crafter");
                ModLoader.registerTileEntity(TileRetrievulator.class, "TubeStuff retrievulator");
                ModLoader.registerTileEntity(TileIncinerator.class, "TubeStuff incinerator");
                ModLoader.registerTileEntity(TileDuplicator.class, "TubeStuff duplicator");
                ModLoader.registerTileEntity(TileInfiniteChest.class, "TubeStuff infinite chest");
            }
        });
        itemUseless = new ItemTS(Config.getItemID("tubestuff.uselessItem", 7614) - 256);
        itemUseless.a("tubestuff.uselessItem");
        itemUseless.d(5);
        itemUseless.e(1);
        ModLoader.addName(itemUseless, "Retriever jammer");

        try
        {
            Ic2Recipes.addRecyclerBlacklistItem(itemUseless);
        }
        catch (NoClassDefFoundError var2)
        {
            ;
        }
    }

    public Object getGuiElement(int var1, EntityHuman var2, World var3, int var4, int var5, int var6)
    {
        TileEntity var7 = var3.getTileEntity(var4, var5, var6);

        switch (var1)
        {
            case 0:
                return new ContainerChest(var2.inventory, (TileBuffer)var7);

            case 1:
                return new ContainerCraftingTable(var2, (TileCraftingTable)var7);

            case 2:
                return new ContainerInfiniteChest(var2, (TileInfiniteChest)var7);

            case 3:
                return new ContainerLogicCrafter(var2, (TileLogicCrafter)var7);

            case 4:
                return new ContainerRetrievulator(var2, (TileRetrievulator)var7);

            case 5:
                return new ContainerOneSlot(var2, ((TileDuplicator)var7).getGuiInventory());

            default:
                return null;
        }
    }

    public static final boolean areItemsEqual(ItemStack var0, ItemStack var1)
    {
        return var1.id == var0.id && (!var1.usesData() || var1.getData() == var0.getData());
    }
}
