package immibis.tubestuff;

import forge.ISidedInventory;
import immibis.core.BasicInventory;
import immibis.core.TileBasicInventory;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NetworkManager;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet132TileEntityData;
import net.minecraft.server.TileEntity;

public class TileRetrievulator extends TileBasicInventory implements ISidedInventory
{
    public int outputFace;
    public static final int SLOT_RETRIEVER_SETUP = 0;
    public static final int SLOT_TARGET = 9;
    public static final int SLOT_BUFFER = 18;
    private int updateTicks = 0;
    private TileEntity retriever;
    private IInventory target;

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("outputFace", this.outputFace);
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.outputFace = var1.getInt("outputFace");
    }

    public void onDataPacket(NetworkManager var1, Packet132TileEntityData var2)
    {
        this.outputFace = var2.e;
        this.world.notify(this.x, this.y, this.z);
    }

    /**
     * Overriden in a sign to provide the text
     */
    public Packet d()
    {
        Packet132TileEntityData var1 = new Packet132TileEntityData();
        var1.d = 0;
        var1.e = this.outputFace;
        var1.f = 0;
        var1.g = 0;
        var1.a = this.x;
        var1.b = this.y;
        var1.c = this.z;
        var1.lowPriority = true;
        return var1;
    }

    public TileRetrievulator()
    {
        super(19, "Retrievulator");
    }

    public boolean onBlockActivated(EntityHuman var1)
    {
        var1.openGui(mod_TubeStuff.instance, 4, this.world, this.x, this.y, this.z);
        return true;
    }

    public void onPlaced(EntityLiving var1, int var2)
    {
        this.outputFace = var2;
    }

    private TileEntity getTarget(int var1)
    {
        int var2 = this.x;
        int var3 = this.y;
        int var4 = this.z;

        switch (var1)
        {
            case 0:
                --var3;
                break;

            case 1:
                ++var3;
                break;

            case 2:
                --var4;
                break;

            case 3:
                ++var4;
                break;

            case 4:
                --var2;
                break;

            case 5:
                ++var2;
        }

        return this.world.getTileEntity(var2, var3, var4);
    }

    public void onBlockNeighbourChange()
    {
        this.updateTicks = 0;
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (this.updateTicks <= 0)
        {
            this.updateTicks = 20;
            TileEntity var1 = this.getTarget(this.outputFace);
            this.retriever = this.getTarget(this.outputFace ^ 1);

            if (this.retriever != null && !this.retriever.getClass().getName().equals("eloraam.machine.TileRetriever"))
            {
                this.retriever = null;
            }

            if (!(var1 instanceof IInventory))
            {
                this.target = null;
            }
            else
            {
                this.target = (IInventory)var1;
            }
        }

        --this.updateTicks;

        if (this.target != null && this.retriever != null)
        {
            int var2;
            int var11;

            if (this.target instanceof ISidedInventory)
            {
                ISidedInventory var3 = (ISidedInventory)this.target;
                int var4 = this.outputFace ^ 1;
                var11 = var3.getStartInventorySide(var4);
                var2 = var11 + var3.getSizeInventorySide(var4);
            }
            else
            {
                var11 = 0;
                var2 = this.target.getSize();
            }

            IInventory var12 = this.target;

            if (this.inv.contents[18] != null)
            {
                BasicInventory.mergeStackIntoRange(this.inv, this.target, 18, var11, var2);

                if (this.inv.contents[18] != null)
                {
                    return;
                }
            }

            if (this.updateTicks % 5 == 0)
            {
                boolean[] var13 = new boolean[9];
                boolean var5 = false;
                boolean var6 = false;
                IInventory var7 = (IInventory)this.retriever;

                for (int var8 = 0; var8 < 9; ++var8)
                {
                    boolean var9 = var7.getItem(var8) != null && var7.getItem(var8).id != mod_TubeStuff.itemUseless.id;
                    boolean var10 = this.inv.contents[0 + var8] != null;

                    if (this.inv.contents[9 + var8] == null)
                    {
                        var5 = var5 || var10 || var9;
                    }
                    else if (!this.checkTarget(var11, var2, var12, this.inv.contents[9 + var8]))
                    {
                        if (var10 && !var9)
                        {
                            var7.setItem(var8, this.getItem(0 + var8));
                            this.setItem(0 + var8, (ItemStack)null);
                        }
                        else if (var10 || !var9)
                        {
                            var5 = true;
                        }

                        var6 = true;
                    }
                    else if (var9 && !var10)
                    {
                        this.setItem(0 + var8, var7.getItem(var8));
                        var7.setItem(var8, (ItemStack)null);
                    }
                    else if (!var10 || var9)
                    {
                        var5 = true;
                    }
                }

                if (!var5)
                {
                    if (!var6)
                    {
                        var7.setItem(0, new ItemStack(mod_TubeStuff.itemUseless, 1, 0));
                    }
                    else if (this.updateTicks % 10 == 0)
                    {
                        ItemStack var14 = var7.getItem(0);

                        if (var14 != null && var14.id == mod_TubeStuff.itemUseless.id)
                        {
                            var7.setItem(0, (ItemStack)null);
                        }

                        this.redstone_output = !this.redstone_output;
                        this.notifyNeighbouringBlocks();
                    }
                }
            }
        }
    }

    private boolean checkTarget(int var1, int var2, IInventory var3, ItemStack var4)
    {
        if (var4 == null)
        {
            return true;
        }
        else
        {
            int var5 = var4.count;

            for (int var6 = var1; var6 < var2 && var5 > 0; ++var6)
            {
                ItemStack var7 = var3.getItem(var6);

                if (var7 != null && mod_TubeStuff.areItemsEqual(var4, var7))
                {
                    var5 -= var7.count;
                }
            }

            return var5 <= 0;
        }
    }

    public int getStartInventorySide(int var1)
    {
        return 18;
    }

    public int getSizeInventorySide(int var1)
    {
        return 1;
    }
}
