package immibis.tubestuff;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

import immibis.core.NonSharedProxy;
import immibis.core.TileCombined;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;

public class TileDuplicator extends TileCombined implements IInventory
{
    public ItemStack item = null;
    
    public static boolean canUse(EntityLiving var1) {
    	if(!(var1 instanceof EntityHuman))
    		return false;
    	Player pl = Bukkit.getPlayerExact(((EntityHuman)var1).name);
    	if(pl == null || !pl.hasPermission("tubestuff.duplicator"))
    		return false;
    	return true;
    }
    
	@Override
	public ItemStack[] getContents() {
		return new ItemStack[] {item};
	}

	@Override
	public void setMaxStackSize(int arg0) {
	}

    public void onPlaced(EntityLiving var1, int var2)
    {
        if (!canUse(var1))
        {
            if (var1 instanceof EntityHuman)
            {
                NonSharedProxy.sendChat((EntityHuman)var1, "Only ops can place duplicators.");
            }

            this.world.setRawTypeId(this.x, this.y, this.z, 0);
        }
    }

    public boolean onBlockActivated(EntityHuman var1)
    {
        if (this.world.isStatic)
        {
            return true;
        }
        else if (NonSharedProxy.SERVER && !NonSharedProxy.isOp(var1.name))
        {
            NonSharedProxy.sendChat(var1, "Only ops can open this GUI.");
            return true;
        }
        else
        {
            var1.openGui(mod_TubeStuff.instance, 5, this.world, this.x, this.y, this.z);
            return true;
        }
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);

        if (this.item != null)
        {
            NBTTagCompound var2 = new NBTTagCompound();
            this.item.save(var2);
            var1.set("item", var2);
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        NBTTagCompound var2 = var1.getCompound("item");

        if (var2 != null)
        {
            this.item = ItemStack.a(var2);
        }
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return this.item == null ? 0 : 1;
    }

    /**
     * Returns the stack in slot i
     */
    public ItemStack getItem(int var1)
    {
        return ItemStack.b(this.item);
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public ItemStack splitStack(int var1, int var2)
    {
        if (this.item == null)
        {
            return null;
        }
        else if (var2 >= this.item.count)
        {
            return this.item.cloneItemStack();
        }
        else
        {
            ItemStack var3 = this.item.cloneItemStack();
            var3.count = var2;
            return var3;
        }
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void setItem(int var1, ItemStack var2) {}

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "Duplicator";
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 64;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return false;
    }

    public void f() {}

    public void g() {}

    public IInventory getGuiInventory()
    {
        return new TileDuplicator.ItemEditingInventory((TileDuplicator.NamelessClass16259774)null);
    }

    private class ItemEditingInventory implements IInventory
    {
        private ItemEditingInventory() {}
        

		@Override
		public ItemStack[] getContents() {
			return new ItemStack[] {item};
        }
        
		@Override
        public InventoryHolder getOwner() {
        	return new InventoryHolder() {
        		@Override public Inventory getInventory() {
        			return new CraftInventory(ItemEditingInventory.this);
        		}
        	};
        }
        		
        List<HumanEntity> viewers = new LinkedList<HumanEntity>();
        
        @Override
        public List<HumanEntity> getViewers() {
        	return viewers;
        }
        
        @Override
        public void onClose(CraftHumanEntity arg0) {
        	viewers.remove(arg0);
        }
        
        @Override
        public void onOpen(CraftHumanEntity arg0) {
        	viewers.add(arg0);
        }
        
        @Override
        public void setMaxStackSize(int arg0) {
        }
		
        public int getSize()
        {
            return 1;
        }

        public ItemStack getItem(int var1)
        {
            return TileDuplicator.this.item;
        }

        public ItemStack splitStack(int var1, int var2)
        {
            if (var1 == 0 && TileDuplicator.this.item != null)
            {
                ItemStack var3;

                if (var2 >= TileDuplicator.this.item.count)
                {
                    var3 = TileDuplicator.this.item;
                    TileDuplicator.this.item = null;
                    return var3;
                }
                else
                {
                    var3 = TileDuplicator.this.item.cloneItemStack();
                    var3.count = var2;
                    TileDuplicator.this.item.count -= var2;
                    return var3;
                }
            }
            else
            {
                return null;
            }
        }

        public ItemStack splitWithoutUpdate(int var1)
        {
            return null;
        }

        public void setItem(int var1, ItemStack var2)
        {
            if (var1 == 0)
            {
                TileDuplicator.this.item = var2;
            }
        }

        public String getName()
        {
            return "Duplicator";
        }

        public int getMaxStackSize()
        {
            return 64;
        }

        public void update() {}

        public boolean a(EntityHuman var1)
        {
            if (!NonSharedProxy.isOp(var1.name))
            {
                return false;
            }
            else if (TileDuplicator.this.world.getTileEntity(TileDuplicator.this.x, TileDuplicator.this.y, TileDuplicator.this.z) != TileDuplicator.this)
            {
                return false;
            }
            else
            {
                double var2 = var1.e((double)TileDuplicator.this.x + 0.5D, (double)TileDuplicator.this.y + 0.5D, (double)TileDuplicator.this.z + 0.5D);
                return var2 <= 64.0D;
            }
        }

        public void f() {}

        public void g() {}

        ItemEditingInventory(TileDuplicator.NamelessClass16259774 var2)
        {
            this();
        }
    }

    static class NamelessClass16259774
    {
    }
}
