package immibis.tubestuff;

import immibis.core.Config;
import immibis.core.NonSharedProxy;
import immibis.core.config.ExtendedForgeConfigReader;
import immibis.core.config.IConfigReader;
import java.io.IOException;
import net.minecraft.server.Block;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ModLoader;

public class SharedProxy
{
    public static final boolean DEBUG_MODE = mod_TubeStuff.class.getName().equals("net.minecraft.server.mod_TubeStuff");
    public static boolean enableBHCParticles;
    public static boolean enableBHC;
    public static boolean enableBHCAnim;
    public static boolean enableCraftingIncinerator;
    public static IConfigReader redpowerConfig = null;

    static boolean CC_CheckArgs(Object[] var0, Class[] var1)
    {
        if (var0.length != var1.length)
        {
            return false;
        }
        else
        {
            for (int var2 = 0; var2 < var0.length; ++var2)
            {
                if (var0[var2].getClass() != var1[var2])
                {
                    return false;
                }
            }

            return true;
        }
    }

    private static Class findClass(String var0)
    {
        try
        {
            return SharedProxy.class.getClassLoader().loadClass("net.minecraft.server." + var0);
        }
        catch (ClassNotFoundException var4)
        {
            try
            {
                return SharedProxy.class.getClassLoader().loadClass(var0);
            }
            catch (ClassNotFoundException var3)
            {
                return null;
            }
        }
    }

    public static void FirstTick()
    {
        boolean var0 = true;
        int var1 = -1;
        int var2 = -1;
        boolean var3 = true;
        int var4 = -1;
        int var17;
        int var18;

        try
        {
            ExtendedForgeConfigReader var5 = new ExtendedForgeConfigReader("redpower/redpower.cfg");
            redpowerConfig = var5;

            try
            {
                var17 = Integer.parseInt(var5.getConfigEntry("blocks.machine.machine.id"));

                if (!Block.byId[var17].getClass().getName().equals("eloraam.machine.BlockMachine"))
                {
                    var17 = -1;
                }
            }
            catch (Exception var15)
            {
                System.out.println(mod_TubeStuff.class.getSimpleName() + ": RP2 Machine doesn\'t seem to be installed");
                var17 = -1;
            }

            try
            {
                var18 = Integer.parseInt(var5.getConfigEntry("blocks.logic.logic.id"));

                if (!Block.byId[var18].getClass().getName().equals("eloraam.logic.BlockLogic"))
                {
                    var18 = -1;
                }
            }
            catch (Exception var14)
            {
                System.out.println(mod_TubeStuff.class.getSimpleName() + ": RP2 Logic doesn\'t seem to be installed");
                var18 = -1;
            }
        }
        catch (IOException var16)
        {
            System.out.println(mod_TubeStuff.class.getSimpleName() + ": RP2 doesn\'t seem to be installed");
            var18 = -1;
            var17 = -1;
        }

        ClassLoader var19 = SharedProxy.class.getClassLoader();
        Class var6;

        try
        {
            var6 = findClass("BuildCraftTransport");

            if (var6 != null)
            {
                var1 = ((Item)var6.getDeclaredField("pipeItemsWood").get((Object)null)).id;
            }
        }
        catch (Exception var13)
        {
            System.out.println(mod_TubeStuff.class.getSimpleName() + ": BC Transport doesn\'t seem to be installed");
        }

        try
        {
            var6 = findClass("BuildCraftEnergy");

            if (var6 != null)
            {
                var2 = ((Block)var6.getDeclaredField("engineBlock").get((Object)null)).id;
            }
        }
        catch (Exception var12)
        {
            System.out.println(mod_TubeStuff.class.getSimpleName() + ": BC Energy doesn\'t seem to be installed");
        }

        try
        {
            var6 = findClass("BuildCraftFactory");

            if (var6 != null)
            {
                var4 = ((Block)var6.getDeclaredField("autoWorkbenchBlock").get((Object)null)).id;
            }
        }
        catch (Exception var11)
        {
            System.out.println(mod_TubeStuff.class.getSimpleName() + ": BC Factory doesn\'t seem to be installed");
        }

        ItemStack var20 = new ItemStack(mod_TubeStuff.block, 1, 0);
        ItemStack var7 = new ItemStack(mod_TubeStuff.block, 1, 1);
        ItemStack var8 = new ItemStack(mod_TubeStuff.block, 1, 2);
        new ItemStack(mod_TubeStuff.block, 1, 3);
        new ItemStack(mod_TubeStuff.block, 1, 4);

        if (var17 != -1)
        {
            if (var18 != -1)
            {
                ModLoader.addShapelessRecipe(var20, new Object[] {new ItemStack(var17, 1, 3), Block.CHEST, new ItemStack(var18, 1, 0)});
            }
            else
            {
                ModLoader.addShapelessRecipe(var20, new Object[] {new ItemStack(var17, 1, 3), Block.CHEST});
            }

            ModLoader.addRecipe(var7, new Object[] {"GFG", "WCW", "WcW", 'F', new ItemStack(var17, 1, 3), 'G', Item.GOLD_INGOT, 'C', Block.WORKBENCH, 'c', Block.CHEST, 'W', Block.WOOD});
        }
        else
        {
            ModLoader.addRecipe(var7, new Object[] {"GGG", "WCW", "WcW", 'G', Item.GOLD_INGOT, 'C', Block.WORKBENCH, 'c', Block.CHEST, 'W', Block.WOOD});
        }

        if (var1 != -1)
        {
            if (var2 != -1)
            {
                ModLoader.addShapelessRecipe(var20, new Object[] {Item.byId[var1], Block.CHEST, new ItemStack(var2, 1, 0)});
            }
            else
            {
                ModLoader.addShapelessRecipe(var20, new Object[] {Item.byId[var1], Block.CHEST});
            }

            ModLoader.addRecipe(var7, new Object[] {"PWP", "WCW", "PcP", 'G', Item.GOLD_INGOT, 'C', var4 == -1 ? Block.WORKBENCH : Block.byId[var4], 'c', Block.CHEST, 'W', Item.byId[var1], 'P', Block.WOOD});
        }

        if (NonSharedProxy.CLIENT)
        {
            enableBHC = Config.getBoolean("tubestuff.enableBlackHoleChest", false);
            enableBHCAnim = Config.getBoolean("tubestuff.enableBHCAnim", true);
            enableBHCParticles = Config.getBoolean("tubestuff.enableBHCParticles", true);

            if (enableBHC)
            {
                ModLoader.addRecipe(var8, new Object[] {"ODO", "OCO", "ODO", 'O', Block.OBSIDIAN, 'C', Block.CHEST, 'D', Block.DIAMOND_BLOCK});
            }
        }

        if (enableCraftingIncinerator = Config.getBoolean("tubestuff.enableCraftingIncinerator", true))
        {
            ModLoader.addRecipe(new ItemStack(mod_TubeStuff.block, 1, 3), new Object[] {"CCC", "CLC", "CCC", 'C', Block.COBBLESTONE, 'L', Item.LAVA_BUCKET});
        }

        if (var17 != -1)
        {
            ModLoader.addRecipe(new ItemStack(mod_TubeStuff.block, 1, 5), new Object[] {"WWW", "R T", "WWW", 'R', new ItemStack(var17, 1, 10), 'T', new ItemStack(var17, 1, 2), 'W', new ItemStack(Block.WOOD, 1, -1)});
        }
    }
}
