package mods.immibis.tubestuff;

import java.util.ArrayList;
import java.util.List;

import mods.immibis.core.TileCombined;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileMCT2 extends TileCombined {
	public class EditingInventory {

	}
	
	public EditingInventory getEditingInventory() {
		return null;
	}

	public static class Recipe {
		public ItemStack[] input = new ItemStack[9];
		public ItemStack cachedOutput;
		
		public void writeToNBT(NBTTagCompound tag) {
			tag.setInteger("inl", input.length);
			for(int k = 0; k < input.length; k++) {
				if(input[k] != null) {
					NBTTagCompound in_t = new NBTTagCompound();
					input[k].writeToNBT(in_t);
					tag.setCompoundTag("in" + k, in_t);
				}
			}
		}
		
		public void readFromNBT(NBTTagCompound tag) {
			input = new ItemStack[tag.getInteger("inl")];
			for(int k = 0; k < input.length; k++)
				if(tag.hasKey("in" + k))
					input[k] = ItemStack.loadItemStackFromNBT(tag.getCompoundTag("in" + k));
		}
	}
	
	private List<Recipe> recipes = new ArrayList<Recipe>();
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		
		NBTTagList rlt = new NBTTagList();
		for(Recipe r : recipes) {
			NBTTagCompound rt = new NBTTagCompound();
			r.writeToNBT(rt);
			rlt.appendTag(rt);
		}
		tag.setTag("recipes", rlt);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		
		recipes.clear();
		NBTTagList rlt = tag.getTagList("recipes");
		for(int k = 0; k < rlt.tagCount(); k++) {
			Recipe r = new Recipe();
			r.readFromNBT((NBTTagCompound)rlt.tagAt(k));
			recipes.add(r);
		}
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		if(!worldObj.isRemote)
			player.openGui(TubeStuff.instance, TubeStuff.GUI_MCT2_EDIT, worldObj, xCoord, yCoord, zCoord);
		return true;
	}
}
