package immibis.tubestuff;

import immibis.core.Config;
import immibis.core.config.ExtendedForgeConfigReader;
import immibis.core.config.IConfigReader;

import java.io.IOException;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.oredict.ShapedOreRecipe;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

// TODO: move this stuff into the main mod file

public class SharedProxy {
	static boolean CC_CheckArgs(Object[] objs, Class[] types)
	{
		if(objs.length != types.length)
			return false;
		for(int k = 0; k < objs.length; k++)
			if(objs[k].getClass() != types[k])
				return false;
		return true;
	}
	
	public static final boolean DEBUG_MODE = TubeStuff.class.getName().equals("net.minecraft.src.mod_TubeStuff");
	
	public static boolean enableBHCParticles, enableBHC, enableBHCAnim, enableCraftingIncinerator;
	public static boolean enableCraftingRetrievulator, enableStorageBlocks, enableStorageBlocksVanilla, enableStorageBlockOreDictionary;
	public static boolean enableCraftingBlockBreaker;
	
	private static Class findBCClass(String name)
	{
		try
		{
			return SharedProxy.class.getClassLoader().loadClass("buildcraft."+name);
		}
		catch(ClassNotFoundException e)
		{
			return null;
		}
	}
	
	public static IConfigReader redpowerConfig = null;
	
	public static void FirstTick() {
		int machineID = -1;
		int woodenPipeID = -1;
		int engineID = -1;
		int logicID = -1;
		int actID = -1;
		
		try
		{
			ExtendedForgeConfigReader reader = new ExtendedForgeConfigReader("redpower/redpower.cfg");
			
			redpowerConfig = reader;
		
			try
			{
				machineID = Integer.parseInt(reader.getConfigEntry("blocks.machine.machine.id"));
				if(!Block.blocksList[machineID].getClass().getName().equals("eloraam.machine.BlockMachine"))
					machineID = -1;
			}
			catch(Exception e)
			{
				System.out.println(TubeStuff.class.getSimpleName()+": RP2 Machine doesn't seem to be installed");
				machineID = -1;
			}

			try
			{
				logicID = Integer.parseInt(reader.getConfigEntry("blocks.logic.logic.id"));
				if(!Block.blocksList[logicID].getClass().getName().equals("eloraam.logic.BlockLogic"))
					logicID = -1;
			}
			catch(Exception e)
			{
				System.out.println(TubeStuff.class.getSimpleName()+": RP2 Logic doesn't seem to be installed");
				logicID = -1;
			}
		}
		catch(IOException e)
		{
			System.out.println(TubeStuff.class.getSimpleName()+": RP2 doesn't seem to be installed");
			logicID = -1;
			machineID = -1;
		}
		
		try
		{
			Class bcTransport = findBCClass("BuildCraftTransport");
			if(bcTransport != null)
				woodenPipeID = ((Item)bcTransport.getDeclaredField("pipeItemsWood").get(null)).shiftedIndex;
		}
		catch(Exception e)
		{
			System.out.println(TubeStuff.class.getSimpleName()+": BC Transport doesn't seem to be installed");
		}

		try
		{
			Class bcEnergy = findBCClass("BuildCraftEnergy");
			if(bcEnergy != null)
				engineID = ((Block)bcEnergy.getDeclaredField("engineBlock").get(null)).blockID;
		}
		catch(Exception e)
		{
			System.out.println(TubeStuff.class.getSimpleName()+": BC Energy doesn't seem to be installed");
		}
		
		try
		{
			Class bcFactory = findBCClass("BuildCraftFactory");
			if(bcFactory != null)
				actID = ((Block)bcFactory.getDeclaredField("autoWorkbenchBlock").get(null)).blockID;
		}
		catch(Exception e)
		{
			System.out.println(TubeStuff.class.getSimpleName()+": BC Factory doesn't seem to be installed");
		}
		
		ItemStack bufferIS = new ItemStack(TubeStuff.block, 1, 0);
		ItemStack actIS = new ItemStack(TubeStuff.block, 1, 1);
		ItemStack infChestIS = new ItemStack(TubeStuff.block, 1, 2);
		
		if(machineID != -1)
		{
			if(logicID != -1)
				ModLoader.addShapelessRecipe(bufferIS, new Object[] {
					new ItemStack(machineID, 1, 3), // filter
					Block.chest,
					new ItemStack(logicID, 1, 0) // timer
				});
			else
				ModLoader.addShapelessRecipe(bufferIS, new Object[] {
					new ItemStack(machineID, 1, 3), // filter
					Block.chest
				});
			ModLoader.addRecipe(actIS, new Object[] {
				"GFG",
				"WCW",
				"WcW",
				'F', new ItemStack(machineID, 1, 3), // filter
				'G', Item.ingotGold,
				'C', Block.workbench,
				'c', Block.chest,
				'W', Block.planks
			});
		}
		else
		{
			ModLoader.addRecipe	(actIS, new Object[] {
				"GGG",
				"WCW",
				"WcW",
				'G', Item.ingotGold,
				'C', Block.workbench,
				'c', Block.chest,
				'W', Block.planks
			});
		}
		if(woodenPipeID != -1)
		{
			if(engineID != -1)
				ModLoader.addShapelessRecipe(bufferIS, new Object[] {
					Item.itemsList[woodenPipeID],
					Block.chest,
					new ItemStack(engineID, 1, 0) // redstone engine
				});
			else
				ModLoader.addShapelessRecipe(bufferIS, new Object[] {
					Item.itemsList[woodenPipeID],
					Block.chest
				});
			
			ModLoader.addRecipe(actIS, new Object[] {
				"PWP",
				"WCW",
				"PcP",
				'G', Item.ingotGold,
				'C', actID == -1 ? Block.workbench : Block.blocksList[actID],
				'c', Block.chest,
				'W', Item.itemsList[woodenPipeID],
				'P', Block.planks
			});
		}
		
		enableBHC = Config.getBoolean("tubestuff.enableBlackHoleChest", false);
		
		if(enableBHC) {
			ModLoader.addRecipe(infChestIS, new Object[] {
				"ODO",
				"OCO",
				"ODO",
				'O', Block.obsidian,
				'C', Block.chest,
				'D', Block.blockDiamond
			});
		}
		
		enableBHCAnim = Config.getBoolean("tubestuff.enableBHCAnim", true);
		enableBHCParticles = Config.getBoolean("tubestuff.enableBHCParticles", true);
		
		if(enableCraftingIncinerator = Config.getBoolean("tubestuff.enableCraftingIncinerator", true))
		{
			// Incinerator
			
			ModLoader.addRecipe(new ItemStack(TubeStuff.block, 1, 3), new Object[] {
				"CCC",
				"CLC",
				"CCC",
				'C', Block.cobblestone,
				'L', Item.bucketLava
			});
		}
		
		enableCraftingRetrievulator = Config.getBoolean("tubestuff.enableCraftingRetrievulator", true);
		
		if(machineID != -1 && enableCraftingRetrievulator) {
			// Retrievulator
			ModLoader.addRecipe(new ItemStack(TubeStuff.block, 1, 5), new Object[] {
				"WWW",
				"R T",
				"WWW",
				'R', new ItemStack(machineID, 1, 10), // regulator
				'T', new ItemStack(machineID, 1, 2), // transposer
				'W', new ItemStack(Block.planks, 1, -1)
			});
		}
		
		if(enableCraftingBlockBreaker = Config.getBoolean("tubestuff.enableCraftingBlockBreaker", true)) {
			ModLoader.addRecipe(new ItemStack(TubeStuff.block, 4, 6), new Object[] {
				"O O",
				"---",
				"OXO",
				'O', Block.obsidian,
				'-', Item.stick,
				'X', Block.pistonStickyBase
			});
		}
		
		
		
		if(enableStorageBlocks) {
			addStorageRecipes(0, RedPowerItems.silverIS, enableStorageBlocks, "ingotSilver");
			addStorageRecipes(1, RedPowerItems.tinIS, enableStorageBlocks, "ingotTin");
			addStorageRecipes(2, RedPowerItems.copperIS, enableStorageBlocks, "ingotCopper");
			addStorageRecipes(3, RedPowerItems.nikoliteIS, enableStorageBlocks, null);
			addStorageRecipes(4, new ItemStack(Item.coal, 1, 0), enableStorageBlocksVanilla, null);
			addStorageRecipes(5, new ItemStack(Item.redstone, 1, 0), enableStorageBlocksVanilla, null);
			addStorageRecipes(6, RedPowerItems.blueAlloyIS, enableStorageBlocks, null);
			addStorageRecipes(7, RedPowerItems.redAlloyIS, enableStorageBlocks, null);
			addStorageRecipes(8, RedPowerItems.brassIS, enableStorageBlocks, "ingotBrass");
			addStorageRecipes(9, new ItemStack(Item.coal, 1, 1), enableStorageBlocksVanilla, null);
		}
	}
	
	private static void addStorageRecipes(int block_meta, ItemStack item, boolean enable, String oreName) {
		
		if(enable) {
			if(item != null)
				ModLoader.addRecipe(new ItemStack(TubeStuff.blockStorage, 1, block_meta), "###", "###", "###", '#', item);
			if(enableStorageBlockOreDictionary && oreName != null)
				CraftingManager.getInstance().getRecipeList().add(new ShapedOreRecipe(new ItemStack(TubeStuff.blockStorage, 1, block_meta), "###", "###", "###", '#', oreName));
		}
		
		// decompressing recipe is always enabled
		ItemStack result;
		if(item != null)
			result = item.copy();
		else if(enableStorageBlockOreDictionary && oreName != null) {
			List<ItemStack> ores = net.minecraftforge.oredict.OreDictionary.getOres(oreName);
			if(ores.isEmpty())
				result = null;
			else
				result = ores.get(0).copy();
		} else
			result = null;
		
		if(result != null) {
			result.stackSize = 9;
			ModLoader.addRecipe(result, "#", '#', new ItemStack(TubeStuff.blockStorage, 1, block_meta));
		}
	}
	
	@SideOnly(Side.CLIENT)
	public static boolean enableBHCAnim() {
		GameSettings gs = ModLoader.getMinecraftInstance().gameSettings;
		return enableBHCAnim && !gs.anaglyph && gs.fancyGraphics;
	}
}
