package mods.immibis.recycling;

import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;

import java.util.ArrayList;
import java.util.List;

import mods.immibis.core.api.FMLModInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import net.minecraftforge.oredict.OreDictionary;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;

@Mod(modid="SimpleRecycling", name="Simple Recycling", version="57.0.0")
@NetworkMod(serverSideRequired=false, clientSideRequired=false)
@FMLModInfo(
	url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
	description="Allows you to turn tools back into ingots or dusts.",
	authors="immibis"
	)
public class SimpleRecycling {
	
	private static class IC2 {
		public ItemStack getMacerated(ItemStack stack) {
			RecipeOutput out = Recipes.macerator.getOutputFor(stack, false);
			return out == null ? null : out.items.get(0);
		}

		public void addMaceratorRecipe(ItemStack in, ItemStack out) {
			Recipes.macerator.addRecipe(new RecipeInputItemStack(in), null, out);
		}
	}
	
	private static class BlockMetaPair {
		public int id, data;
		
		public BlockMetaPair(int blockID, int k) {
			this.id = blockID;
			this.data = k;
		}

		public static BlockMetaPair parse(String s) {
			String[] a = s.split(":");
			if(a.length != 2)
				throw new NumberFormatException("Not a valid id:meta pair: " + s);
			return new BlockMetaPair(Integer.parseInt(a[0]), Integer.parseInt(a[1]));
		}
		
		public ItemStack toItemStack() {
			return new ItemStack(id, 1, data);
		}
	}
	
	List<BlockMetaPair> ingots = new ArrayList<BlockMetaPair>();
	List<BlockMetaPair> gems = new ArrayList<BlockMetaPair>();
	boolean smelt, macerate;
	IC2 ic2;
	
	@EventHandler
	public void onPreInit(FMLPreInitializationEvent evt) {
		Configuration c = new Configuration(evt.getSuggestedConfigurationFile());
		c.load();
		
		boolean dirty = false;
		
		Property ingotsProp = c.get(Configuration.CATEGORY_GENERAL, "ingots", "");
		String COMMENT = "List of id:meta pairs, separated by semicolons. Example: 9001:2;4567:100";
		if(!COMMENT.equals(ingotsProp.comment)) {
			ingotsProp.comment = COMMENT;
			dirty = true;
		}
		
		Property gemsProp = c.get(Configuration.CATEGORY_GENERAL, "gems", "");
		COMMENT = "List of id:meta pairs, separated by semicolons. Example: 9001:2;4567:100";
		if(!COMMENT.equals(gemsProp.comment)) {
			gemsProp.comment = COMMENT;
			dirty = true;
		}
		
		for(String p : ingotsProp.getString().split(";"))
			if(!p.equals(""))
				ingots.add(BlockMetaPair.parse(p));
		
		for(String p : gemsProp.getString().split(";"))
			if(!p.equals(""))
				gems.add(BlockMetaPair.parse(p));
		
		smelt = c.get(Configuration.CATEGORY_GENERAL, "allowSmelting", true).getBoolean(true);
		macerate = c.get(Configuration.CATEGORY_GENERAL, "allowMacerating", true).getBoolean(true);
		
		if(dirty || c.hasChanged())
			c.save();
	}
	
	@EventHandler
	public void onPostInit(FMLPostInitializationEvent evt) {
		InventoryCrafting ic = new InventoryCrafting(new Container() {
			@Override
			public boolean canInteractWith(EntityPlayer entityplayer) {
				return false;
			}
		}, 3, 3);
		
		if(Loader.isModLoaded("IC2"))
			ic2 = new IC2();
		
		for(BlockMetaPair bmp : ingots) register(ic, true, bmp.toItemStack());
		for(BlockMetaPair bmp : gems) register(ic, true, bmp.toItemStack());
		
		for(String oreName : OreDictionary.getOreNames()) {
			List<ItemStack> ores = OreDictionary.getOres(oreName);
			if(ores.size() == 0)
				continue;
			
			if(oreName.startsWith("ingot"))
				register(ic, true, ores.get(0));
			else
				register(ic, false, ores.get(0));
		}
		
		register(ic, false, new ItemStack(Item.diamond));
	}
	
	private void register(InventoryCrafting ic, boolean canSmelt, ItemStack ingotStack, String pattern) {
		int numIngots = 0;
		for(int k = 0; k < 9; k++)
		{
			char c = pattern.charAt(k);
			if(c == '#') {
				ic.setInventorySlotContents(k, ingotStack);
				numIngots++;
			} else if(c == ' ')
				ic.setInventorySlotContents(k, null);
			else if(c == '|')
				ic.setInventorySlotContents(k, new ItemStack(Item.stick));
			else
				throw new RuntimeException("pattern char "+c);
		}
		
		ItemStack craftedItem;
		try {
			craftedItem = CraftingManager.getInstance().findMatchingRecipe(ic, null);
		} catch(Exception e) {
			new Exception("[Simple Recycling] Caught exception looking up recipe for item '"+ingotStack+"' pattern '"+pattern+"'", e).printStackTrace();
			return;
		}
		
		if(craftedItem == null)
			return;
		
		// add smelting recipe, if smelting recipes are enabled, this item is smeltable, and the recipe doesn't already exist
		if(smelt && canSmelt && FurnaceRecipes.smelting().getSmeltingResult(craftedItem) == null) {
			ItemStack smeltingOutput = ingotStack.copy();
			smeltingOutput.stackSize = numIngots;
			
			//if(craftedItem.getItem().isDamageable())
			//	FurnaceRecipes.smelting().addSmelting(craftedItem.itemID, smeltingOutput, 0);
			//else
				FurnaceRecipes.smelting().addSmelting(craftedItem.itemID, craftedItem.getItemDamage(), smeltingOutput, 0);
		}
		
		if(macerate && ic2 != null && ic2.getMacerated(craftedItem) == null) {
			ItemStack maceratingOutput = ic2.getMacerated(ingotStack);
			if(maceratingOutput != null) {
				maceratingOutput = maceratingOutput.copy();
				maceratingOutput.stackSize = numIngots;
				
				ic2.addMaceratorRecipe(craftedItem, maceratingOutput);
			}
		}
	}
	
	private void register(InventoryCrafting ic, boolean canSmelt, ItemStack ingotStack) {
		register(ic, canSmelt, ingotStack, "### |  | "); // pickaxe
		register(ic, canSmelt, ingotStack, " #  |  | "); // shovel
		register(ic, canSmelt, ingotStack, "## #|  | "); // axe (1)
		register(ic, canSmelt, ingotStack, " ## |# | "); // axe (2)
		register(ic, canSmelt, ingotStack, " #  #  | "); // sword
		register(ic, canSmelt, ingotStack, "##  |  | "); // hoe (1)
		register(ic, canSmelt, ingotStack, " ## |  | "); // hoe (2)
		register(ic, canSmelt, ingotStack, "     # # "); // shears (1)
		register(ic, canSmelt, ingotStack, "    #   #"); // shears (2)
		register(ic, canSmelt, ingotStack, " #   #|# "); // sickle
		register(ic, canSmelt, ingotStack, "#### ## #"); // leggings
		register(ic, canSmelt, ingotStack, "#### #   "); // helmet
		register(ic, canSmelt, ingotStack, "# #######"); // chestplate
		register(ic, canSmelt, ingotStack, "# ## #   "); // boots
	}
}
