package mods.immibis.redlogic.chips.ingame;

import java.util.ArrayList;

import mods.immibis.redlogic.RedLogicMod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCustomCircuit extends BlockContainer {
	@Override
	public TileEntity createNewTileEntity(World world) {
		return new TileCustomCircuit();
	}
	
	public BlockCustomCircuit(int id) {
		super(id, RedLogicMod.circuitMaterial);
		setHardness(0.25f);
		setUnlocalizedName("redlogic.custom-circuit");
		setTextureName("redlogic:chip/chip");
	}
	
	private String lastBrokenClassName;
	
	@Override
	public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
		TileEntity te = par1World.getBlockTileEntity(par2, par3, par4);
		if(te instanceof TileCustomCircuit)
			lastBrokenClassName = ((TileCustomCircuit)te).getClassName();
		super.breakBlock(par1World, par2, par3, par4, par5, par6);
	}
	
	@Override
	public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
		ArrayList<ItemStack> rv = new ArrayList<ItemStack>();
		TileEntity te = world.getBlockTileEntity(x, y, z);
		if(te instanceof TileCustomCircuit) {
			rv.add(ItemChip.createItemStack(((TileCustomCircuit) te).getClassName()));
		} else if(lastBrokenClassName != null) {
			rv.add(ItemChip.createItemStack(lastBrokenClassName));
			lastBrokenClassName = null;
		}
		return rv;
	}
	
	@Override
	public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
		if(par5 > 0 && Block.blocksList[par5].canProvidePower())
			((TileCustomCircuit)par1World.getBlockTileEntity(par2, par3, par4)).onRedstoneInputChanged();
	}
	
	@Override
	public boolean canProvidePower() {
		return true;
	}
	
	@Override
	public int isProvidingStrongPower(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
		return ((TileCustomCircuit)par1iBlockAccess.getBlockTileEntity(par2, par3, par4)).getEmittedSignalStrength(-1, par5);
	}
	
	@Override
	public int isProvidingWeakPower(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
		return ((TileCustomCircuit)par1iBlockAccess.getBlockTileEntity(par2, par3, par4)).getEmittedSignalStrength(-1, par5);
	}
	
	@Override
	public boolean isBlockNormalCube(World world, int x, int y, int z) {
		return false;
	}
}
