package mods.immibis.redlogic.wires;

import mods.immibis.core.api.util.Dir;
import mods.immibis.microblocks.api.EnumPosition;
import mods.immibis.microblocks.api.IMicroblockSupporterTile;
import mods.immibis.microblocks.api.MicroblockAPIUtils;
import mods.immibis.microblocks.api.Part;
import mods.immibis.redlogic.RedLogicMod;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class WireItem extends ItemBlock {
	
	public WireItem(int id_minus_256) {
		super(id_minus_256);
		setHasSubtypes(true);
	}
	
	@Override
	public String getUnlocalizedName(ItemStack is) {
		return "immibis.redlogic.wire."+is.getItemDamage();
	}
	
	@Override
	public boolean onItemUse(ItemStack stack, EntityPlayer ply, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
		int var11 = w.getBlockId(x, y, z);
		
		int meta = stack.getItemDamage();
		if(meta < 0 || meta >= EnumWires.VALUES.length)
			return false;
		
		if(!w.isBlockSolidOnSide(x, y, z, ForgeDirection.VALID_DIRECTIONS[side], false))
			return false;

        EnumWires type = EnumWires.VALUES[meta];
		
		boolean mergeIntoWireTile = false;
		boolean mergeIntoMicroblockTile = false;
		
		Block microblockContainerBlock = MicroblockAPIUtils.getMicroblockContainerBlock();
		
		if (var11 == Block.snow.blockID)
            side = 1;
        else if (!mergeIntoWireTile && var11 != Block.vine.blockID && var11 != Block.tallGrass.blockID && var11 != Block.deadBush.blockID && (Block.blocksList[var11] == null || !Block.blocksList[var11].isBlockReplaceable(w, x, y, z)))
        {
        	switch(side) {
        	case Dir.NX: x--; break;
        	case Dir.PX: x++; break;
        	case Dir.NY: y--; break;
        	case Dir.PY: y++; break;
        	case Dir.NZ: z--; break;
        	case Dir.PZ: z++; break;
        	}
        	
        	mergeIntoWireTile = w.getBlockId(x, y, z) == RedLogicMod.wire.blockID && ((WireTile)w.getBlockTileEntity(x, y, z)).canPlaceWireOnSide(type, side ^ 1);
        	mergeIntoMicroblockTile = microblockContainerBlock != null && w.getBlockId(x, y, z) == microblockContainerBlock.blockID && !((IMicroblockSupporterTile)w.getBlockTileEntity(x, y, z)).getCoverSystem().isPositionOccupied(EnumPosition.getFacePosition(side ^ 1));
        }

        if (stack.stackSize == 0)
            return false;
        else if (!ply.canPlayerEdit(x, y, z, side, stack))
            return false;
        else if(mergeIntoWireTile) {
        	if(w.isRemote)
        		return true;
        	
        	WireTile wt = (WireTile)w.getBlockTileEntity(x, y, z);
        	
        	if(wt.addWire(type, side ^ 1)) {
        		Block var12 = Block.blocksList[itemID];
        		w.playSoundEffect(x + 0.5, y + 0.5, z + 0.5, var12.stepSound.getPlaceSound(), (var12.stepSound.getVolume() + 1.0F) / 2.0F, var12.stepSound.getPitch() * 0.8F);
        		--stack.stackSize;
        	}
        	
        	return true;
        	
        } else if(mergeIntoMicroblockTile) {
        	if(w.isRemote)
        		return true;
        	
        	IMicroblockSupporterTile oldTile = (IMicroblockSupporterTile)w.getBlockTileEntity(x, y, z);
        	
        	WireTile tile;
        	
        	try {
				tile = EnumWires.VALUES[meta].teclass.getConstructor().newInstance();
			} catch(Exception e) {
				throw new RuntimeException(e);
			}
        	
        	tile.rawAddWire(type, side ^ 1);
        	for(Part p : oldTile.getCoverSystem().getAllParts())
        		tile.getCoverSystem().addPart(p);

        	// don't cause block or client update before tile is set
        	w.setBlock(x, y, z, RedLogicMod.wire.blockID, EnumWires.CLASS_TO_META.get(tile.getClass()), 0);
        	w.setBlockTileEntity(x, y, z, tile);
        	w.notifyBlocksOfNeighborChange(x, y, z, RedLogicMod.wire.blockID);
        	w.markBlockForUpdate(x, y, z);
        	
        	Block var12 = Block.blocksList[itemID];
    		w.playSoundEffect(x + 0.5, y + 0.5, z + 0.5, var12.stepSound.getPlaceSound(), (var12.stepSound.getVolume() + 1.0F) / 2.0F, var12.stepSound.getPitch() * 0.8F);
    		--stack.stackSize;
    		
    		tile.notifyExtendedNeighbours();
        	
        	return true;
        	
        } else if (w.canPlaceEntityOnSide(this.itemID, x, y, z, false, side, ply, stack)) {
        	if(w.isRemote)
        		return true;
        	
            Block var12 = Block.blocksList[this.itemID];
            int var13 = this.getMetadata(stack.getItemDamage());

            if (placeBlockAt(stack, ply, w, x, y, z, side, hitX, hitY, hitZ, var13))
            {
                w.playSoundEffect(x + 0.5, y + 0.5, z + 0.5, var12.stepSound.getPlaceSound(), (var12.stepSound.getVolume() + 1.0F) / 2.0F, var12.stepSound.getPitch() * 0.8F);
                --stack.stackSize;
            }

            return true;
        }
        else
        {
            return false;
        }
	}
	
	@Override
	public boolean canPlaceItemBlockOnSide(World w, int x, int y, int z, int side, EntityPlayer ply, ItemStack stack) {
		int var11 = w.getBlockId(x, y, z);
		
		int meta = stack.getItemDamage();
		if(meta < 0 || meta >= EnumWires.VALUES.length)
			return false;
		
		if(!w.isBlockSolidOnSide(x, y, z, ForgeDirection.VALID_DIRECTIONS[side], false))
			return false;
		
		EnumWires type = EnumWires.VALUES[meta];
		
		boolean mergeIntoWireTile = false;
		boolean mergeIntoMicroblockTile = false;

		Block microblockContainerBlock = MicroblockAPIUtils.getMicroblockContainerBlock();
		
		if (var11 == Block.snow.blockID)
            side = 1;
        else if (!mergeIntoWireTile && !mergeIntoMicroblockTile && var11 != Block.vine.blockID && var11 != Block.tallGrass.blockID && var11 != Block.deadBush.blockID && (Block.blocksList[var11] == null || !Block.blocksList[var11].isBlockReplaceable(w, x, y, z)))
        {
        	switch(side) {
        	case Dir.NX: x--; break;
        	case Dir.PX: x++; break;
        	case Dir.NY: y--; break;
        	case Dir.PY: y++; break;
        	case Dir.NZ: z--; break;
        	case Dir.PZ: z++; break;
        	}
        	
        	mergeIntoWireTile = w.getBlockId(x, y, z) == RedLogicMod.wire.blockID && ((WireTile)w.getBlockTileEntity(x, y, z)).canPlaceWireOnSide(type, side ^ 1);
        	mergeIntoMicroblockTile = microblockContainerBlock != null && w.getBlockId(x, y, z) == microblockContainerBlock.blockID && !((IMicroblockSupporterTile)w.getBlockTileEntity(x, y, z)).getCoverSystem().isPositionOccupied(EnumPosition.getFacePosition(side ^ 1));
        }
        
        return mergeIntoMicroblockTile || mergeIntoWireTile || w.canPlaceEntityOnSide(this.itemID, x, y, z, false, side, ply, stack);
	}
	
	@Override
	public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
		int damage = stack.getItemDamage();
		if(damage < 0 || damage >= EnumWires.VALUES.length)
			return false;
		
		EnumWires type = EnumWires.VALUES[damage];
		
		if(!world.setBlock(x, y, z, itemID, EnumWires.CLASS_TO_META.get(type.teclass), 3))
			return false;
		
		if(world.getBlockId(x, y, z) == itemID) {
			Block.blocksList[itemID].onBlockPlacedBy(world, x, y, z, player, stack);
			
			WireTile tile;
			
			try {
				tile = type.teclass.getConstructor().newInstance();
			} catch(Exception e) {
				throw new RuntimeException(e);
			}
			
			tile.rawAddWire(type, side ^ 1);
			world.setBlockTileEntity(x, y, z, tile);
			tile.notifyExtendedNeighbours();
		}

		return true;
	}
	
	@Override
	public int getMetadata(int par1) {
		return par1;
	}
}
