package mods.immibis.redlogic.wires;

import mods.immibis.core.api.porting.PortableBlockRenderer;
import mods.immibis.core.api.util.Dir;
import mods.immibis.redlogic.RotatedTessellator;
import mods.immibis.redlogic.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class StaticRenderer implements PortableBlockRenderer {
	
	private RotatedTessellator rt = new RotatedTessellator();
	
	public final static StaticRenderer instance = new StaticRenderer();
	
	public void renderWorld(RenderBlocks render, EnumWires type, WireTile wt, int sideMask) {
		
		int x = wt.xCoord, y = wt.yCoord, z = wt.zCoord;
		
		rt.base = Tessellator.instance;
		rt.flipped = false;
		rt.x = x;
		rt.y = y;
		rt.z = z;
		
		mods.immibis.core.RenderUtilsIC.setBrightness(wt.worldObj, x, y, z);
		rt.base.setColorOpaque_I(wt.getWireColour());
		
		
		for(int side = 0; side < 6; side++) {
			if((sideMask & (1 << side)) == 0)
				continue;
			
			rt.front = side < 2 ? 2 : 0; // anything not parallel to side
			rt.side = side;
			
			//System.out.println("rendering side "+side);
			
			int[] dirMap = Utils.dirMap[rt.side][rt.front];
			
			boolean front = wt.connectsInDirection(side, dirMap[Utils.FRONT]);
			boolean back = wt.connectsInDirection(side, dirMap[Utils.BACK]);
			boolean left = wt.connectsInDirection(side, dirMap[Utils.LEFT]);
			boolean right = wt.connectsInDirection(side, dirMap[Utils.RIGHT]);
			
			boolean frontCorner = front && wt.connectsInDirectionAroundCorner(side, dirMap[Utils.FRONT]);
			boolean backCorner = back && wt.connectsInDirectionAroundCorner(side, dirMap[Utils.BACK]);
			boolean leftCorner = left && wt.connectsInDirectionAroundCorner(side, dirMap[Utils.LEFT]);
			boolean rightCorner = right && wt.connectsInDirectionAroundCorner(side, dirMap[Utils.RIGHT]);
			
			boolean forceEndCaps = true; // TODO optimize if necessary
			
			renderWireSide(type, front, back, left, right, frontCorner, backCorner, leftCorner, rightCorner, forceEndCaps);
		}
	}

	@Override
	public boolean renderWorldBlock(RenderBlocks render, IBlockAccess world, int x, int y, int z, Block block, int model) {
		WireTile wt = (WireTile)world.getBlockTileEntity(x, y, z);
		EnumWires type = wt.getType();
		//System.out.println("render wire with type "+type+", sidemask "+wt.getSideMask());
		if(type == null)
			return false;
		
		byte sideMask = wt.getSideMask();
		
		renderWorld(render, type, wt, sideMask);
		
		return true;
	}

	@Override
	public void renderInvBlock(RenderBlocks render, Block block, int meta, int model) {
		if(meta < 0 || meta >= EnumWires.VALUES.length)
			return;
		EnumWires type = EnumWires.VALUES[meta];
		
		Minecraft.getMinecraft().renderEngine.bindTexture("/terrain.png");
		
		rt.base = Tessellator.instance;
		rt.flipped = false;
		rt.x = -0.5;
		rt.y = 0;
		rt.z = -0.5;
		rt.front = 2; // anything not parallel to side
		rt.side = Dir.NY;
		rt.base.startDrawingQuads();
		rt.base.setBrightness(0x00F000F0);
		rt.base.setColorOpaque_I(type.itemColour);
		renderWireSide(type, true, true, true, true, false, false, false, false, true);
		rt.base.draw();
	}
	
	private void renderWireSide(EnumWires type, boolean nz, boolean pz, boolean nx, boolean px, boolean nzCorner, boolean pzCorner, boolean nxCorner, boolean pxCorner, boolean forceEndCaps) {
		
		double thick = type.thickness;
		double w = type.width / 2;
		double W = type.width * 16 / 2;
		
		boolean unconnected = !nz && !pz && !nx && !px;
		
		final int NZ = 8;
		final int PZ = 4;
		final int NX = 2;
		final int PX = 1;
		
		Icon tex = type.texture_cross;
		
		switch((nz ? NZ : 0) | (pz ? PZ : 0) | (nx ? NX : 0) | (px ? PX : 0)) {
		case 0: tex = type.texture_none; break;
		case PX: tex = type.texture_end_nx; break;
		case NX: tex = type.texture_end_px; break;
		case PZ: tex = type.texture_end_nz; break;
		case NZ: tex = type.texture_end_pz; break;
		case PX | NX: tex = type.texture_straight_x; break;
		case PZ | NZ: tex = type.texture_straight_z; break;
		case NX | NZ: tex = type.texture_corner_nn; break;
		case PX | NZ: tex = type.texture_corner_pn; break;
		case NX | PZ: tex = type.texture_corner_np; break;
		case PX | PZ: tex = type.texture_corner_pp; break;
		case NX | PX | NZ: tex = type.texture_tee_nz; break;
		case NX | PX | PZ: tex = type.texture_tee_pz; break;
		case NZ | PZ | NX: tex = type.texture_tee_nx; break;
		case NZ | PZ | PX: tex = type.texture_tee_px; break;
		case PX | NX | PZ | NZ: tex = type.texture_cross; break;
		}
		
		
		double minX = nx ? 0 : px && !nz && !pz ? 0.25 : 0.5-w;
		double maxX = px ? 1 : nx && !nz && !pz ? 0.75 : 0.5+w;
		double minZ = nz ? 0 : unconnected || (pz && !nx && !px) ? 0.25 : 0.5-w;
		double maxZ = pz ? 1 : unconnected || (nz && !nx && !px) ? 0.75 : 0.5+w;
		
		//if(nxCorner) minX -= thick;
		//if(pxCorner) maxX += thick;
		//if(nzCorner) minZ -= thick;
		//if(pzCorner) maxZ += thick;
		
		// +/- Z
		if(nz || pz || unconnected) {
			Icon sideTex = type.texture_straight_z;
			Icon endTex = type.texture_straight_x;
			
			rt.base.setNormal(0, 1, 0);
			rt.addVertexWithUV(0.5-w, thick, minZ, tex.getInterpolatedU(8-W), tex.getInterpolatedV(minZ*16));
			rt.addVertexWithUV(0.5-w, thick, maxZ, tex.getInterpolatedU(8-W), tex.getInterpolatedV(maxZ*16));
			rt.addVertexWithUV(0.5+w, thick, maxZ, tex.getInterpolatedU(8+W), tex.getInterpolatedV(maxZ*16));
			rt.addVertexWithUV(0.5+w, thick, minZ, tex.getInterpolatedU(8+W), tex.getInterpolatedV(minZ*16));
			
			rt.base.setNormal(-1, 0, 0);
			rt.addVertexWithUV(0.5-w,     0, minZ, sideTex.getInterpolatedU(8-W+thick*16), sideTex.getInterpolatedV(minZ*16));
			rt.addVertexWithUV(0.5-w,     0, maxZ, sideTex.getInterpolatedU(8-W+thick*16), sideTex.getInterpolatedV(maxZ*16));
			rt.addVertexWithUV(0.5-w, thick, maxZ, sideTex.getInterpolatedU(8-W), sideTex.getInterpolatedV(maxZ*16));
			rt.addVertexWithUV(0.5-w, thick, minZ, sideTex.getInterpolatedU(8-W), sideTex.getInterpolatedV(minZ*16));
			
			rt.base.setNormal(1, 0, 0);
			rt.addVertexWithUV(0.5+w,     0, maxZ, sideTex.getInterpolatedU(8-W+thick*16), sideTex.getInterpolatedV(maxZ*16));
			rt.addVertexWithUV(0.5+w,     0, minZ, sideTex.getInterpolatedU(8-W+thick*16), sideTex.getInterpolatedV(minZ*16));
			rt.addVertexWithUV(0.5+w, thick, minZ, sideTex.getInterpolatedU(8-W), sideTex.getInterpolatedV(minZ*16));
			rt.addVertexWithUV(0.5+w, thick, maxZ, sideTex.getInterpolatedU(8-W), sideTex.getInterpolatedV(maxZ*16));
			
			if(nzCorner) {
				double cornerMaxZ = minZ;
				minZ -= thick;
				
				Icon cornerSideTex = type.texture_corner_nn;
				
				rt.base.setNormal(0, 1, 0);
				rt.addVertexWithUV(0.5-w, thick, minZ, tex.getInterpolatedU(8-W), tex.getInterpolatedV((1-thick)*16));
				rt.addVertexWithUV(0.5-w, thick, cornerMaxZ, tex.getInterpolatedU(8-W), tex.getInterpolatedV(16));
				rt.addVertexWithUV(0.5+w, thick, cornerMaxZ, tex.getInterpolatedU(8+W), tex.getInterpolatedV(16));
				rt.addVertexWithUV(0.5+w, thick, minZ, tex.getInterpolatedU(8+W), tex.getInterpolatedV((1-thick)*16));
				
				rt.base.setNormal(-1, 0, 0);
				rt.addVertexWithUV(0.5-w,     0, minZ, cornerSideTex.getInterpolatedU(8+W-thick*16), cornerSideTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(0.5-w,     0, cornerMaxZ, cornerSideTex.getInterpolatedU(8+W-thick*16), cornerSideTex.getInterpolatedV(8+W-thick*16));
				rt.addVertexWithUV(0.5-w, thick, cornerMaxZ, cornerSideTex.getInterpolatedU(8+W), cornerSideTex.getInterpolatedV(8+W-thick*16));
				rt.addVertexWithUV(0.5-w, thick, minZ, cornerSideTex.getInterpolatedU(8+W), cornerSideTex.getInterpolatedV(8+W));
				
				rt.base.setNormal(1, 0, 0);
				rt.addVertexWithUV(0.5+w,     0, cornerMaxZ, cornerSideTex.getInterpolatedU(8+W-thick*16), cornerSideTex.getInterpolatedV(8+W-thick*16));
				rt.addVertexWithUV(0.5+w,     0, minZ, cornerSideTex.getInterpolatedU(8+W-thick*16), cornerSideTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(0.5+w, thick, minZ, cornerSideTex.getInterpolatedU(8+W), cornerSideTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(0.5+w, thick, cornerMaxZ, cornerSideTex.getInterpolatedU(8+W), cornerSideTex.getInterpolatedV(8+W-thick*16));
			}
			
			if(pzCorner) {
				double cornerMinZ = maxZ;
				maxZ += thick;
				
				Icon cornerSideTex = type.texture_corner_np;
				
				rt.base.setNormal(0, 1, 0);
				rt.addVertexWithUV(0.5-w, thick, cornerMinZ, tex.getInterpolatedU(8-W), tex.getInterpolatedV((1-thick)*16));
				rt.addVertexWithUV(0.5-w, thick, maxZ, tex.getInterpolatedU(8-W), tex.getInterpolatedV(16));
				rt.addVertexWithUV(0.5+w, thick, maxZ, tex.getInterpolatedU(8+W), tex.getInterpolatedV(16));
				rt.addVertexWithUV(0.5+w, thick, cornerMinZ, tex.getInterpolatedU(8+W), tex.getInterpolatedV((1-thick)*16));
				
				rt.base.setNormal(-1, 0, 0);
				rt.addVertexWithUV(0.5-w,     0, cornerMinZ, cornerSideTex.getInterpolatedU(8+W-thick*16), cornerSideTex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(0.5-w,     0, maxZ, cornerSideTex.getInterpolatedU(8+W-thick*16), cornerSideTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(0.5-w, thick, maxZ, cornerSideTex.getInterpolatedU(8+W), cornerSideTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(0.5-w, thick, cornerMinZ, cornerSideTex.getInterpolatedU(8+W), cornerSideTex.getInterpolatedV(8-W+thick*16));
				
				rt.base.setNormal(1, 0, 0);
				rt.addVertexWithUV(0.5+w,     0, maxZ, cornerSideTex.getInterpolatedU(8+W-thick*16), cornerSideTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(0.5+w,     0, cornerMinZ, cornerSideTex.getInterpolatedU(8+W-thick*16), cornerSideTex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(0.5+w, thick, cornerMinZ, cornerSideTex.getInterpolatedU(8+W), cornerSideTex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(0.5+w, thick, maxZ, cornerSideTex.getInterpolatedU(8+W), cornerSideTex.getInterpolatedV(8-W));
			}
			
			if((!nz || forceEndCaps) && !nzCorner) {
				rt.base.setNormal(0, 0, -1);
				rt.addVertexWithUV(0.5-w, thick, minZ, endTex.getInterpolatedU(8-W), endTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(0.5+w, thick, minZ, endTex.getInterpolatedU(8+W), endTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(0.5+w,     0, minZ, endTex.getInterpolatedU(8+W), endTex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(0.5-w,     0, minZ, endTex.getInterpolatedU(8-W), endTex.getInterpolatedV(8-W+thick*16));
			}
			
			if((!pz || forceEndCaps) && !pzCorner) {
				rt.base.setNormal(0, 0, 1);
				rt.addVertexWithUV(0.5-w,     0, maxZ, endTex.getInterpolatedU(8-W), endTex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(0.5+w,     0, maxZ, endTex.getInterpolatedU(8+W), endTex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(0.5+w, thick, maxZ, endTex.getInterpolatedU(8+W), endTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(0.5-w, thick, maxZ, endTex.getInterpolatedU(8-W), endTex.getInterpolatedV(8-W));
			}
		}
		
		
		// +/- X
		if(nx || px) {
			Icon sideTex = type.texture_straight_x;
			Icon endTex = type.texture_straight_z;
			
			rt.base.setNormal(0, 1, 0);
			rt.addVertexWithUV(minX, thick, 0.5-w, tex.getInterpolatedU(minX*16), tex.getInterpolatedV(8-W));
			rt.addVertexWithUV(minX, thick, 0.5+w, tex.getInterpolatedU(minX*16), tex.getInterpolatedV(8+W));
			rt.addVertexWithUV(maxX, thick, 0.5+w, tex.getInterpolatedU(maxX*16), tex.getInterpolatedV(8+W));
			rt.addVertexWithUV(maxX, thick, 0.5-w, tex.getInterpolatedU(maxX*16), tex.getInterpolatedV(8-W));
			
			rt.base.setNormal(0, 0, -1);
			rt.addVertexWithUV(maxX,     0, 0.5-w, sideTex.getInterpolatedU(maxX*16), sideTex.getInterpolatedV(8-W+thick*16));
			rt.addVertexWithUV(minX,     0, 0.5-w, sideTex.getInterpolatedU(minX*16), sideTex.getInterpolatedV(8-W+thick*16));
			rt.addVertexWithUV(minX, thick, 0.5-w, sideTex.getInterpolatedU(minX*16), sideTex.getInterpolatedV(8-W));
			rt.addVertexWithUV(maxX, thick, 0.5-w, sideTex.getInterpolatedU(maxX*16), sideTex.getInterpolatedV(8-W));
			
			rt.base.setNormal(0, 0, 1);
			rt.addVertexWithUV(minX,     0, 0.5+w, sideTex.getInterpolatedU(minX*16), sideTex.getInterpolatedV(8-W+thick*16));
			rt.addVertexWithUV(maxX,     0, 0.5+w, sideTex.getInterpolatedU(maxX*16), sideTex.getInterpolatedV(8-W+thick*16));
			rt.addVertexWithUV(maxX, thick, 0.5+w, sideTex.getInterpolatedU(maxX*16), sideTex.getInterpolatedV(8-W));
			rt.addVertexWithUV(minX, thick, 0.5+w, sideTex.getInterpolatedU(minX*16), sideTex.getInterpolatedV(8-W));
			
			if(nxCorner) {
				double cornerMaxX = minX;
				minX -= thick;
				
				Icon cornerSideTex = type.texture_corner_pn;
				
				rt.base.setNormal(0, 1, 0);
				rt.addVertexWithUV(minX, thick, 0.5+w, tex.getInterpolatedU((1-thick)*16), tex.getInterpolatedV(8+W));
				rt.addVertexWithUV(cornerMaxX, thick, 0.5+w, tex.getInterpolatedU(16), tex.getInterpolatedV(8+W));
				rt.addVertexWithUV(cornerMaxX, thick, 0.5-w, tex.getInterpolatedU(16), tex.getInterpolatedV(8-W));
				rt.addVertexWithUV(minX, thick, 0.5-w, tex.getInterpolatedU((1-thick)*16), tex.getInterpolatedV(8-W));
				
				rt.base.setNormal(0, 0, -1);
				rt.addVertexWithUV(minX, thick, 0.5-w, cornerSideTex.getInterpolatedU(8-W), cornerSideTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(cornerMaxX, thick, 0.5-w, cornerSideTex.getInterpolatedU(8-W+thick*16), cornerSideTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(cornerMaxX, 0, 0.5-w, cornerSideTex.getInterpolatedU(8-W+thick*16), cornerSideTex.getInterpolatedV(8+W-thick*16));
				rt.addVertexWithUV(minX, 0, 0.5-w, cornerSideTex.getInterpolatedU(8-W), cornerSideTex.getInterpolatedV(8+W-thick*16));
				
				rt.base.setNormal(0, 0, 1);
				rt.addVertexWithUV(cornerMaxX, thick, 0.5+w, cornerSideTex.getInterpolatedU(8-W+thick*16), cornerSideTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(minX, thick, 0.5+w, cornerSideTex.getInterpolatedU(8-W), cornerSideTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(minX, 0, 0.5+w, cornerSideTex.getInterpolatedU(8-W), cornerSideTex.getInterpolatedV(8+W-thick*16));
				rt.addVertexWithUV(cornerMaxX, 0, 0.5+w, cornerSideTex.getInterpolatedU(8-W+thick*16), cornerSideTex.getInterpolatedV(8+W-thick*16));
			}
			
			if(pxCorner) {
				double cornerMinX = maxX;
				maxX += thick;
				
				Icon cornerSideTex = type.texture_corner_pp;
				
				rt.base.setNormal(0, 1, 0);
				rt.addVertexWithUV(cornerMinX, thick, 0.5+w, tex.getInterpolatedU((1-thick)*16), tex.getInterpolatedV(8+W));
				rt.addVertexWithUV(maxX, thick, 0.5+w, tex.getInterpolatedU(16), tex.getInterpolatedV(8+W));
				rt.addVertexWithUV(maxX, thick, 0.5-w, tex.getInterpolatedU(16), tex.getInterpolatedV(8-W));
				rt.addVertexWithUV(cornerMinX, thick, 0.5-w, tex.getInterpolatedU((1-thick)*16), tex.getInterpolatedV(8-W));
				
				rt.base.setNormal(0, 0, -1);
				rt.addVertexWithUV(cornerMinX, thick, 0.5-w, cornerSideTex.getInterpolatedU(8-W+thick*16), cornerSideTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(maxX, thick, 0.5-w, cornerSideTex.getInterpolatedU(8-W), cornerSideTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(maxX, 0, 0.5-w, cornerSideTex.getInterpolatedU(8-W), cornerSideTex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(cornerMinX, 0, 0.5-w, cornerSideTex.getInterpolatedU(8-W+thick*16), cornerSideTex.getInterpolatedV(8-W+thick*16));
				
				rt.base.setNormal(0, 0, 1);
				rt.addVertexWithUV(maxX, thick, 0.5+w, cornerSideTex.getInterpolatedU(8-W), cornerSideTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(cornerMinX, thick, 0.5+w, cornerSideTex.getInterpolatedU(8-W+thick*16), cornerSideTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(cornerMinX, 0, 0.5+w, cornerSideTex.getInterpolatedU(8-W+thick*16), cornerSideTex.getInterpolatedV(8-W+thick*16));
				rt.addVertexWithUV(maxX, 0, 0.5+w, cornerSideTex.getInterpolatedU(8-W), cornerSideTex.getInterpolatedV(8-W+thick*16));
			}
			
			if((forceEndCaps || !nx) && !nxCorner) {
				rt.base.setNormal(0, 0, -1);
				rt.addVertexWithUV(minX, thick, 0.5+w, endTex.getInterpolatedU(8-W), endTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(minX, thick, 0.5-w, endTex.getInterpolatedU(8-W), endTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(minX,     0, 0.5-w, endTex.getInterpolatedU(8-W+thick*16), endTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(minX,     0, 0.5+w, endTex.getInterpolatedU(8-W+thick*16), endTex.getInterpolatedV(8-W));
			}
			
			if((forceEndCaps || !px) && !pxCorner) {
				rt.base.setNormal(0, 0, 1);
				rt.addVertexWithUV(maxX,     0, 0.5+w, endTex.getInterpolatedU(8-W+thick*16), endTex.getInterpolatedV(8-W));
				rt.addVertexWithUV(maxX,     0, 0.5-w, endTex.getInterpolatedU(8-W+thick*16), endTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(maxX, thick, 0.5-w, endTex.getInterpolatedU(8-W), endTex.getInterpolatedV(8+W));
				rt.addVertexWithUV(maxX, thick, 0.5+w, endTex.getInterpolatedU(8-W), endTex.getInterpolatedV(8-W));
			}
		}
		
	}

}
