package mffs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.Block;
import net.minecraft.server.EntityItem;
import net.minecraft.server.ItemStack;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class FFBlock
{
    public FFBlock.Entry activeEntry;
    public List entries = new ArrayList(2);
    public final int x;
    public final int y;
    public final int z;
    public final World w;

    public FFBlock(int var1, int var2, int var3, World var4)
    {
        this.x = var1;
        this.y = var2;
        this.z = var3;
        this.w = var4;
    }

    public int getFieldType()
    {
        return this.activeEntry == null ? 0 : this.activeEntry.ffmeta;
    }

    public boolean shouldBeActive()
    {
        return this.activeEntry != null && this.activeEntry.mode == 1;
    }

    public void usePower(int var1)
    {
        if (this.activeEntry != null)
        {
            TileEntity var2 = (TileEntity)Linkgrid.getWorldMap(this.w).getGenerator().get(Integer.valueOf(this.activeEntry.genID));

            if (var2 instanceof TileEntityGeneratorCore)
            {
                TileEntityGeneratorCore var3 = (TileEntityGeneratorCore)var2;
                int var4 = mod_ModularForceFieldSystem.forcefieldblockcost * var1;

                if (BlockForceField.isZapper(this.getFieldType()))
                {
                    var4 *= mod_ModularForceFieldSystem.forcefieldblockzappermodifier;
                }

                var3.Energylost(var4);
            }
        }
    }

    public boolean refresh()
    {
        boolean var1 = false;

        if (!this.shouldBeActive())
        {
            if (this.w.getTypeId(this.x, this.y, this.z) == mod_ModularForceFieldSystem.MFFSFieldblock.id)
            {
                this.w.setTypeId(this.x, this.y, this.z, 0);
                var1 = true;
            }
        }
        else
        {
            int var2 = this.w.getTypeId(this.x, this.y, this.z);

            if (var2 != 7 && (var2 != mod_ModularForceFieldSystem.MFFSFieldblock.id || this.w.getData(this.x, this.y, this.z) != this.getFieldType()) && (var2 == 0 || var2 == mod_ModularForceFieldSystem.MFFSFieldblock.id || this.activeEntry.blockBreaker || !Block.byId[var2].material.isBuildable()))
            {
                int var3 = this.w.getData(this.x, this.y, this.z);

                if (var2 != 0 && var2 != mod_ModularForceFieldSystem.MFFSFieldblock.id)
                {
                    if (this.w.getTileEntity(this.x, this.y, this.z) != null)
                    {
                        return false;
                    }

                    Block var4 = Block.byId[var2];
                    this.w.setTypeId(this.x, this.y, this.z, 0);
                    Iterator var5 = var4.getBlockDropped(this.w, this.x, this.y, this.z, var3, 0).iterator();

                    while (var5.hasNext())
                    {
                        ItemStack var6 = (ItemStack)var5.next();
                        this.w.addEntity(new EntityItem(this.w, (double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D, var6));
                    }
                }

                if (var2 != mod_ModularForceFieldSystem.MFFSFieldblock.id || var3 != this.getFieldType())
                {
                    this.w.setTypeId(this.x, this.y, this.z, 0);
                    this.w.setTypeIdAndData(this.x, this.y, this.z, mod_ModularForceFieldSystem.MFFSFieldblock.id, this.getFieldType());
                }

                this.refreshCamo();
                this.usePower(mod_ModularForceFieldSystem.forcefieldblockcreatemodifier);
                var1 = true;
            }
        }

        if (this.activeEntry == null)
        {
            this.refreshActiveEntry();

            if (this.activeEntry == null)
            {
                FFWorld.get(this.w).remove(this.x, this.y, this.z);
            }

            var1 = true;
        }

        return var1;
    }

    public void removeEntry(int var1)
    {
        Iterator var2 = this.entries.iterator();

        do
        {
            if (!var2.hasNext())
            {
                return;
            }
        }
        while (((FFBlock.Entry)var2.next()).projID != var1);

        var2.remove();
        this.refreshActiveEntry();
    }

    public void addEntry(FFBlock.Entry var1)
    {
        Iterator var2 = this.entries.iterator();

        while (var2.hasNext())
        {
            if (((FFBlock.Entry)var2.next()).projID == var1.projID)
            {
                var2.remove();
                break;
            }
        }

        for (int var3 = 0; var3 < this.entries.size(); ++var3)
        {
            if (((FFBlock.Entry)this.entries.get(var3)).time > var1.time)
            {
                this.entries.add(var3, var1);
                this.refreshActiveEntry();
                return;
            }
        }

        this.entries.add(var1);
        this.refreshActiveEntry();
    }

    private void refreshActiveEntry()
    {
        if (this.entries.size() < 2)
        {
            FFBlock.Entry var5 = this.entries.size() == 0 ? null : (FFBlock.Entry)this.entries.get(0);

            if (this.activeEntry != var5)
            {
                this.activeEntry = var5;
                this.refresh();
                this.refreshCamo();
            }
        }
        else
        {
            HashMap var1 = new HashMap();
            Iterator var2 = this.entries.iterator();
            FFBlock.Entry var4;

            while (var2.hasNext())
            {
                FFBlock.Entry var3 = (FFBlock.Entry)var2.next();
                var4 = (FFBlock.Entry)var1.get(Integer.valueOf(var3.genID));

                if (var4 == null)
                {
                    var1.put(Integer.valueOf(var3.genID), var3);
                }
                else if (var4.mode == 1 && var3.mode == 2)
                {
                    var1.put(Integer.valueOf(var3.genID), var3);
                }
            }

            FFBlock.Entry var6 = this.activeEntry;
            this.activeEntry = null;
            Iterator var7 = var1.values().iterator();

            while (var7.hasNext())
            {
                var4 = (FFBlock.Entry)var7.next();

                if (this.activeEntry == null)
                {
                    this.activeEntry = var4;
                }
                else
                {
                    if (var4.mode == 2)
                    {
                        this.activeEntry = var4;
                    }

                    if (var4.mode == 1 && this.activeEntry.mode == 2)
                    {
                        this.activeEntry = var4;
                    }
                }
            }

            if (var6 != this.activeEntry)
            {
                this.refresh();
                this.refreshCamo();
            }
        }
    }

    public void useEnergyFor(int var1)
    {
        if (this.shouldBeActive() && this.activeEntry.projID == var1)
        {
            this.usePower(1);
        }
    }

    public void refreshCamo()
    {
        if (this.shouldBeActive() && BlockForceField.isCamo(this.getFieldType()) && this.w.getTypeId(this.x, this.y, this.z) == mod_ModularForceFieldSystem.MFFSFieldblock.id)
        {
            TileCamouflagedField var1 = (TileCamouflagedField)this.w.getTileEntity(this.x, this.y, this.z);

            if (var1 == null)
            {
                return;
            }

            if (var1.camoBlockId == this.activeEntry.camoBlock)
            {
                return;
            }

            var1.camoBlockId = this.activeEntry.camoBlock;
            this.w.notify(this.x, this.y, this.z);
        }
    }

    public String getDebugInfo()
    {
        String var1 = "";
        var1 = var1 + "entries.size: " + this.entries.size();
        return var1;
    }

    public static class Entry
    {
        public int genID;
        public int projID;
        public byte mode;
        public byte ffmeta;
        public boolean blockBreaker;
        public int camoBlock;
        public long time;

        public Entry(int var1, int var2, int var3, int var4, boolean var5, int var6, long var7)
        {
            this.ffmeta = (byte)var1;
            this.genID = var2;
            this.projID = var3;
            this.mode = (byte)var4;
            this.blockBreaker = var5;
            this.camoBlock = var6;
            this.time = var7;
        }
    }
}
