package net.minecraft.server;

import forge.Configuration;
import forge.IGuiHandler;
import forge.MinecraftForge;
import forge.NetworkMod;
import forge.Property;
import ic2.api.ExplosionWhitelist;
import ic2.api.Items;
import immibis.core.ModInfoReader;
import immibis.core.NonSharedProxy;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import mffs.BlockForceField;
import mffs.BlockMachine;
import mffs.BlockUpgrades;
import mffs.ContainerCamoflage;
import mffs.ContainerGenerator;
import mffs.ContainerProjektor;
import mffs.ContainerReactorCooler;
import mffs.ContainerReaktorMonitor;
import mffs.ContainerReaktorMonitorClient;
import mffs.Functions;
import mffs.ItemCardempty;
import mffs.ItemFrequenzCard;
import mffs.ItemIDCard;
import mffs.ItemMFD_IDwriter;
import mffs.ItemMFD_Reaktorlink;
import mffs.ItemMFD_debuger;
import mffs.ItemMFD_wrench;
import mffs.ItemMachines;
import mffs.ItemSecLinkCard;
import mffs.ItemUpgrades;
import mffs.TileEntityAreaProjektor;
import mffs.TileEntityCamoflageUpgrade;
import mffs.TileEntityDeflectorProjektor;
import mffs.TileEntityDirectionalExtender;
import mffs.TileEntityDirectionalProjektor;
import mffs.TileEntityGeneratorCore;
import mffs.TileEntityGeneratorEUInjector;
import mffs.TileEntityMaschines;
import mffs.TileEntityPassivUpgrade;
import mffs.TileEntityReaktorConnector;
import mffs.TileEntityReaktorCooler;
import mffs.TileEntityReaktorField;
import mffs.TileEntityReaktorMonitor;
import mffs.TileEntityReaktorMonitorClient;
import mffs.TileEntityTubeProjektor;
import mffs.packet.PacketGenericUpdate;

public class mod_ModularForceFieldSystem extends NetworkMod implements IGuiHandler, IPacketMap
{
    public static Configuration config;
    public static Block MFFSMaschines;
    public static Block MFFSUpgrades;
    public static Block MFFSFieldblock;
    public static Item MFFSitemMFDReaktorlink;
    public static Item MFFSitemMFDwrench;
    public static Item MFFSitemMFDidtool;
    public static Item MFFSitemMFDdebugger;
    public static Item MFFSitemcardempty;
    public static Item MFFSitemfc;
    public static Item MFFSitemidc;
    public static Item MFFSitemsclc;
    public static final int GUI_ID_GENERATOR = 1;
    public static final int GUI_AREA_PROJECTOR = 2;
    public static final int GUI_DIRECTIONAL_PROJECTOR = 3;
    public static final int GUI_DEFLECTOR_PROJECTOR = 4;
    public static final int GUI_DIRECTIONAL_UPGRADE = 5;
    public static final int GUI_TUBE_PROJECTOR = 6;
    public static final int GUI_CAMOFLAGE_UPGRADE = 7;
    public static final int GUI_REACTOR_FIELD = 8;
    public static final int GUI_REACTOR_COOLER = 9;
    public static final int GUI_REACTOR_MONITOR = 10;
    public static final int GUI_REACTOR_MONITOR_CLIENT = 11;
    public static final int GUI_REACTOR_MONITOR_REMOTE = 12;
    public static final String CHANNEL = "MFFS-immiSMP";
    public static final byte PKT_GENERIC_UPDATE = 0;
    public static final byte PKT_PROJECTOR_DESCRIPTION = 1;
    public static int forcefieldblockcost;
    public static int forcefieldblockcreatemodifier;
    public static int forcefieldblockzappermodifier;
    public static int reaktorheatcontrolice;
    public static int reaktorheatcontrolwater;
    public static int reaktorheatcontrollava;
    public static StringBuffer hasher = new StringBuffer();
    public static Map idtotextur = new Hashtable();
    public static mod_ModularForceFieldSystem instance;
    public static boolean slowGenerate;

    public mod_ModularForceFieldSystem()
    {
        instance = this;
    }

    public void load()
    {
        try
        {
            config = new Configuration(new File(Functions.getMinecraftDir(), "/config/ModularForceFieldSystem.cfg"));
            config.load();
        }
        catch (Exception var4)
        {
            config = null;
            System.err.print(var4.toString());
        }

        Property var1 = config.getOrCreateBooleanProperty("useOldNames", "general", false);
        var1.comment = "If true, this will use the old names from Thunderdark\'s version.";
        boolean var2 = Boolean.valueOf(var1.value).booleanValue();
        Property var3 = config.getOrCreateBooleanProperty("slowGenerate", "general", NonSharedProxy.SERVER);
        var3.comment = "If true, forcefields will generate at 400 blocks/second, otherwise 400 blocks/tick (8000/second).";
        slowGenerate = Boolean.valueOf(var3.value).booleanValue();
        reaktorheatcontrolice = Functions.getBlockIdFor("reaktorheatcontrolice", 100);
        reaktorheatcontrolwater = Functions.getBlockIdFor("reaktorheatcontrolwater", 50);
        reaktorheatcontrollava = Functions.getBlockIdFor("reaktorheatcontrollava", 100);
        forcefieldblockcost = Functions.getBlockIdFor("forcefieldblockcost", 1);
        forcefieldblockcreatemodifier = Functions.getBlockIdFor("forcefieldblockcreatemodifier", 10);
        forcefieldblockzappermodifier = Functions.getBlockIdFor("forcefieldblockzappermodifier", 2);
        MFFSFieldblock = new BlockForceField(Functions.getBlockIdFor("HFFPFieldblock", 255));
        MFFSMaschines = new BlockMachine(Functions.getBlockIdFor("HFFPMaschines", 253));
        MFFSUpgrades = new BlockUpgrades(Functions.getBlockIdFor("HFFSUpgrades", 254));
        MFFSitemMFDReaktorlink = (new ItemMFD_Reaktorlink(Functions.getItemIdFor("itemMFDReaktorlink", 11110))).a("itemMFDReaktorlink");
        MFFSitemMFDdebugger = (new ItemMFD_debuger(Functions.getItemIdFor("itemMFDdebugger", 11111))).a("itemMFDdebugger");
        MFFSitemMFDidtool = (new ItemMFD_IDwriter(Functions.getItemIdFor("itemMFDidtool", 11112))).a("itemMFDidtool");
        MFFSitemMFDwrench = (new ItemMFD_wrench(Functions.getItemIdFor("itemMFDwrench", 11114))).a("itemMFDwrench");
        MFFSitemcardempty = (new ItemCardempty(Functions.getItemIdFor("itemcardempty", 11115))).a("itemcardempty");
        MFFSitemfc = (new ItemFrequenzCard(Functions.getItemIdFor("itemfc", 11116))).a("itemfc");
        MFFSitemidc = (new ItemIDCard(Functions.getItemIdFor("itemidc", 11117))).a("itemidc");
        MFFSitemsclc = (new ItemSecLinkCard(Functions.getItemIdFor("itemsclc", 11118))).a("itemsclc");

        if (config != null)
        {
            config.save();
        }

        ModLoader.registerBlock(MFFSMaschines, ItemMachines.class);
        ModLoader.registerBlock(MFFSUpgrades, ItemUpgrades.class);
        ModLoader.registerTileEntity(TileEntityMaschines.class, "Maschines_Multi");
        ModLoader.registerTileEntity(TileEntityGeneratorCore.class, "Generator_Core");
        ModLoader.registerTileEntity(TileEntityAreaProjektor.class, "Area_Projektor");
        ModLoader.registerTileEntity(TileEntityPassivUpgrade.class, "Generator_Upgrade");
        ModLoader.registerTileEntity(TileEntityGeneratorEUInjector.class, "Generator_EU_Injektor");
        ModLoader.registerTileEntity(TileEntityDirectionalProjektor.class, "Directional_Projektor");
        ModLoader.registerTileEntity(TileEntityDeflectorProjektor.class, "Deflector_Projektor");
        ModLoader.registerTileEntity(TileEntityDirectionalExtender.class, "Directional_Extender");
        ModLoader.registerTileEntity(TileEntityTubeProjektor.class, "Tube_Projektor");
        ModLoader.registerTileEntity(TileEntityCamoflageUpgrade.class, "Projektor_camouflage");
        ModLoader.registerTileEntity(TileEntityReaktorField.class, "Reaktor_Field");
        ModLoader.registerTileEntity(TileEntityReaktorConnector.class, "Reactor_Connector");
        ModLoader.registerTileEntity(TileEntityReaktorCooler.class, "Reaktor_Cooler");
        ModLoader.registerTileEntity(TileEntityReaktorMonitor.class, "Reaktor_Monitor");
        ModLoader.registerTileEntity(TileEntityReaktorMonitorClient.class, "Reaktor_Monitor_Client");
        ModLoader.addName(MFFSitemMFDidtool, "MFDevice <ID-Tool>");
        ModLoader.addName(MFFSitemMFDwrench, "MFDevice <Wrench>");
        ModLoader.addName(MFFSitemcardempty, var2 ? "MFFS Card blank " : "Blank MFFS card");
        ModLoader.addName(MFFSitemfc, var2 ? "MFFS Frequency Card" : "MFFS frequency card");
        ModLoader.addName(MFFSitemidc, var2 ? "MFFS ID Card" : "MFFS ID card");
        ModLoader.addName(MFFSitemMFDdebugger, "MFDevice <Debugger>");
        ModLoader.addName(MFFSitemsclc, var2 ? "MFFS  Link Card" : "MFFS link card");
        ModLoader.addName(MFFSitemMFDReaktorlink, var2 ? "MFFS Remote Reaktor Link" : "MFFS remote reactor link");
        ModLoader.addLocalization("Tube_Projektor.name", var2 ? "MFFS Tube Projector" : "Tube forcefield projector");
        ModLoader.addLocalization("Directional_Extender.name", "MFFS directional extender");
        ModLoader.addLocalization("Deflector_Projektor.name", "MFFS deflector");
        ModLoader.addLocalization("Generator_Core.name", var2 ? "MFFS generator core" : "Forcefield core");
        ModLoader.addLocalization("Area_Projektor.name", var2 ? "MFFS Area Projector" : "MFFS area projector");
        ModLoader.addLocalization("Generator_Storage.name", var2 ? "MFFS generator storage upgrade" : "Forcefield core storage upgrade");
        ModLoader.addLocalization("Generator_Linkex.name", var2 ? "MFFS generator range upgrade" : "Forcefield core range upgrade");
        ModLoader.addLocalization("Generator_EU_Injektor.name", var2 ? "MFFS generator EU-injector" : "Forcefield EU injector");
        ModLoader.addLocalization("Directional_Projektor.name", var2 ? "MFFS directional projektor" : "Directional forcefield projector");
        ModLoader.addLocalization("Projektor_Subwater.name", var2 ? "MFFS Projector underwater upgrade" : "Forcefield underwater upgrade");
        ModLoader.addLocalization("Projektor_Dome.name", var2 ? "MFFS Projector dome upgrade" : "Forcefield dome upgrade");
        ModLoader.addLocalization("Projektor_Hardner.name", var2 ? "MFFS Projector block cutter upgrade" : "Forcefield block cutter upgrade");
        ModLoader.addLocalization("Projektor_Zapper.name", var2 ? "MFFS Projector ZAPPER upgrade" : "Forcefield zapper upgrade");
        ModLoader.addLocalization("Projektor_camouflage.name", var2 ? "MFFS Projector camouflage upgrade" : "Forcefield camouflage upgrade");
        ModLoader.addLocalization("Reaktor_Field.name", var2 ? "MFFS nuclear reactor containment " : "Reactor containment field projector");
        ModLoader.addLocalization("Reactor_Connector.name", "MFFS reactor connector");
        ModLoader.addLocalization("Reaktor_Cooler.name", "MFFS reactor heat control");
        ModLoader.addLocalization("Reaktor_Monitor.name", "MFFS reactor heat monitor server");
        ModLoader.addLocalization("Reaktor_Monitor_Client.name", "MFFS reactor heat monitor client");
        idtotextur.put(new Integer(1), new Integer[] {Integer.valueOf(17), Integer.valueOf(17), Integer.valueOf(17), Integer.valueOf(17), Integer.valueOf(17), Integer.valueOf(17)});
        idtotextur.put(new Integer(3), new Integer[] {Integer.valueOf(18), Integer.valueOf(18), Integer.valueOf(18), Integer.valueOf(18), Integer.valueOf(18), Integer.valueOf(18)});
        idtotextur.put(new Integer(5), new Integer[] {Integer.valueOf(20), Integer.valueOf(20), Integer.valueOf(20), Integer.valueOf(20), Integer.valueOf(20), Integer.valueOf(20)});
        idtotextur.put(new Integer(45), new Integer[] {Integer.valueOf(23), Integer.valueOf(23), Integer.valueOf(23), Integer.valueOf(23), Integer.valueOf(23), Integer.valueOf(23)});
        idtotextur.put(new Integer(4), new Integer[] {Integer.valueOf(32), Integer.valueOf(32), Integer.valueOf(32), Integer.valueOf(32), Integer.valueOf(32), Integer.valueOf(32)});
        idtotextur.put(new Integer(7), new Integer[] {Integer.valueOf(33), Integer.valueOf(33), Integer.valueOf(33), Integer.valueOf(33), Integer.valueOf(33), Integer.valueOf(33)});
        idtotextur.put(new Integer(12), new Integer[] {Integer.valueOf(34), Integer.valueOf(34), Integer.valueOf(34), Integer.valueOf(34), Integer.valueOf(34), Integer.valueOf(34)});
        idtotextur.put(new Integer(13), new Integer[] {Integer.valueOf(35), Integer.valueOf(35), Integer.valueOf(35), Integer.valueOf(35), Integer.valueOf(35), Integer.valueOf(35)});
        idtotextur.put(new Integer(42), new Integer[] {Integer.valueOf(38), Integer.valueOf(38), Integer.valueOf(38), Integer.valueOf(38), Integer.valueOf(38), Integer.valueOf(38)});
        idtotextur.put(new Integer(41), new Integer[] {Integer.valueOf(39), Integer.valueOf(39), Integer.valueOf(39), Integer.valueOf(39), Integer.valueOf(39), Integer.valueOf(39)});
        idtotextur.put(new Integer(57), new Integer[] {Integer.valueOf(40), Integer.valueOf(40), Integer.valueOf(40), Integer.valueOf(40), Integer.valueOf(40), Integer.valueOf(40)});
        idtotextur.put(new Integer(14), new Integer[] {Integer.valueOf(48), Integer.valueOf(48), Integer.valueOf(48), Integer.valueOf(48), Integer.valueOf(48), Integer.valueOf(48)});
        idtotextur.put(new Integer(15), new Integer[] {Integer.valueOf(49), Integer.valueOf(49), Integer.valueOf(49), Integer.valueOf(49), Integer.valueOf(49), Integer.valueOf(49)});
        idtotextur.put(new Integer(16), new Integer[] {Integer.valueOf(50), Integer.valueOf(50), Integer.valueOf(50), Integer.valueOf(50), Integer.valueOf(50), Integer.valueOf(50)});
        idtotextur.put(new Integer(48), new Integer[] {Integer.valueOf(52), Integer.valueOf(52), Integer.valueOf(52), Integer.valueOf(52), Integer.valueOf(52), Integer.valueOf(52)});
        idtotextur.put(new Integer(49), new Integer[] {Integer.valueOf(53), Integer.valueOf(53), Integer.valueOf(53), Integer.valueOf(53), Integer.valueOf(53), Integer.valueOf(53)});
        idtotextur.put(new Integer(19), new Integer[] {Integer.valueOf(64), Integer.valueOf(64), Integer.valueOf(64), Integer.valueOf(64), Integer.valueOf(64), Integer.valueOf(64)});
        idtotextur.put(new Integer(56), new Integer[] {Integer.valueOf(66), Integer.valueOf(66), Integer.valueOf(66), Integer.valueOf(66), Integer.valueOf(66), Integer.valueOf(66)});
        idtotextur.put(new Integer(73), new Integer[] {Integer.valueOf(67), Integer.valueOf(67), Integer.valueOf(67), Integer.valueOf(67), Integer.valueOf(67), Integer.valueOf(67)});
        idtotextur.put(new Integer(79), new Integer[] {Integer.valueOf(83), Integer.valueOf(83), Integer.valueOf(83), Integer.valueOf(83), Integer.valueOf(83), Integer.valueOf(83)});
        idtotextur.put(new Integer(82), new Integer[] {Integer.valueOf(88), Integer.valueOf(88), Integer.valueOf(88), Integer.valueOf(88), Integer.valueOf(88), Integer.valueOf(88)});
        idtotextur.put(new Integer(87), new Integer[] {Integer.valueOf(30), Integer.valueOf(30), Integer.valueOf(30), Integer.valueOf(30), Integer.valueOf(30), Integer.valueOf(30)});
        idtotextur.put(new Integer(88), new Integer[] {Integer.valueOf(31), Integer.valueOf(31), Integer.valueOf(31), Integer.valueOf(31), Integer.valueOf(31), Integer.valueOf(31)});
        idtotextur.put(new Integer(89), new Integer[] {Integer.valueOf(44), Integer.valueOf(44), Integer.valueOf(44), Integer.valueOf(44), Integer.valueOf(44), Integer.valueOf(44)});
        idtotextur.put(new Integer(22), new Integer[] {Integer.valueOf(85), Integer.valueOf(85), Integer.valueOf(85), Integer.valueOf(85), Integer.valueOf(85), Integer.valueOf(85)});
        idtotextur.put(new Integer(21), new Integer[] {Integer.valueOf(71), Integer.valueOf(71), Integer.valueOf(71), Integer.valueOf(71), Integer.valueOf(71), Integer.valueOf(71)});
        idtotextur.put(new Integer(17), new Integer[] {Integer.valueOf(37), Integer.valueOf(37), Integer.valueOf(36), Integer.valueOf(36), Integer.valueOf(36), Integer.valueOf(36)});
        idtotextur.put(new Integer(1017), new Integer[] {Integer.valueOf(37), Integer.valueOf(37), Integer.valueOf(92), Integer.valueOf(92), Integer.valueOf(92), Integer.valueOf(92)});
        idtotextur.put(new Integer(2017), new Integer[] {Integer.valueOf(37), Integer.valueOf(37), Integer.valueOf(93), Integer.valueOf(93), Integer.valueOf(93), Integer.valueOf(93)});
        idtotextur.put(new Integer(35), new Integer[] {Integer.valueOf(80), Integer.valueOf(80), Integer.valueOf(80), Integer.valueOf(80), Integer.valueOf(80), Integer.valueOf(80)});
        idtotextur.put(new Integer(8035), new Integer[] {Integer.valueOf(81), Integer.valueOf(81), Integer.valueOf(81), Integer.valueOf(81), Integer.valueOf(81), Integer.valueOf(81)});
        idtotextur.put(new Integer(7035), new Integer[] {Integer.valueOf(46), Integer.valueOf(46), Integer.valueOf(46), Integer.valueOf(46), Integer.valueOf(46), Integer.valueOf(46)});
        idtotextur.put(new Integer(15035), new Integer[] {Integer.valueOf(45), Integer.valueOf(45), Integer.valueOf(45), Integer.valueOf(45), Integer.valueOf(45), Integer.valueOf(45)});
        idtotextur.put(new Integer(12035), new Integer[] {Integer.valueOf(72), Integer.valueOf(72), Integer.valueOf(72), Integer.valueOf(72), Integer.valueOf(72), Integer.valueOf(72)});
        idtotextur.put(new Integer(14035), new Integer[] {Integer.valueOf(73), Integer.valueOf(73), Integer.valueOf(73), Integer.valueOf(73), Integer.valueOf(73), Integer.valueOf(73)});
        idtotextur.put(new Integer(2035), new Integer[] {Integer.valueOf(74), Integer.valueOf(74), Integer.valueOf(74), Integer.valueOf(74), Integer.valueOf(74), Integer.valueOf(74)});
        idtotextur.put(new Integer(11035), new Integer[] {Integer.valueOf(69), Integer.valueOf(69), Integer.valueOf(69), Integer.valueOf(69), Integer.valueOf(69), Integer.valueOf(69)});
        idtotextur.put(new Integer(3035), new Integer[] {Integer.valueOf(79), Integer.valueOf(79), Integer.valueOf(79), Integer.valueOf(79), Integer.valueOf(79), Integer.valueOf(79)});
        idtotextur.put(new Integer(13035), new Integer[] {Integer.valueOf(86), Integer.valueOf(86), Integer.valueOf(86), Integer.valueOf(86), Integer.valueOf(86), Integer.valueOf(86)});
        idtotextur.put(new Integer(5035), new Integer[] {Integer.valueOf(87), Integer.valueOf(87), Integer.valueOf(87), Integer.valueOf(87), Integer.valueOf(87), Integer.valueOf(87)});
        idtotextur.put(new Integer(4035), new Integer[] {Integer.valueOf(89), Integer.valueOf(89), Integer.valueOf(89), Integer.valueOf(89), Integer.valueOf(89), Integer.valueOf(89)});
        idtotextur.put(new Integer(10035), new Integer[] {Integer.valueOf(97), Integer.valueOf(97), Integer.valueOf(97), Integer.valueOf(97), Integer.valueOf(97), Integer.valueOf(97)});
        idtotextur.put(new Integer(2035), new Integer[] {Integer.valueOf(98), Integer.valueOf(98), Integer.valueOf(98), Integer.valueOf(98), Integer.valueOf(98), Integer.valueOf(98)});
        idtotextur.put(new Integer(9035), new Integer[] {Integer.valueOf(100), Integer.valueOf(10), Integer.valueOf(100), Integer.valueOf(100), Integer.valueOf(100), Integer.valueOf(100)});
        idtotextur.put(new Integer(1035), new Integer[] {Integer.valueOf(101), Integer.valueOf(101), Integer.valueOf(101), Integer.valueOf(101), Integer.valueOf(101), Integer.valueOf(101)});
        idtotextur.put(new Integer(98), new Integer[] {Integer.valueOf(70), Integer.valueOf(70), Integer.valueOf(70), Integer.valueOf(70), Integer.valueOf(70), Integer.valueOf(70)});
        idtotextur.put(new Integer(2098), new Integer[] {Integer.valueOf(28), Integer.valueOf(28), Integer.valueOf(28), Integer.valueOf(28), Integer.valueOf(28), Integer.valueOf(28)});
        idtotextur.put(new Integer(1098), new Integer[] {Integer.valueOf(27), Integer.valueOf(27), Integer.valueOf(27), Integer.valueOf(27), Integer.valueOf(27), Integer.valueOf(27)});
        idtotextur.put(new Integer(20), new Integer[] {Integer.valueOf(15), Integer.valueOf(15), Integer.valueOf(15), Integer.valueOf(15), Integer.valueOf(15), Integer.valueOf(15)});
        MinecraftForge.setGuiHandler(this, this);
        OneTwoFiveNetworking.initReceive(this, "MFFS-immiSMP");
    }

    public void modsLoaded()
    {
        ExplosionWhitelist.addWhitelistedBlock(MFFSFieldblock);
        ExplosionWhitelist.addWhitelistedBlock(MFFSUpgrades);
        ExplosionWhitelist.addWhitelistedBlock(MFFSMaschines);
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 5), new Object[] {" B ", "ACA", " A ", 'A', Items.getItem("advancedAlloy"), 'B', Item.DIAMOND, 'D', Items.getItem("frequencyTransmitter")});
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 4), new Object[] {"ABA", "BCB", "DED", 'A', Items.getItem("advancedAlloy"), 'B', Item.DIAMOND, 'D', Items.getItem("electronicCircuit"), 'C', Items.getItem("frequencyTransmitter"), 'E', Items.getItem("electrolyzedWaterCell")});
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 1), new Object[] {"BBB", "BCB", "DED", 'A', Items.getItem("advancedAlloy"), 'B', Item.DIAMOND, 'D', Items.getItem("electronicCircuit"), 'C', Items.getItem("frequencyTransmitter"), 'E', Items.getItem("electrolyzedWaterCell")});
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 3), new Object[] {"BAB", "ACA", "DED", 'A', Items.getItem("advancedAlloy"), 'B', Item.DIAMOND, 'D', Items.getItem("electronicCircuit"), 'C', Items.getItem("frequencyTransmitter"), 'E', Items.getItem("electrolyzedWaterCell")});
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 2), new Object[] {"ABA", "ACA", "DED", 'A', Items.getItem("advancedAlloy"), 'B', Item.DIAMOND, 'D', Items.getItem("electronicCircuit"), 'C', Items.getItem("frequencyTransmitter"), 'E', Items.getItem("electrolyzedWaterCell")});
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 6), new Object[] {"ABA", "CDC", "ABA", 'A', Items.getItem("refinedIronIngot"), 'B', Items.getItem("insulatedCopperCableItem"), 'C', Items.getItem("electrolyzedWaterCell"), 'D', Items.getItem("batBox")});
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 0), new Object[] {"ABA", "CDC", "AEA", 'A', Items.getItem("electrolyzedWaterCell"), 'B', Items.getItem("advancedAlloy"), 'C', Items.getItem("electronicCircuit"), 'D', Items.getItem("frequencyTransmitter"), 'E', Items.getItem("electrolyzer")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 4), new Object[] {" A ", "ABA", " A ", 'A', Items.getItem("advancedAlloy"), 'B', Items.getItem("electrolyzedWaterCell")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 2), new Object[] {" A ", "ABA", " A ", 'A', Items.getItem("advancedAlloy"), 'B', Items.getItem("electronicCircuit")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 3), new Object[] {" A ", "ABA", " A ", 'A', Items.getItem("advancedAlloy"), 'B', Items.getItem("carbonPlate")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 5), new Object[] {" A ", "ABA", " A ", 'A', Items.getItem("advancedAlloy"), 'B', Items.getItem("frequencyTransmitter")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 1), new Object[] {" A ", "ABA", " A ", 'A', Items.getItem("advancedAlloy"), 'B', Item.BUCKET});
        ModLoader.addRecipe(new ItemStack(MFFSitemMFDwrench), new Object[] {"BCB", "DAD", "DDD", 'A', Item.DIAMOND, 'B', Items.getItem("insulatedCopperCableItem"), 'C', Item.REDSTONE, 'D', Items.getItem("refinedIronIngot")});
        ModLoader.addRecipe(new ItemStack(MFFSitemcardempty), new Object[] {"AAA", "ABA", "AAA", 'A', Item.PAPER, 'B', Items.getItem("electronicCircuit")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 6), new Object[] {" A ", "ABA", " A ", 'A', Items.getItem("advancedAlloy"), 'B', Items.getItem("teslaCoil")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 7), new Object[] {"BAB", "ACA", "BAB", 'A', Items.getItem("advancedAlloy"), 'B', Item.DIAMOND, 'C', Items.getItem("frequencyTransmitter")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 8), new Object[] {"ACA", "BDB", "ACA", 'A', Items.getItem("advancedAlloy"), 'B', Item.REDSTONE, 'C', Items.getItem("trippleInsulatedIronCableItem"), 'D', Items.getItem("frequencyTransmitter")});
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 7), new Object[] {"ADA", "BCB", "ABA", 'A', Items.getItem("carbonPlate"), 'B', Items.getItem("advancedAlloy"), 'C', new ItemStack(MFFSMaschines, 1, 1), 'D', Items.getItem("advancedCircuit")});
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 8), new Object[] {"DCD", "CAC", "DBD", 'A', Items.getItem("advancedMachine"), 'B', Block.CHEST, 'C', Items.getItem("integratedHeatDisperser"), 'D', Items.getItem("advancedAlloy")});
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 9), new Object[] {"ECE", "DBD", "EAE", 'A', Items.getItem("advancedMachine"), 'B', Items.getItem("frequencyTransmitter"), 'C', Items.getItem("detectorCableItem"), 'D', Items.getItem("electronicCircuit"), 'E', Items.getItem("refinedIronIngot")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 0), new Object[] {"ECE", "DBD", "EAE", 'A', Items.getItem("machine"), 'B', Items.getItem("frequencyTransmitter"), 'C', Item.REDSTONE, 'D', Items.getItem("electronicCircuit"), 'E', Items.getItem("refinedIronIngot")});
        ModLoader.addRecipe(new ItemStack(MFFSitemMFDReaktorlink), new Object[] {"DCD", "BAB", "CBC", 'A', Items.getItem("frequencyTransmitter"), 'B', Items.getItem("electronicCircuit"), 'C', Items.getItem("carbonPlate"), 'D', Item.REDSTONE});
        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDwrench), new Object[] {new ItemStack(MFFSitemMFDidtool)});
        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDidtool), new Object[] {new ItemStack(MFFSitemMFDwrench)});
    }

    public static Object getGuiForId(EntityHuman var0, int var1, TileEntity var2)
    {
        int var3 = var2.world.getData(var2.x, var2.y, var2.z);
        int var4 = var2.world.getTypeId(var2.x, var2.y, var2.z);

        if ((var3 == 4 || var3 == 5) && var4 == MFFSUpgrades.id)
        {
            var1 = 1;
        }

        switch (var1)
        {
            case 1:
                return new ContainerGenerator(var0, var2 == null ? new TileEntityGeneratorCore() : (TileEntityGeneratorCore)var2);

            case 2:
                return new ContainerProjektor(var0, var2 == null ? new TileEntityAreaProjektor() : (TileEntityAreaProjektor)var2);

            case 3:
                return new ContainerProjektor(var0, var2 == null ? new TileEntityDirectionalProjektor() : (TileEntityDirectionalProjektor)var2);

            case 4:
                return new ContainerProjektor(var0, var2 == null ? new TileEntityDeflectorProjektor() : (TileEntityDeflectorProjektor)var2);

            case 5:
                return new ContainerProjektor(var0, var2 == null ? new TileEntityDirectionalExtender() : (TileEntityDirectionalExtender)var2);

            case 6:
                return new ContainerProjektor(var0, var2 == null ? new TileEntityTubeProjektor() : (TileEntityTubeProjektor)var2);

            case 7:
                return new ContainerCamoflage(var0, var2 == null ? new TileEntityCamoflageUpgrade() : (TileEntityCamoflageUpgrade)var2);

            case 8:
                return new ContainerProjektor(var0, var2 == null ? new TileEntityReaktorField() : (TileEntityReaktorField)var2);

            case 9:
                return new ContainerReactorCooler(var0, var2 == null ? new TileEntityReaktorCooler() : (TileEntityReaktorCooler)var2);

            case 10:
                return new ContainerReaktorMonitor(var0, var2 == null ? new TileEntityReaktorMonitor() : (TileEntityReaktorMonitor)var2);

            case 11:
                return new ContainerReaktorMonitorClient(var0, var2 == null ? new TileEntityReaktorMonitorClient() : (TileEntityReaktorMonitorClient)var2);

            default:
                return null;
        }
    }

    public String getVersion()
    {
        return ModInfoReader.getModInfoField("/mffs/mod_ModularForceFieldSystem.info.txt", "version");
    }

    public Object getGuiElement(int var1, EntityHuman var2, World var3, int var4, int var5, int var6)
    {
        TileEntity var7 = var3.getTileEntity(var4, var5, var6);
        return var7 == null ? null : getGuiForId(var2, var1, var7);
    }

    public IPacket createPacket(byte var1)
    {
        return var1 == 0 ? new PacketGenericUpdate() : null;
    }
}
