package mffs;

import ic2.api.IWrenchable;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NetworkManager;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet132TileEntityData;

public abstract class TileEntityMaschines extends TileEntityMFFS implements IWrenchable
{
    private boolean init = true;
    private boolean active = false;
    private short facing = -1;
    private float wrenchRate = 1.0F;
   
	@Override
	public ItemStack[] getContents() {
		ItemStack[] r = new ItemStack[getSize()];
		for(int k = 0; k < getSize(); k++)
			r[k] = getItem(k);
		return r;
	}

	@Override
	public void setMaxStackSize(int arg0) {
	}

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.facing = var1.getShort("facing");
        this.active = var1.getBoolean("active");
        this.wrenchRate = var1.getFloat("wrenchRate");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setShort("facing", this.facing);
        var1.setBoolean("active", this.active);
        var1.setFloat("wrenchRate", this.wrenchRate);
    }

    public boolean wrenchCanSetFacing(EntityHuman var1, int var2)
    {
        return false;
    }

    /**
     * Overriden in a sign to provide the text
     */
    public Packet d()
    {
        Packet132TileEntityData var1 = new Packet132TileEntityData();
        var1.a = this.x;
        var1.b = this.y;
        var1.c = this.z;
        var1.e = this.facing & 65535 | (this.active ? 65536 : 0);
        return var1;
    }

    public void onDataPacket(NetworkManager var1, Packet132TileEntityData var2)
    {
        this.facing = (short)var2.e;
        this.active = (var2.e & 65536) != 0;
    }

    public void setFacing(short var1)
    {
        this.facing = var1;
        this.world.notify(this.x, this.y, this.z);
    }

    public boolean getActive()
    {
        return this.active;
    }

    public void setActive(boolean var1)
    {
        this.active = var1;
        this.world.notify(this.x, this.y, this.z);
    }

    public short getFacing()
    {
        return this.facing;
    }

    public void setWrenchRate(float var1)
    {
        this.wrenchRate = var1;
    }

    public boolean wrenchCanRemove(EntityHuman var1)
    {
        return this.getWrenchDropRate() > 0.0F;
    }

    public float getWrenchDropRate()
    {
        return this.wrenchRate;
    }

    public boolean isInit()
    {
        return this.init;
    }

    public void setInit(boolean var1)
    {
        this.init = var1;
    }
}
