package mffs;

import java.util.Iterator;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;
import net.minecraft.server.mod_ModularForceFieldSystem;

public class TileEntityAreaProjektor extends TileEntityProjektor
{
    private int radius = 4;
    private int maxradius = 32;
    private short mode_designe = 1;
    private short maxmode = 2;

    public TileEntityAreaProjektor()
    {
        this.setDropper(false);
    }

    public void handleButton(int var1)
    {
        if (!this.getActive())
        {
            switch (var1)
            {
                case 0:
                    if (this.getRadius() < this.getMaxradius())
                    {
                        this.setRadius(this.getRadius() + 1);
                    }

                    break;

                case 1:
                    if (this.getRadius() > 4)
                    {
                        this.setRadius(this.getRadius() - 1);
                    }

                    break;

                case 2:
                    if (this.getmode_designe() < this.getMaxmode())
                    {
                        this.setmode_designe((short)(this.getmode_designe() + 1));
                    }

                    break;

                case 3:
                    if (this.getmode_designe() > 1)
                    {
                        this.setmode_designe((short)(this.getmode_designe() - 1));
                    }
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.radius = var1.getInt("radius");
        this.mode_designe = var1.getShort("mode_designe");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("radius", this.radius);
        var1.setShort("mode_designe", this.mode_designe);
    }

    public int getMaxradius()
    {
        return this.maxradius;
    }

    public short getMaxmode()
    {
        return this.maxmode;
    }

    public int getRadius()
    {
        return this.radius;
    }

    public void setRadius(int var1)
    {
        this.radius = var1;
        ++this.updateCount;
    }

    public void setRadiusinit(int var1)
    {
        this.radius = var1;
        ++this.updateCount;
    }

    public short getmode_designe()
    {
        return this.mode_designe;
    }

    public void setmode_designe(short var1)
    {
        this.mode_designe = var1;
        ++this.updateCount;
    }

    public void setmode_designeinit(short var1)
    {
        this.mode_designe = var1;
        ++this.updateCount;
    }

    public void addtogrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getProjektor().put(Integer.valueOf(this.getProjektor_ID()), this);
        }
    }

    public void removefromgrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getProjektor().remove(Integer.valueOf(this.getProjektor_ID()));
        }
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (this.isCreate() && this.getLinkGenerator_ID() != 0)
            {
                this.addtogrid();
                this.addfreqcard();
                this.setCreate(false);

                if (this.getActive())
                {
                    this.checkupdates();
                    this.fieldcalculation(true);
                }
            }

            if (this.getLinkGenerator_ID() != 0)
            {
                this.setLinkGenerator(true);

                try
                {
                    this.setLinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getForcepower());
                    this.setMaxlinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getMaxforcepower());
                }
                catch (NullPointerException var3)
                {
                    this.setLinkGenerator(false);
                    this.setLinkPower(0);
                    this.setMaxlinkPower(1000000);
                }
            }
            else
            {
                this.setLinkGenerator(false);
                this.setLinkPower(0);
                this.setMaxlinkPower(1000000);
            }

            boolean var1 = this.world.isBlockPowered(this.x, this.y, this.z);
            boolean var2 = this.world.isBlockIndirectlyPowered(this.x, this.y, this.z);

            if ((var1 || var2) && this.isLinkGenerator() && this.getLinkPower() > this.Forcepowerneed(this.radius * this.radius * 6, true) && !this.getActive())
            {
                this.setActive(true);
                this.fieldcalculation(false);
                this.FieldGenerate(true);
                this.world.notify(this.x, this.y, this.z);
            }

            if ((!var1 && !var2 || !this.isLinkGenerator() || this.getLinkPower() < this.Forcepowerneed(this.radius * this.radius * 6, false)) && this.getActive())
            {
                this.setActive(false);
                this.destroyField();
                this.world.notify(this.x, this.y, this.z);
            }

            if (this.getActive() && this.getWrenchDropRate() != -1.0F)
            {
                this.setWrenchRate(-1.0F);
            }

            if (!this.getActive() && this.getWrenchDropRate() != 1.0F)
            {
                this.setWrenchRate(1.0F);
            }

            if (this.getActive())
            {
                this.FieldGenerate(false);
            }

            if (this.getTicker() == 10)
            {
                this.checkupdates();
                this.addfreqcard();
                this.setTicker((short)0);
            }

            this.setTicker((short)(this.getTicker() + 1));
        }
    }

    public void checkupdates()
    {
        this.setSubwater(false);
        this.setDome(false);
        this.setHardner(false);
        this.setCamouflage(false);

        for (int var1 = this.x - 1; var1 <= this.x + 1; ++var1)
        {
            for (int var2 = this.y - 1; var2 <= this.y + 1; ++var2)
            {
                for (int var3 = this.z - 1; var3 <= this.z + 1; ++var3)
                {
                    if (this.world.getTypeId(var1, var2, var3) == mod_ModularForceFieldSystem.MFFSUpgrades.id)
                    {
                        int var4 = this.world.getData(var1, var2, var3);
                        TileEntity var5 = this.world.getTileEntity(var1, var2, var3);

                        if (var5 != null)
                        {
                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == 0 && (var4 == 0 || var4 == 1 || var4 == 2 || var4 == 3 || var4 == 7))
                            {
                                ((TileEntityPassivUpgrade)var5).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var5).setConnectet_typID((short)2);
                                this.world.k(var5.x, var5.y, var5.z);
                            }

                            if (var4 == 7 && ((TileEntityCamoflageUpgrade)var5).getItem_ID() != this.getTextur())
                            {
                                this.setTextur(((TileEntityCamoflageUpgrade)var5).getItem_ID());
                            }

                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var5).getConnectet_typID() == 2)
                            {
                                if (((TileEntityPassivUpgrade)var5).getActive() != this.getActive())
                                {
                                    ((TileEntityPassivUpgrade)var5).setActive(this.getActive());
                                }

                                switch (var4)
                                {
                                    case 1:
                                        this.setSubwater(true);
                                        break;

                                    case 2:
                                        this.setDome(true);
                                        break;

                                    case 3:
                                        this.setHardner(true);

                                    case 4:
                                    case 5:
                                    case 6:
                                    default:
                                        break;

                                    case 7:
                                        this.setCamouflage(true);
                                }
                            }
                        }
                    }
                }
            }
        }

        if (this.isCamouflage())
        {
            this.setffmeta((short)2);
        }
        else
        {
            this.setffmeta((short)0);
        }
    }

    public void fieldcalculation(boolean var1)
    {
        if (!this.field_queue.isEmpty())
        {
            this.field_queue.clear();
        }

        int var2 = this.radius;
        int var3;
        int var4;
        int var5;
        int var6;

        if (this.mode_designe == 1)
        {
            var3 = 0;

            if (this.y + this.radius > 127)
            {
                var3 = 127 - (this.y + this.radius);
            }

            if (this.isDome())
            {
                var2 = 0;
            }

            for (var4 = 0 - var2; var4 <= this.radius + var3; ++var4)
            {
                for (var5 = 0 - this.radius; var5 <= this.radius; ++var5)
                {
                    for (var6 = 0 - this.radius; var6 <= this.radius; ++var6)
                    {
                        this.hasher.setLength(0);
                        this.hasher.append(this.x + var5).append("/").append(this.y + var4).append("/").append(this.z + var6);
                        ForceFieldWorldMap var7 = WorldMap.getForceFieldforWorld(this.world).addandgetffmp(this.x + var5, this.y + var4, this.z + var6);

                        if (var1)
                        {
                            var7.ffworld_remove(this.getProjektor_ID());
                        }

                        if (var5 != 0 - this.radius && var5 != this.radius && var4 != 0 - this.radius && var4 != this.radius + var3 && var6 != 0 - this.radius && var6 != this.radius)
                        {
                            if (this.isSubwater() && this.world.getMaterial(this.x + var5, this.y + var4, this.z + var6).isLiquid())
                            {
                                this.world.setTypeId(this.x + var5, this.y + var4, this.z + var6, 0);
                            }
                        }
                        else
                        {
                            boolean var8 = !this.world.getMaterial(this.x + var5, this.y + var4, this.z + var6).isBuildable();
                            boolean var9 = this.world.getTypeId(this.x + var5, this.y + var4, this.z + var6) == mod_ModularForceFieldSystem.MFFSFieldblock.id;

                            if (var9)
                            {
                                var8 = true;
                            }

                            if (var7.listsize() == 0)
                            {
                                if (this.getffmeta() == 2)
                                {
                                    TexturworldMap.getTexturMap(Integer.valueOf(this.world.worldProvider.dimension)).add(this.x + var5, this.y + var4, this.z + var6, this.getTextur());
                                }

                                var7.ffworld_addFirst(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var8, true, this.getffmeta()));
                                this.field_queue.add(this.hasher.toString());
                            }
                            else
                            {
                                var7.ffworld_addLast(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var8, false, this.getffmeta()));
                                this.field_queue.add(this.hasher.toString());
                            }
                        }
                    }
                }
            }
        }

        if (this.mode_designe == 2)
        {
            if (this.isDome())
            {
                var2 = 0;
            }

            for (var3 = 0 - var2; var3 <= this.radius; ++var3)
            {
                for (var4 = 0 - this.radius; var4 <= this.radius; ++var4)
                {
                    for (var5 = 0 - this.radius; var5 <= this.radius; ++var5)
                    {
                        var6 = this.x + var4 - this.x;
                        int var14 = this.y + var3 - this.y;
                        int var16 = this.z + var5 - this.z;
                        double var15 = Math.sqrt((double)(var6 * var6 + var14 * var14 + var16 * var16));
                        this.hasher.setLength(0);
                        this.hasher.append(this.x + var4).append("/").append(this.y + var3).append("/").append(this.z + var5);
                        ForceFieldWorldMap var11 = WorldMap.getForceFieldforWorld(this.world).addandgetffmp(this.x + var4, this.y + var3, this.z + var5);

                        if (var15 <= (double)this.radius && var15 > (double)(this.radius - 1))
                        {
                            boolean var12 = !this.world.getMaterial(this.x + var4, this.y + var3, this.z + var5).isBuildable();
                            boolean var13 = this.world.getTypeId(this.x + var4, this.y + var3, this.z + var5) == mod_ModularForceFieldSystem.MFFSFieldblock.id;

                            if (var13)
                            {
                                var12 = true;
                            }

                            if (var11.listsize() == 0)
                            {
                                if (this.getffmeta() == 2)
                                {
                                    TexturworldMap.getTexturMap(Integer.valueOf(this.world.worldProvider.dimension)).add(this.x + var4, this.y + var3, this.z + var5, this.getTextur());
                                }

                                var11.ffworld_addFirst(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var12, true, this.getffmeta()));
                                this.field_queue.add(this.hasher.toString());
                            }
                            else
                            {
                                var11.ffworld_addLast(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var12, false, this.getffmeta()));
                                this.field_queue.add(this.hasher.toString());
                            }
                        }
                        else if (this.isSubwater() && var15 <= (double)this.radius && this.world.getMaterial(this.x + var4, this.y + var3, this.z + var5).isLiquid())
                        {
                            this.world.setTypeId(this.x + var4, this.y + var3, this.z + var5, 0);
                        }
                    }
                }
            }
        }
    }

    public void destroyField()
    {
        Iterator var1 = this.field_queue.iterator();

        while (var1.hasNext())
        {
            String var2 = (String)var1.next();
            ForceFieldWorldMap var3 = WorldMap.getForceFieldforWorld(this.world).getFFWM(var2.toString());

            if (var3.listsize() >= 1)
            {
                if (var3.ffworld_getfirstfreespace() && var3.ffworld_getfistactive() && var3.ffworld_getfirstProjektor_ID() == this.getProjektor_ID())
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                    this.world.setTypeId(var3.getX(), var3.getY(), var3.getZ(), 0);

                    if (var3.listsize() >= 1)
                    {
                        var3.ffworld_setfirstfreeospace(false);
                        var3.ffworld_setfistactive(true);
                    }
                }
                else
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                }
            }
        }

        this.field_queue.clear();
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    public int[] getUpdate()
    {
        return new int[] {this.radius, this.maxradius, this.mode_designe, this.maxmode};
    }

    public void handleUpdate(int[] var1)
    {
        this.radius = var1[0];
        this.maxradius = var1[1];
        this.mode_designe = (short)var1[2];
        this.maxmode = (short)var1[3];
    }
}
