package mods.immibis.infinitubes;

import mods.immibis.cobaltite.*;
import mods.immibis.cobaltite.CobaltiteMod.RegisteredTile;
import mods.immibis.cobaltite.PacketType.Direction;
import mods.immibis.core.api.FMLModInfo;
import mods.immibis.core.api.util.Colour;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;

@Mod(modid = "InfiniTubes", name = "InfiniTubes", version = "59.0.3", dependencies = "required-after:ImmibisCore")
@CobaltiteMod(
		tiles = {
				@RegisteredTile(id = "immibis.infinitube", tile = InfiniTubeTile.class),
				@RegisteredTile(id = "immibis.infinitube.transporter", tile = TransporterTile.class),
				@RegisteredTile(id = "immibis.infinitube.powerjunction", tile = PowerJunctionTile.class),
				@RegisteredTile(id = "immibis.infinitube.dislocator", tile = DislocatorTile.class)
		},
		channel = InfiniTubes.CHANNEL
	)
@FMLModInfo(
		url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
		description="A new system of item transport.",
		authors="immibis"
	)
public class InfiniTubes extends ModBase {

	public static final String CHANNEL = "InfiniTubes";

	@AssignedBlock(id="infinitube", item=InfiniTubeItem.class)
	public static InfiniTubeBlock tube;

	@AssignedBlock(id="machine", item=MachineItem.class)
	public static MachineBlock machines;

	@Instance("InfiniTubes")
	public static InfiniTubes instance;

	@TileGUI(container = TransporterContainer.class, gui = TransporterGui.class)
	public static final int GUI_TRANSPORTER = 0;
	
	@TileGUI(container = DislocatorContainer.class, gui = DislocatorGui.class)
	public static final int GUI_DISLOCATOR = 1;

	@PacketType(type = TransporterGuiUpdatePacket.class, direction = Direction.BOTH)
	public static final byte PKT_TRANSPORTER_GUI = 0;
	
	@PacketType(type = DislocatorGuiUpdatePacket.class, direction = Direction.BOTH)
	public static final byte PKT_DISLOCATOR_GUI = 1;

	@Configurable("usePower")
	public static boolean usePower = true;
	
	@Configurable("debug")
	public static boolean debug = false;

	@EventHandler public void init(FMLInitializationEvent evt) {_init(evt);}
	@EventHandler public void preinit(FMLPreInitializationEvent evt) {_preinit(evt);}
	
	@Override
	protected void addRecipes() throws Exception {
		WorldTubeMap.DEBUG = debug;
		
		GameRegistry.addRecipe(new ItemStack(tube, 64, 0),
			"I#I",
			"RDR",
			"ILI",
			'I', Items.iron_ingot,
			'L', new ItemStack(Items.dye, 1, Colour.CYAN.dyeId()),
			'R', Items.redstone,
			'D', Items.diamond,
			'#', Blocks.iron_block
		);
		
		GameRegistry.addRecipe(new ItemStack(machines, 8, 0),
			"I|I",
			"RDR",
			"I|I",
			'D', Items.diamond,
			'|', new ItemStack(tube, 1, 0),
			'I', Items.iron_ingot,
			'R', Items.redstone
		);
		
		GameRegistry.addRecipe(new ItemStack(machines, 1, 1),
			"I|I",
			"G#G",
			"III",
			'#', Blocks.gold_block,
			'G', Items.gold_ingot,
			'I', Items.iron_ingot,
			'|', new ItemStack(tube, 1, 0)
		);
		
		GameRegistry.addRecipe(new ItemStack(machines, 8, 2),
			"I|I",
			"GDG",
			"I|I",
			'D', Items.diamond,
			'|', new ItemStack(tube, 1, 0),
			'I', Items.iron_ingot,
			'G', Items.glowstone_dust
		);
		
		GameRegistry.addShapelessRecipe(new ItemStack(machines, 1, 0),
			new ItemStack(machines, 1, 2),
			Items.redstone
		);
		
		GameRegistry.addShapelessRecipe(new ItemStack(machines, 1, 2),
			new ItemStack(machines, 1, 0),
			Items.glowstone_dust
		);
	}
}
