package mods.immibis.infinitubes;


import mods.immibis.core.api.porting.PortableBlockRenderer;
import mods.immibis.core.api.util.Dir;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class InfiniTubeStaticRenderer implements PortableBlockRenderer {
	private static float uMin, uMax, vMin, vMax;
	private static RenderBlocks render;
	
	private static void setTexture(IIcon i) {
		if(render.overrideBlockTexture != null)
			i = render.overrideBlockTexture;
		uMin = i.getInterpolatedU(4);
		uMax = i.getInterpolatedU(12);
		vMin = i.getMinV();
		vMax = i.getMaxV();
	}
	
	private RotatedTessellator rt = new RotatedTessellator();
	
	public static final InfiniTubeStaticRenderer INSTANCE = new InfiniTubeStaticRenderer();
	
	private void renderLANWire(int x, int y, int z) {
		mods.immibis.core.RenderUtilsIC.setBrightness(render.blockAccess, x, y, z);
		Tessellator.instance.setColorRGBA(255, 255, 255, 255);
		
		boolean nx = InfiniTubeBlock.connects(render.blockAccess, x-1,y,z, Dir.NX);
		boolean px = InfiniTubeBlock.connects(render.blockAccess, x+1,y,z, Dir.PX);
		boolean ny = InfiniTubeBlock.connects(render.blockAccess, x,y-1,z, Dir.NY);
		boolean py = InfiniTubeBlock.connects(render.blockAccess, x,y+1,z, Dir.PY);
		boolean nz = InfiniTubeBlock.connects(render.blockAccess, x,y,z-1, Dir.NZ);
		boolean pz = InfiniTubeBlock.connects(render.blockAccess, x,y,z+1, Dir.PZ);
		
		final double min = 4/16f, max=12/16f;
		
		//System.out.println("render "+x+" "+y+" "+z+" "+nx+" "+px+" "+ny+" "+py+" "+nz+" "+pz);
		
		if(!nx && !ny && !nz && !px && !py && !pz) {
			rt.setup(x, y, z, Dir.NY);
			setTexture(InfiniTubeBlock.iJunction);
			renderLANWireVertical(min, max, true, true);
			return;
		}
		
		if(nx || px) {
			rt.setup(x, y, z, Dir.NX);
			setTexture(ny || py || nz || pz ? InfiniTubeBlock.iJunction : InfiniTubeBlock.iStraight);
			renderLANWireVertical(nx?0:min, px?1:max, !nx && !ny && !py && !nz && !pz, !px && !ny && !py && !nz && !pz);
		}
		
		if(ny || py) {
			rt.setup(x, y, z, Dir.NY);
			setTexture(nx || px || nz || pz ? InfiniTubeBlock.iJunction : InfiniTubeBlock.iStraight);
			renderLANWireVertical(ny?0:min, py?1:max, !ny && !px && !px && !nz && !pz, !py && !nx && !px && !nz && !pz);
		}
		
		if(nz || pz) {
			rt.setup(x, y, z, Dir.NZ);
			setTexture(ny || py || nx || px ? InfiniTubeBlock.iJunction : InfiniTubeBlock.iStraight);
			renderLANWireVertical(nz?0:min, pz?1:max, !nz && !ny && !py && !nx && !px, !pz && !ny && !py && !nx && !px);
		}
	}
	
	private void renderLANWireVertical(double bottom, double top, boolean bottomcap, boolean topcap) {
		final double min = 4/16.0, max=12/16.0;
		
		double vt = vMin + top*(vMax - vMin);
		double vb = vMin + bottom*(vMax - vMin);
		
		topcap = true;
		bottomcap = true;
		
		rt.setNormal(0, 0, -1);
		rt.addVertexWithUV(min, top, min, uMin, vt);
		rt.addVertexWithUV(max, top, min, uMax, vt);
		rt.addVertexWithUV(max, bottom, min, uMax, vb);
		rt.addVertexWithUV(min, bottom, min, uMin, vb);
		
		rt.setNormal(0, 0, 1);
		rt.addVertexWithUV(min, bottom, max, uMin, vb);
		rt.addVertexWithUV(max, bottom, max, uMax, vb);
		rt.addVertexWithUV(max, top, max, uMax, vt);
		rt.addVertexWithUV(min, top, max, uMin, vt);
		
		rt.setNormal(-1, 0, 0);
		rt.addVertexWithUV(min, bottom, min, uMin, vb);
		rt.addVertexWithUV(min, bottom, max, uMax, vb);
		rt.addVertexWithUV(min, top, max, uMax, vt);
		rt.addVertexWithUV(min, top, min, uMin, vt);
		
		rt.setNormal(1, 0, 0);
		rt.addVertexWithUV(max, top, min, uMin, vt);
		rt.addVertexWithUV(max, top, max, uMax, vt);
		rt.addVertexWithUV(max, bottom, max, uMax, vb);
		rt.addVertexWithUV(max, bottom, min, uMin, vb);
		
		if(bottomcap) {
			double d1 = (4/16.0)*(vMax - vMin), d2=(12/16.0)*(vMax - vMin);
			
			setTexture(InfiniTubeBlock.iJunction);
			
			rt.setNormal(0, -1, 0);
			rt.addVertexWithUV(max, bottom, min, uMax, vMin+d1);
			rt.addVertexWithUV(max, bottom, max, uMax, vMin+d2);
			rt.addVertexWithUV(min, bottom, max, uMin, vMin+d2);
			rt.addVertexWithUV(min, bottom, min, uMin, vMin+d1);
			
		}
		
		if(topcap) {
			double d1 = (4/16.0)*(vMax - vMin), d2=(12/16.0)*(vMax - vMin);
			
			setTexture(InfiniTubeBlock.iJunction);
			
			rt.setNormal(0, 1, 0);
			rt.addVertexWithUV(min, top, min, uMin, vMin+d1);
			rt.addVertexWithUV(min, top, max, uMin, vMin+d2);
			rt.addVertexWithUV(max, top, max, uMax, vMin+d2);
			rt.addVertexWithUV(max, top, min, uMax, vMin+d1);
			
		}
	}

	@Override
	public boolean renderWorldBlock(RenderBlocks render, IBlockAccess world, int x, int y, int z, Block block, int model) {
		InfiniTubeStaticRenderer.render = render;
		renderLANWire(x, y, z);
		return true;
	}

	@Override
	public void renderInvBlock(RenderBlocks render, Block block, int meta, int model) {
		InfiniTubeStaticRenderer.render = render;
		rt.setup(-0.5, -0.5, -0.5, Dir.NY);
		
		setTexture(InfiniTubeBlock.iJunction);
		
		rt.base.startDrawingQuads();
		rt.base.setColorOpaque(255, 255, 255);
		renderLANWireVertical(0, 1, true, true);
		rt.base.draw();
		
	}
}
