package mods.immibis.infinitubes;

import mods.immibis.infinitubes.Operation.DontCauseLagException;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public interface IItemReceptor {
	/**
	 * Adds items from the given item stack to this item receptor.
	 * Subtracts the number of added items from stack.stackSize.
	 * @throws DontCauseLagException If the operation's method call limit is exceeded.
	 */
	public void insert(ItemStack stack, ForgeDirection side, String label, Operation op) throws DontCauseLagException;
	
	/**
	 * Higher priorities get first chance to use the item.
	 */
	public int getItemReceptorPriority();
}
