package mods.immibis.infinitubes;


import java.util.concurrent.atomic.AtomicInteger;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import mods.immibis.core.MainThreadTaskQueue;
import mods.immibis.core.api.MultiInterfaceClass;
import mods.immibis.core.api.MultiInterfaceClass.Interface;
import cpw.mods.fml.relauncher.Side;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;

@MultiInterfaceClass(
	base="mods.immibis.infinitubes.DislocatorTileBase",
	interfaces={
		@Interface(check="dan200.computer.api.IPeripheral", impl="mods.immibis.infinitubes.DislocatorTile$CCImpl")
	})
public class DislocatorTile extends DislocatorTileBase {
	public static class CCImpl extends DislocatorTileBase implements IPeripheral {

		@Override
		public void attach(IComputerAccess arg0) {
		}
		
		private static AtomicInteger nextID = new AtomicInteger(0);

		@Override
		public Object[] callMethod(final IComputerAccess computer, ILuaContext ctx, int methodNum, Object[] args) throws LuaException {
			
			int amt;
			String search, eject;
			
			try {
				amt = (int)(double)(Double)args[0];
				search = (String)args[1];
				eject = (String)args[2];
			} catch(Exception e) {
				throw new LuaException("Usage: dislocator.pull(int stackSize, string searchLabel, string ejectLabel)");
			}
			
			if(amt < 1 || amt > 64)
				throw new LuaException("stack size must be from 1 to 64");
			
			final int amt2 = amt;
			final String search2 = search, eject2 = eject;
			
			final int requestID = nextID.getAndIncrement();
			
			MainThreadTaskQueue.enqueue(new Runnable() {
				
				@Override
				public void run() {
					CCImpl te = CCImpl.this;
					
					String oldF = te.filter, oldL = te.label;
					String[] oldCF = te.cachedFilter;
					
					te.filter = search2;
					te.label = eject2;
					te.cachedFilter = null;
					
					boolean result = te.suck(amt2);
					
					te.cachedFilter = oldCF;
					te.filter = oldF;
					te.label = oldL;
					
					computer.queueEvent("dislocator_done", new Object[] {requestID, result});
				}
				
			}, Side.SERVER);
			
			return new Object[] {requestID};
		}
		
		@Override
		public void detach(IComputerAccess arg0) {
		}

		@Override
		public String[] getMethodNames() {
			return new String[] {
				"pull"
			};
		}

		@Override
		public String getType() {
			return "dislocator";
		}

		@Override
		public boolean equals(IPeripheral other) {
			return other == this;
		}
		
		static {
			ComputerCraftAPI.registerPeripheralProvider(new IPeripheralProvider() {
				@Override
				public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
					if(world.getBlock(x, y, z) == InfiniTubes.machines) {
						TileEntity te = world.getTileEntity(x, y, z);
						if(te instanceof CCImpl)
							return (CCImpl)te;
					}
					return null;
				}
			});
		}
		
	}
}
