package mods.immibis.infinitubes;

import mods.immibis.core.api.util.BaseGuiContainer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class DislocatorGui extends BaseGuiContainer<DislocatorContainer> {
	public DislocatorGui(DislocatorContainer container) {
		super(container, 186, 190, R.gui.dislocator);
	}
	
	private void drawSideColour(int x, int y, int side) {
		int u = 198 + (side % 2) * 16;
		int v = 34 + (side / 2) * 16;
		drawTexturedModalRect(x+guiLeft, y+guiTop, u, v, 12, 12);
	}
	
	private GuiTextField txtLabel, txtFilter;
	
	@Override
	public void initGui() {
		super.initGui();
		
		//btnRecursive = new GuiButton(2, guiLeft+65, guiTop+84, 30, 20, "Off");
		//controlList.add(btnRecursive);
		
		txtLabel = new GuiTextField(fontRendererObj, guiLeft+94, guiTop+60, 80, 16);
		txtFilter = new GuiTextField(fontRendererObj, guiLeft+94, guiTop+78, 80, 16);
		
		txtLabel.setMaxStringLength(256);
		txtFilter.setMaxStringLength(256);
		
		txtLabel.setText(container.getInv().label);
		txtFilter.setText(container.getInv().filter);
	}
	
	private void sendLabels() {
		DislocatorGuiUpdatePacket p = new DislocatorGuiUpdatePacket();
		p.label = txtLabel.getText();
		p.filter = txtFilter.getText();
		container.sendActionPacket(p);
	}
	
	@Override
	protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
		//btnRecursive.displayString = container.recursive ? "On" : "Off";
		
		super.drawGuiContainerBackgroundLayer(var1, var2, var3);
		
		drawSideColour(63, 42, container.facing);
		
		int textColour = 0xFFFFFF;
		
		drawString(I18n.format("gui.infinitubes.dislocator.item"), 31, 21, textColour);
		drawString(I18n.format("gui.infinitubes.dislocator.direction"), 8, 44, textColour);
		drawString(I18n.format("gui.infinitubes.dislocator.eject"), 8, 63, textColour);
		drawString(I18n.format("gui.infinitubes.dislocator.search"), 8, 81, textColour);
		
		//drawString("Recursion:", 8, 90, textColour);
		
		txtLabel.drawTextBox();
		txtFilter.drawTextBox();
	}
	
	@Override
	protected void mouseClicked(int par1, int par2, int par3) {
		int x = par1 - guiLeft, y = par2 - guiTop;
		if(x >= 63 && y >= 42 && x < 75 && y < 54) {
			if(par3 == 0)
				container.sendButtonPressed(0); // dir++
			else if(par3 == 1)
				container.sendButtonPressed(1); // dir--
		}
		super.mouseClicked(par1, par2, par3);
		txtLabel.mouseClicked(par1, par2, par3);
		txtFilter.mouseClicked(par1, par2, par3);
	}
	
	@Override
	protected void actionPerformed(GuiButton par1GuiButton) {
		container.sendButtonPressed(par1GuiButton.id);
	}
	
	private boolean textboxDirty = false;
	
	@Override
	public void keyTyped(char par1, int par2) {
		if(txtLabel.isFocused())
			if(txtLabel.textboxKeyTyped(par1, par2)) {
				textboxDirty = true;
				return;
			}
		if(txtFilter.isFocused())
			if(txtFilter.textboxKeyTyped(par1, par2)) {
				textboxDirty = true;
				return;
			}
		if(textboxDirty) {
			textboxDirty = false;
			sendLabels();
		}
		super.keyTyped(par1, par2);
	}
}
