package mods.immibis.infinitubes;

import mods.immibis.core.SlotFakeCounted;
import mods.immibis.core.api.net.IPacket;
import mods.immibis.core.api.util.BaseContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;

public class DislocatorContainer extends BaseContainer<DislocatorTile> {
	public int facing;
	public boolean recursive;

	public DislocatorContainer(EntityPlayer player, DislocatorTile tile) {
		super(player, tile);
		
		for(int x = 0; x < 9; x++)
			addSlotToContainer(new Slot(player.inventory, x, 13 + x*18, 167));
		for(int y = 0; y < 3; y++)
			for(int x = 0; x < 9; x++)
				addSlotToContainer(new Slot(player.inventory, x + y*9 + 9, 13 + x*18, 109 + y*18));
		
		addSlotToContainer(new SlotFakeCounted(tile, 0, 62, 17));
	}
	
	@Override
	public void detectAndSendChanges() {
		super.detectAndSendChanges();
		
		setProgressBar(0, inv.facing | (inv.recursive ? 8 : 0));
	}
	
	@Override
	public void updateProgressBar(int par1, int par2) {
		if(par1 == 0) {
			facing = par2 & 7;
			recursive = (par2 & 8) != 0;
		} else
			super.updateProgressBar(par1, par2);
	}

	@Override
	public void onButtonPressed(int id) {
		switch(id) {
		case 0: inv.facing = (byte)((inv.facing + 1) % 6); break;
		case 1: inv.facing = (byte)((inv.facing + 5) % 6); break;
		case 2: inv.recursive = !inv.recursive; return;
		}
		inv.resendDescriptionPacket();
	}

	@Override
	public void onActionPacket(IPacket p) {
		if(p instanceof DislocatorGuiUpdatePacket) {
			DislocatorGuiUpdatePacket up = (DislocatorGuiUpdatePacket)p;
			inv.label = up.label;
			inv.filter = up.filter;
			inv.cachedFilter = null;
			inv.resendDescriptionPacket();
		}
	}

	public DislocatorTile getInv() {
		return inv;
	}
}
