package mods.immibis.infinitubes;

import mods.immibis.core.SlotFake;
import mods.immibis.core.api.net.IPacket;
import mods.immibis.core.api.util.BaseContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;

public class TransporterContainer extends BaseContainer<TransporterTile> {
	
	public int inputSide, outputSide, priority;
	public boolean invertFilter, powerBridge;

	public TransporterContainer(EntityPlayer player, TransporterTile tile) {
		super(player, tile);
		
		for(int x = 0; x < 9; x++)
			addSlotToContainer(new Slot(player.inventory, x, 13 + x*18, 189));
		for(int y = 0; y < 3; y++)
			for(int x = 0; x < 9; x++)
				addSlotToContainer(new Slot(player.inventory, x + y*9 + 9, 13 + x*18, 131 + y*18));
		for(int x = 0; x < 9; x++)
			addSlotToContainer(new SlotFake(tile, x, 13 + x*18, 20));
	}
	
	@Override
	public void detectAndSendChanges() {
		super.detectAndSendChanges();
		
		setProgressBar(0, inv.inputSide | (inv.outputSide << 3) | (inv.invertFilter ? 0x40 : 0) | (inv.powerBridge ? 0x80 : 0));
		setProgressBar(1, inv.priority);
	}
	
	@Override
	public void updateProgressBar(int par1, int par2) {
		if(par1 == 0) {
			inputSide = par2 & 7;
			outputSide = (par2 >> 3) & 7;
			invertFilter = (par2 & 0x40) != 0;
			powerBridge = (par2 & 0x80) != 0;
		} else if(par1 == 1)
			priority = par2;
		else
			super.updateProgressBar(par1, par2);
	}

	@Override
	public void onButtonPressed(int id) {
		switch(id) {
		case 0: inv.inputSide = (inv.inputSide + 1) % 6; break;
		case 1: inv.inputSide = (inv.inputSide + 5) % 6; break;
		case 2: inv.outputSide = (inv.outputSide + 1) % 6; break;
		case 3: inv.outputSide = (inv.outputSide + 5) % 6; break;
		case 4: if(inv.priority < 999) inv.priority++; return;
		case 5: if(inv.priority > 0) inv.priority--; return;
		case 6: inv.invertFilter = !inv.invertFilter; return;
		case 7: inv.powerBridge = !inv.powerBridge; return;
		}
		inv.resendDescriptionPacket();
	}

	@Override
	public void onActionPacket(IPacket p) {
		if(p instanceof TransporterGuiUpdatePacket) {
			TransporterGuiUpdatePacket up = (TransporterGuiUpdatePacket)p;
			inv.inLabel = up.inLabel;
			inv.outLabel = up.outLabel;
			inv.inFilter = null;
			inv.resendDescriptionPacket();
		}
	}

	public TransporterTile getInv() {
		return inv;
	}
}
