package mods.immibis.infinitubes;

// Keeps track of the amount of work done in a single operation, to prevent
// people causing lag.
public class Operation {
	public static class DontCauseLagException extends Exception {
		private static final long serialVersionUID = 1L;
	}
	
	// Each call also uses power, so if power is enabled,
	// the limit is higher in case someone actually has that much power.
	private int callsRemaining = InfiniTubes.usePower ? 1000000 : 100000;

	public void countMethodCall() throws DontCauseLagException {
		if(--callsRemaining < 0)
			throw new DontCauseLagException();
	}
	
	
}
