package mods.immibis.infinitubes;

import java.util.ArrayList;

public class LabelParser {
	public interface Predicate {
		public boolean matches(String label);
	}
	
	public static Predicate parseFilter(String str) {
		final ArrayList<String[]> alternatives = new ArrayList<String[]>();
		for(String alternative : split(str, '|')) {
			alternatives.add(split(alternative, '*'));
		}
		return new Predicate() {
			@Override
			public boolean matches(String label) {
				for(String[] a : alternatives) {
					//System.out.println(Arrays.toString(a)+" matches "+label+" -> "+matchesWildcard(a, label));
					if(matchesWildcard(a, label))
						return true;
				}
				return false;
			}
			
			private boolean matchesWildcard(String[] parts, String str) {
				if(parts.length == 0) {
					//System.out.println("no parts, "+str.equals("")+", "+str);
					return str.equals("");
				}
				
				if(!str.startsWith(parts[0]))
					return false;
				
				int pos = parts[0].length();
				for(int k = 1; k < parts.length; k++) {
					String part = parts[k];
					pos = str.indexOf(part, pos);
					if(pos == -1)
						return false;
					pos += part.length();
				}
				// ends in * or no extra characters -> successful match
				return (parts.length > 1 && parts[parts.length - 1].equals("")) || pos == str.length();
			}
		};
	}

	private static String[] split(String str, char c) {
		int pos = 0;
		ArrayList<String> rv = new ArrayList<String>();
		while(true) {
			int next = str.indexOf(c, pos);
			if(next < 0) {
				rv.add(str.substring(pos));
				return rv.toArray(new String[rv.size()]);
			}
			rv.add(str.substring(pos, next));
			pos = next + 1;
		}
	}
}
