package mods.immibis.infinitubes;

import mods.immibis.cobaltite.*;
import mods.immibis.cobaltite.CobaltiteMod.RegisteredTile;
import mods.immibis.cobaltite.PacketType.Direction;
import mods.immibis.core.api.FMLModInfo;
import mods.immibis.core.api.util.Colour;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;

@Mod(modid = "InfiniTubes", name = "InfiniTubes", version = "56.0.0", dependencies = "required-after:ImmibisCore")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)
@CobaltiteMod(
		tiles = {
				@RegisteredTile(id = "immibis.infinitube", tile = InfiniTubeTile.class),
				@RegisteredTile(id = "immibis.infinitube.transporter", tile = TransporterTile.class),
				@RegisteredTile(id = "immibis.infinitube.powerjunction", tile = PowerJunctionTile.class),
				@RegisteredTile(id = "immibis.infinitube.dislocator", tile = DislocatorTile.class)
		},
		channel = InfiniTubes.CHANNEL
	)
@FMLModInfo(
		url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
		description="A new system of item transport.",
		authors="immibis"
	)
public class InfiniTubes extends ModBase {

	public static final String CHANNEL = "InfiniTubes";

	@AssignedBlock(id="infinitube", item=InfiniTubeItem.class)
	public static InfiniTubeBlock tube;

	@AssignedBlock(id="machine", item=MachineItem.class)
	public static MachineBlock machines;

	@Instance("InfiniTubes")
	public static InfiniTubes instance;

	@TileGUI(container = TransporterContainer.class, gui = TransporterGui.class)
	public static final int GUI_TRANSPORTER = 0;
	
	@TileGUI(container = DislocatorContainer.class, gui = DislocatorGui.class)
	public static final int GUI_DISLOCATOR = 1;

	@PacketType(type = TransporterGuiUpdatePacket.class, direction = Direction.BOTH)
	public static final byte PKT_TRANSPORTER_GUI = 0;
	
	@PacketType(type = DislocatorGuiUpdatePacket.class, direction = Direction.BOTH)
	public static final byte PKT_DISLOCATOR_GUI = 1;

	@Configurable("usePower")
	public static boolean usePower = true;

	@EventHandler public void init(FMLInitializationEvent evt) {_init(evt);}
	@EventHandler public void preinit(FMLPreInitializationEvent evt) {_preinit(evt);}
	
	@Override
	protected void addRecipes() throws Exception {
		GameRegistry.addRecipe(new ItemStack(tube, 64, 0),
			"I#I",
			"RDR",
			"ILI",
			'I', Item.ingotIron,
			'L', new ItemStack(Item.dyePowder, 1, Colour.CYAN.dyeId()),
			'R', Item.redstone,
			'D', Item.diamond,
			'#', Block.blockIron
		);
		
		GameRegistry.addRecipe(new ItemStack(machines, 8, 0),
			"I|I",
			"RDR",
			"I|I",
			'D', Item.diamond,
			'|', new ItemStack(tube, 1, 0),
			'I', Item.ingotIron,
			'R', Item.redstone
		);
		
		GameRegistry.addRecipe(new ItemStack(machines, 1, 1),
			"I|I",
			"G#G",
			"III",
			'#', Block.blockGold,
			'G', Item.ingotGold,
			'I', Item.ingotIron,
			'|', new ItemStack(tube, 1, 0)
		);
		
		GameRegistry.addRecipe(new ItemStack(machines, 8, 2),
			"I|I",
			"GDG",
			"I|I",
			'D', Item.diamond,
			'|', new ItemStack(tube, 1, 0),
			'I', Item.ingotIron,
			'G', Item.glowstone
		);
		
		GameRegistry.addShapelessRecipe(new ItemStack(machines, 1, 0),
			new ItemStack(machines, 1, 2),
			Item.redstone
		);
		
		GameRegistry.addShapelessRecipe(new ItemStack(machines, 1, 2),
			new ItemStack(machines, 1, 0),
			Item.glowstone
		);
	}
}
