package mods.immibis.infinitubes;

import net.minecraft.item.ItemStack;

public interface IDislocatable {

	int getDislocatorPriority();

	/**
	 * Returns true to stop searching.
	 * This will be called on all IDislocatables connected to a dislocator
	 * in priority order until one of them returns true.
	 * 
	 * @param matching The item to match.
	 * @param label The label to eject the item with.
	 * @param filter The filter
	 * @param amount Requested stack size, or 0 for none.
	 */
	boolean dislocate(ItemStack matching, String label, String filter, int amount, Operation op) throws Operation.DontCauseLagException;

}
