package mods.immibis.infinitubes;


import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

import mods.immibis.core.api.util.Dir;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class DislocatorTileBase extends MachineTileBase implements ISidedInventory {

	public DislocatorTileBase() {
		super(1, "dislocator");
	}
	
	@Override
	public List<ItemStack> getInventoryDrops() {
		setInventorySlotContents(0, null);
		return super.getInventoryDrops();
	}
	
	public byte facing = Dir.NZ;
	public String label = "", filter = "";
	public String[] cachedFilter = null;
	public boolean recursive = false;
	
	public boolean wasRedstoned;
	public int queuedPulses;
	public int cooldown;
	
	@Override
	public Packet getDescriptionPacket() {
		NBTTagCompound tag = new NBTTagCompound();
		tag.setString("L", label);
		tag.setString("F", filter);
		return new Packet132TileEntityData(xCoord, yCoord, zCoord, facing, tag);
	}
	
	@Override
	public void onDataPacket(Packet132TileEntityData packet) {
		label = packet.customParam1.getString("L");
		filter = packet.customParam1.getString("F");
		facing = (byte)packet.actionType;
		worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
	}
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		tag.setByte("facing", facing);
		tag.setBoolean("redstone", wasRedstoned);
		tag.setInteger("queue", queuedPulses);
		tag.setInteger("cooldown", cooldown);
		tag.setString("label", label);
		tag.setString("filter", filter);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		facing = tag.getByte("facing");
		wasRedstoned = tag.getBoolean("redstone");
		queuedPulses = tag.getInteger("queue");
		cooldown = tag.getInteger("cooldown");
		label = tag.getString("label");
		filter = tag.getString("filter");
	}
	
	@Override
	public void onBlockNeighbourChange() {
		super.onBlockNeighbourChange();
		
		boolean nowRedstoned = worldObj.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord);
		if(wasRedstoned != nowRedstoned) {
			wasRedstoned = nowRedstoned;
			
			if(nowRedstoned) {
				queuedPulses++;
			}
		}
	}
	
	@Override
	public void updateEntity() {
		super.updateEntity();
		
		if(worldObj.isRemote)
			return;
		
		if(cooldown > 0)
			cooldown--;
		else if(queuedPulses > 0) {
			queuedPulses--;
			cooldown = 10;
			
			suck(inv.contents[0] == null ? 0 : inv.contents[0].stackSize);
		}
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		if(!worldObj.isRemote)
			player.openGui(InfiniTubes.instance, InfiniTubes.GUI_DISLOCATOR, worldObj, xCoord, yCoord, zCoord);
		return true;
	}
	
	
	
	private static class ItemSource {
		IDislocatable source;
		ForgeDirection side;
		ItemSource(IDislocatable r, ForgeDirection s) {
			source = r;
			side = s;
		}
		@Override
		public int hashCode() {
			return source.hashCode() + side.ordinal();
		}
		@Override
		public boolean equals(Object obj) {
			try {
				ItemSource o = (ItemSource)obj;
				return source == o.source && side == o.side;
			} catch(ClassCastException e) {
				return false;
			}
		}
		@Override
		public String toString() {
			return source + ":" + side.ordinal();
		}
	}
	
	@Override
	public String toString() {
		return "[" + xCoord + "," + yCoord + "," + zCoord + "]";
	}
	
	private static final Comparator<ItemSource> PRIORITY_COMPARATOR = new Comparator<ItemSource>() {
		@Override
		public int compare(ItemSource a, ItemSource b) {
			int priorityDiff = b.source.getDislocatorPriority() - a.source.getDislocatorPriority();
			if(priorityDiff != 0)
				return priorityDiff;
			return a.hashCode() - b.hashCode();
		}
	};
	
	public boolean suck(int amount) {
		ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[facing];
		
		int x = xCoord + fd.offsetX, y = yCoord + fd.offsetY, z = zCoord + fd.offsetZ;
		if(worldObj.getBlockId(x, y, z) != InfiniTubes.tube.blockID)
			return false;
		
		WorldTubeMap.TubeNet net = WorldTubeMap.getForWorld(worldObj).getNet(x, y, z);
		
		SortedSet<ItemSource> sources = new TreeSet<ItemSource>(PRIORITY_COMPARATOR);
		for(Map.Entry<WorldTubeMap.XYZ, ForgeDirection> e : net.machineSides.entries()) {
			WorldTubeMap.XYZ xyz = e.getKey();
			if(worldObj.blockExists(xyz.x, xyz.y, xyz.z)) {
				TileEntity te = worldObj.getBlockTileEntity(xyz.x, xyz.y, xyz.z);
				if(te instanceof IDislocatable) {
					ItemSource target = new ItemSource((IDislocatable)te, e.getValue());
					sources.add(target);
				}
			}
		}
		if(cachedFilter == null)
			cachedFilter = filter.split(",");
		try {
			Operation op = new Operation();
			for(String filterPart : cachedFilter) {
				for(ItemSource source : sources) {
					if(source.source.dislocate(inv.contents[0], label, filterPart, amount, op))
						return true;
				}
			}
		} catch(Operation.DontCauseLagException e) {
			explodeFromLag();
		}
		return false;
		
	}
	
	@Override
	public boolean connectsOnSide(int i) {
		return i == facing;
	}
	
	@Override
	public void onPlaced(EntityLivingBase player, int look) {
		facing = (byte)(look ^ 1);
	}

	
	private static int[] emptyIntArray = new int[0];
	@Override
	public int[] getAccessibleSlotsFromSide(int var1) {
		return emptyIntArray;
	}

	@Override
	public boolean canInsertItem(int i, ItemStack itemstack, int j) {
		return false;
	}

	@Override
	public boolean canExtractItem(int i, ItemStack itemstack, int j) {
		return false;
	}

}
