package immibis.ccperiphs.rfid;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import immibis.ccperiphs.TilePeriphs;
import immibis.ccperiphs.mod_ImmibisPeripherals;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityMinecart;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;

public class TileRFIDReader extends TilePeriphs implements IPeripheral
{
    public static final double RADIUS = 5.0D;
    public static final double MIN_RADIUS = 1.0D;
    public static final int TICKS_PER_SCAN = 20;
    private int ticksRemaining = 0;
    private int scanTicks = 0;
    private double scanRadius;
    private IComputerAccess scanningComputer = null;
    private static String[] methodNames = new String[] {"scan", "getProgress", "isScanning"};

    private void doScan(IComputerAccess var1, IInventory var2)
    {
        int var3 = var2.getSize();

        for (int var4 = 0; var4 < var3; ++var4)
        {
            ItemStack var5 = var2.getItem(var4);

            if (var5 != null && var5.id == mod_ImmibisPeripherals.itemRFID.id && var5.tag != null && var5.tag.hasKey("data"))
            {
                var1.queueEvent("rfid_detected", new Object[] {var5.tag.getString("data")});
            }
        }
    }

    private void doScan(IComputerAccess var1)
    {
        AxisAlignedBB var2 = AxisAlignedBB.b((double)this.x + 0.5D - this.scanRadius, (double)this.y + 0.5D - this.scanRadius, (double)this.z + 0.5D - this.scanRadius, (double)this.x + 0.5D + this.scanRadius, (double)this.y + 0.5D + this.scanRadius, (double)this.z + 0.5D + this.scanRadius);
        List var3 = this.world.a(EntityHuman.class, var2);
        var3.addAll(this.world.a(EntityMinecart.class, var2));
        double var4 = this.scanRadius * this.scanRadius;
        Iterator var6 = var3.iterator();

        while (var6.hasNext())
        {
            Entity var7 = (Entity)var6.next();

            if (var7.e((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= var4)
            {
                if (var7 instanceof EntityHuman)
                {
                    this.doScan(var1, ((EntityHuman)var7).inventory);
                }
                else if (var7 instanceof IInventory)
                {
                    this.doScan(var1, (IInventory)var7);
                }
            }
        }

        var1.queueEvent("rfid_scan_done");
    }

    public String getType()
    {
        return "rfid reader";
    }

    public String[] getMethodNames()
    {
        return methodNames;
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (this.ticksRemaining > 0)
        {
            --this.ticksRemaining;

            if (this.ticksRemaining == 0 && this.scanningComputer != null)
            {
                this.doScan(this.scanningComputer);
                this.scanningComputer = null;
            }
        }
    }

    public Object[] callMethod(IComputerAccess var1, int var2, Object[] var3) throws Exception
    {
        switch (var2)
        {
            case 0:
                if (this.ticksRemaining > 0)
                {
                    return new Object[] {Boolean.valueOf(false), "Already scanning"};
                }
                else
                {
                    if (var3.length != 0 && var3[0] instanceof Number)
                    {
                        this.scanRadius = ((Number)var3[0]).doubleValue();

                        if (this.scanRadius < 1.0D)
                        {
                            return new Object[] {Boolean.valueOf(false), "Radius too low, minimum is 1.0"};
                        }

                        if (this.scanRadius > 5.0D)
                        {
                            return new Object[] {Boolean.valueOf(false), "Radius too high, maximum is 5.0"};
                        }

                        this.scanTicks = (int)(20.0D * this.scanRadius / 5.0D);
                    }
                    else
                    {
                        this.scanRadius = 5.0D;
                        this.scanTicks = 20;
                    }

                    this.ticksRemaining = this.scanTicks;
                    this.scanningComputer = var1;
                    return new Object[] {Boolean.valueOf(true)};
                }

            case 1:
                if (this.ticksRemaining == 0)
                {
                    return new Object[] {Integer.valueOf(-1)};
                }

                return new Object[] {Double.valueOf(1.0D - (double)this.ticksRemaining / (double)this.scanTicks)};

            case 2:
                return new Object[] {Boolean.valueOf(this.ticksRemaining > 0)};
            default:
                return new Object[0];
        }
    }

    public boolean canAttachToSide(int var1)
    {
        return true;
    }

    public void attach(IComputerAccess var1, String var2) {}

    public void detach(IComputerAccess var1)
    {
        if (var1 == this.scanningComputer)
        {
            this.scanningComputer = null;
            this.ticksRemaining = 0;
        }
    }
}
