package immibis.microblocks;

import java.util.EnumSet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiErrorScreen;

import immibis.core.api.FMLModInfo;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.FMLRelauncher;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;

// metadata required for AutoPublisher
@Mod(version=MicroblockSystem.MOD_VERSION, modid="ImmibisMicroblocksInstalledIncorrectly", name="Immibis's Microblocks (INSTALLED INCORRECTLY)")
@FMLModInfo(
		url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
		description="",
		authors="immibis"
		)
public class MicroblocksNonCoreMod {
	
	@Init
	public void init(FMLInitializationEvent evt) {
		// it's ok to install as a coremod and non-coremod at the same time, for MCP
		if(MicroblockSystem.INSTANCE != null)
			return;
		
		if(FMLRelauncher.side().equals("SERVER")) {
			throw new RuntimeException("Immibis's Microblocks is installed incorrectly - it must go in your COREMODS folder.");
		}
		
		TickRegistry.registerTickHandler(new ITickHandler() {
			
			@Override
			public EnumSet<TickType> ticks() {
				return EnumSet.of(TickType.CLIENT);
			}
			
			@Override
			public void tickStart(EnumSet<TickType> type, Object... tickData) {
				if(!(Minecraft.getMinecraft().currentScreen instanceof GuiErrorScreen)) {
					GuiErrorScreen ges = new GuiErrorScreen();
					ReflectionHelper.setPrivateValue(GuiErrorScreen.class, ges, "Immibis's Microblocks must be installed in the coremods folder.", 0);
					ReflectionHelper.setPrivateValue(GuiErrorScreen.class, ges, "Please correct the problem and restart Minecraft.", 1);
					Minecraft.getMinecraft().displayGuiScreen(ges);
				}
			}
			
			@Override
			public void tickEnd(EnumSet<TickType> type, Object... tickData) {
				
			}
			
			@Override
			public String getLabel() {
				return "asdf";
			}
		}, Side.CLIENT);
	}
}
