package immibis.core.covers;

import immibis.core.api.Dir;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import net.minecraft.src.*;

public class CoverImpl {
	
	LinkedList<Part> parts = new LinkedList<Part>();
	public BlockCoverableBase wrappedBlock;
	public double hollow_edge_size;
	
	public TileEntity te;
	
	public CoverImpl(TileEntity te, double hes) {
		this.te = te;
		hollow_edge_size = hes;
	}
	
	public CoverImpl(TileEntity te) {
		this(te, 0.25);
	}
	
	void harvestBlock(World world, EntityPlayer ply, int x, int y, int z, int subHit) {
		ply.addExhaustion(0.025F);
		TileEntity te = world.getBlockTileEntity(x, y, z);
		if(te == null || !(te instanceof ICoverableTile))
			return;
		
		if(subHit == -2)
		{
			if(wrappedBlock != null)
			{
				wrappedBlock.harvestBlockMultipart(world, ply, x, y, z, world.getBlockMetadata(x, y, z));
				((TileCoverableBase)te).convertToMultipartBlockInPlace();
			}
			return;
		}
		else if(subHit < 0)
			return;
		
		CoverImpl cover = ((ICoverableTile)te).getCoverImpl();
		
		if(subHit >= cover.parts.size())
			return;
		
		Part p = cover.parts.get(subHit);
		if(p == null)
			return;
		
		CoverSystemProxy.blockMultipart.dropBlockAsItem_do(world, x, y, z, new ItemStack(CoverSystemProxy.blockMultipart.blockID, 1, p.type.id));
		
		cover.parts.remove(subHit);
		if(cover.parts.size() == 0 && wrappedBlock == null)
			world.setBlock(x, y, z, 0);
		world.markBlockNeedsUpdate(x, y, z);
	}
	
	

	public void writeToNBT(NBTTagCompound tag) {
		NBTTagList l = new NBTTagList();
		for(Part p : parts)
			l.appendTag(p.writeToNBT());
		tag.setTag("Covers", l);
	}
	
	public void readFromNBT(NBTTagCompound tag) {
		parts.clear();
		NBTTagList l = tag.getTagList("Covers");
		if(l == null)
			return;
		for(int k = 0; k < l.tagCount(); k++)
			parts.add(Part.readFromNBT(l.tagAt(k)));
	}

	/* $if mc < 1.3$
	public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3D src, Vec3D dst) {
	$else$ */
	public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 src, Vec3 dst) {
	/* $endif$ */
		int k = 0;
		src = src.addVector(-x, -y, -z);
		dst = dst.addVector(-x, -y, -z);
		double best = dst.squareDistanceTo(src) + 1;
		Part hit = null;
		MovingObjectPosition hitInfo = null;
		int subHit = -1;
		for(Part p : parts)
		{
			AxisAlignedBB aabb = p.getBoundingBox();
			MovingObjectPosition rt = aabb.calculateIntercept(src, dst);
			if(rt != null)
			{
				double rtdist = rt.hitVec.squareDistanceTo(src);
				if(rtdist < best)
				{
					hitInfo = rt;
					best = rtdist;
					hit = p;
					subHit = k;
				}
			}
			++k;
		}
		
		if(hit == null)
			return null;
		
		AxisAlignedBB aabb = hit.aabb;
		int side = 0;
		/* $if mc < 1.3$
		Vec3D hitVec = hitInfo.hitVec;
		$else$ */
		Vec3 hitVec = hitInfo.hitVec;
		/* $endif$ */
		if(hitVec.xCoord <= aabb.minX)
			side = Dir.NX;
		else if(hitVec.xCoord >= aabb.maxX)
			side = Dir.PX;
		else if(hitVec.yCoord <= aabb.minY)
			side = Dir.NY;
		else if(hitVec.yCoord >= aabb.maxY)
			side = Dir.PY;
		else if(hitVec.zCoord <= aabb.minZ)
			side = Dir.NZ;
		else if(hitVec.zCoord >= aabb.maxZ)
			side = Dir.PZ;
		
		MovingObjectPosition pos = new MovingObjectPosition(x, y, z, side, hitVec.addVector(x, y, z));
		pos.subHit = subHit;
		return pos;
	}

	public boolean addPart(Part part) {
		if(!canPlace(part.type, part.pos))
			return false;
		parts.add(part);
		return true;
	}
	
	public boolean canPlaceCentre(double size) {
		AxisAlignedBB aabb = Part.getBoundingBox(EnumPosition.Centre, size);
		for(Part p : parts)
		{
			if(p.getBoundingBox().intersectsWith(aabb))
				return false;
		}
		return true;
	}

	public boolean canPlace(PartType type, EnumPosition pos) {
		for(Part p : parts)
		{
			if(p.pos == pos)
				return false;
			if(p.pos.clazz == pos.clazz)
				continue;
			if(p.getBoundingBox().intersectsWith(Part.getBoundingBox(pos, type.size)))
				return false;
		}
		return true;
	}

	public void getCollidingBoundingBoxes(World world, int x, int y, int z, AxisAlignedBB mask, List list) {
		for(Part p : parts)
			list.add(p.getBoundingBox().getOffsetBoundingBox(x, y, z));
	}

	public boolean isSideOpen(int side) {
		AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
		switch(side)
		{
		case Dir.NX: aabb.minX = 0; break;
		case Dir.PX: aabb.maxX = 1; break;
		case Dir.NY: aabb.minY = 0; break;
		case Dir.PY: aabb.maxY = 1; break;
		case Dir.NZ: aabb.minZ = 0; break;
		case Dir.PZ: aabb.maxZ = 1; break;
		}
		for(Part p : parts)
			if(p.type.clazz != EnumPartClass.HollowPanel && p.pos != EnumPosition.Centre && p.getBoundingBox().intersectsWith(aabb))
				return false;
		return true;
	}

	public boolean isSideOpen(int myx, int myy, int myz, int x, int y, int z) {
		AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
		if(x < myx) aabb.minX = 0;
		if(x > myx) aabb.maxX = 1;
		if(y < myy) aabb.minY = 0;
		if(y > myy) aabb.maxY = 1;
		if(z < myz) aabb.minZ = 0;
		if(z > myz) aabb.maxZ = 1;
		for(Part p : parts)
			if(p.type.clazz != EnumPartClass.HollowPanel && p.pos != EnumPosition.Centre && p.getBoundingBox().intersectsWith(aabb))
				return false;
		return true;
	}

	public void writeDescriptionPacket(DataOutputStream data) throws IOException {
		data.writeShort(wrappedBlock == null ? 0 : wrappedBlock.blockID);
		data.writeShort(parts.size());
		//data.writeInt(te.xCoord);
		//data.writeInt(te.yCoord);
		//data.writeInt(te.zCoord);
		for(Part pt : parts) {
			data.writeByte(pt.pos.ordinal());
			data.writeShort(pt.type.id);
		}
	}
	
	public void readDescriptionPacket(DataInputStream data) throws IOException {
		int wrappedID = data.readShort();
		wrappedBlock = (wrappedID == 0 ? null : (BlockCoverableBase)Block.blocksList[wrappedID]);
		int ncovers = data.readShort();
		//int x = data.readInt();
		//int y = data.readInt();
		//int z = data.readInt();
		//if(x != te.xCoord || y != te.yCoord || z != te.zCoord)
		//	throw new IOException("Coordinates don't match");
		parts.clear();
		for(int k = 0; k < ncovers; k++)
		{
			EnumPosition pos = EnumPosition.values()[data.readByte()];
			int type = data.readShort() & 65535;
			parts.add(new Part(CoverSystemProxy.parts.get(type), pos));
		}
	}
	/* $endif$ */

	public void copyPartsTo(CoverImpl other) {
		for(Part p : parts)
			other.addPart(p);
	}

	public Packet getDefaultDescriptionPacket() {
		try {
			ByteArrayOutputStream bytes = new ByteArrayOutputStream();
			DataOutputStream data = new DataOutputStream(bytes);
			data.writeInt(te.xCoord);
			data.writeInt(te.yCoord);
			data.writeInt(te.zCoord);
			writeDescriptionPacket(data);
			Packet250CustomPayload p = new Packet250CustomPayload();
			p.channel = "ImmibisCoreCDP";
			p.data = bytes.toByteArray();
			p.length = p.data.length;
			return p;
		} catch(IOException e) {
			e.printStackTrace();
			return null;
		}
	}
}