package immibis.core.covers;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.src.*;

public abstract class BlockCoverableBase extends BlockMultipart {

	static boolean useRealRenderType = false;

	protected BlockCoverableBase(int i, Material material) {
		super(i, material, CoverSystemProxy.coverModel);
	}
	
	public int getRenderTypeMultipart() {
		return 0;
	}
	
	/* $if mc < 1.3$
	public MovingObjectPosition collisionRayTraceMultipart(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
	$else$ */
	public MovingObjectPosition collisionRayTraceMultipart(World world, int i, int j, int k, Vec3 vec3d, Vec3 vec3d1) {
	/* $endif$ */
		return defaultCollisionRayTrace(world, i, j, k, vec3d, vec3d1);
	}
	
	@Override
	/* $if mc < 1.3$
	public final MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3D src, Vec3D dst) {
	$else$ */
	public final MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 src, Vec3 dst) {
	/* $endif$ */
		MovingObjectPosition pos = super.collisionRayTrace(world, x, y, z, src, dst);
		if(pos != null)
			return pos;
		
		pos = collisionRayTraceMultipart(world, x, y, z, src, dst);
		if(pos != null)
		{
			pos.subHit = -2;
			return pos;
		}
		
		return null;
	}
	
	@Override
	public final int getRenderType() {
		return useRealRenderType ? getRenderTypeMultipart() : super.getRenderType();
	}
	
	@Override
	/* $if mc < 1.3$
	public final void getCollidingBoundingBoxes(World world, int x, int y, int z, AxisAlignedBB mask, ArrayList list) {
		super.getCollidingBoundingBoxes(world, x, y, z, mask, list);
	$else$ */
	public final void addCollidingBlockToList(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity par7) {
		super.addCollidingBlockToList(world, x, y, z, mask, list, par7);
	/* $endif$ */
		getCollidingBoundingBoxesMultipart(world, x, y, z, mask, list);
	}
	
	public void getCollidingBoundingBoxesMultipart(World world, int i, int j, int k, AxisAlignedBB mask, List arraylist) {
		AxisAlignedBB axisalignedbb1 = getCollisionBoundingBoxFromPool(world, i, j, k);
        if (axisalignedbb1 != null && axisalignedbb1.intersectsWith(mask))
        {
            arraylist.add(axisalignedbb1);
        }
	}
}
