package immibis.core.covers;

import immibis.core.api.Dir;
import immibis.core.covers.CoverImpl;
import immibis.core.covers.CoverSystemProxy;
import immibis.core.covers.EnumAxisPosition;
import immibis.core.covers.EnumPartClass;
import immibis.core.covers.EnumPosition;
import immibis.core.covers.ICoverableBlock;
import immibis.core.covers.ICoverableTile;
import immibis.core.covers.Part;
import immibis.core.covers.PartType;
import immibis.core.covers.TileCoverableBase;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.input.Keyboard;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumMovingObjectType;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TileEntity;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.forge.IHighlightHandler;

public class MultipartHighlightHandler implements IHighlightHandler {

	static final double SELECTOR_OUTER_SIZE = 0.25;
	//static final double SELECTOR_INNER_SIZE = (1 - SELECTOR_OUTER_SIZE*2);
	static final double SELECTOR_STRIP_OUTER_SIZE = 0.4;
	
	@Override
	public boolean onBlockHighlight(RenderGlobal rg,
			EntityPlayer ply,
			MovingObjectPosition pos, int pass,
			ItemStack holding, float f) {

		if(pos.typeOfHit != EnumMovingObjectType.TILE)
			return false;
		
		if(pass != 0)
			return true;
		
		boolean override = false;
		
		TileEntity te = ply.worldObj.getBlockTileEntity(pos.blockX, pos.blockY, pos.blockZ);
		Part hitPart = null;
		boolean isFakeCentre = false;
		if(te != null && (te instanceof ICoverableTile))
		{
			if(pos.subHit < 0)
			{
				if(te instanceof TileCoverableBase)
				{
					TileCoverableBase tcb = (TileCoverableBase)te;
					hitPart = tcb.getFakeCentrePart();
					isFakeCentre = true;
				}
			}
			else
			{
				CoverImpl cover = ((ICoverableTile)te).getCoverImpl();
				hitPart = cover.parts.get(pos.subHit);
			}
		}
		if(holding != null && holding.itemID == CoverSystemProxy.blockMultipart.blockID)
		{
			PartType type = CoverSystemProxy.parts.get(holding.getItemDamage());
			if(type != null)
			{
				World world = ply.worldObj;
				boolean ok = false;
				int x = pos.blockX;
				int y = pos.blockY;
				int z = pos.blockZ;
				int dx = 0, dy = 0, dz = 0;
				switch(pos.sideHit)
				{
				case Dir.NX: if(hitPart == null || hitPart.pos.x.touchesNegative()) dx = -1; break;
				case Dir.PX: if(hitPart == null || hitPart.pos.x.touchesPositive()) dx = 1; break;
				case Dir.NY: if(hitPart == null || hitPart.pos.y.touchesNegative()) dy = -1; break;
				case Dir.PY: if(hitPart == null || hitPart.pos.y.touchesPositive()) dy = 1; break;
				case Dir.NZ: if(hitPart == null || hitPart.pos.z.touchesNegative()) dz = -1; break;
				case Dir.PZ: if(hitPart == null || hitPart.pos.z.touchesPositive()) dz = 1; break;
				}
				ok = canPlaceInBlock(world, x+dx, y+dy, z+dz);
				TileEntity tePlacingIn = world.getBlockTileEntity(x+dx, y+dy, z+dz);
				if(ok)
				{
					GL11.glDisable(GL11.GL_TEXTURE_2D);
					GL11.glDepthMask(false);
					GL11.glColor4f(0.0f, 0.0f, 0.0f, 0.4f);
					GL11.glPushMatrix();
					GL11.glTranslated(
							pos.blockX-ply.lastTickPosX-(ply.posX-ply.lastTickPosX)*f-0.5,
							pos.blockY-ply.lastTickPosY-(ply.posY-ply.lastTickPosY)*f-0.5,
							pos.blockZ-ply.lastTickPosZ-(ply.posZ-ply.lastTickPosZ)*f-0.5
						);
					GL11.glScalef(1.002f, 1.002f, 1.002f);
					GL11.glTranslated(0.5, 0.5, 0.5);
					
					EnumPosition placement = null;
					
					if(type.clazz == EnumPartClass.Panel || type.clazz == EnumPartClass.HollowPanel)
					{
						renderEdgeSelector(pos, ply, SELECTOR_OUTER_SIZE);
						placement = getPanelPlacement(ply, pos, hitPart == null || dx != 0 || dy != 0 || dz != 0 ? null : hitPart.pos);
					}
					else if(type.clazz == EnumPartClass.Strip)
					{
						renderEdgeSelector(pos, ply, SELECTOR_STRIP_OUTER_SIZE);
						placement = getStripPlacement(ply, pos, hitPart == null || dx != 0 || dy != 0 || dz != 0 ? null : hitPart.pos);
					}
					else if(type.clazz == EnumPartClass.Corner)
					{
						renderCornerSelector(pos, ply);
						placement = getCornerPlacement(ply, pos, hitPart == null || dx != 0 || dy != 0 || dz != 0 ? null : hitPart.pos);
					}
					
					GL11.glTranslatef(dx, dy, dz);
					GL11.glEnable(GL11.GL_TEXTURE_2D);
					
					if(placement != null && (tePlacingIn == null || (tePlacingIn instanceof ICoverableTile && ((ICoverableTile)tePlacingIn).getCoverImpl().canPlace(type, placement))))
						CoversNonSharedProxy.renderPartPreview(rg, placement, type);
					
					GL11.glPopMatrix();
					GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
					GL11.glDepthMask(true);
				}
			}
		}
		if(hitPart != null && !isFakeCentre)
		{
			BlockMultipart.selectedBoundingBox = hitPart.aabb;
			rg.drawSelectionBox(ply, pos, 0, holding, f);
			drawBlockBreaking(rg, ply, pos, 0, holding, f, hitPart.aabb);
			override = true;
		}
		
		return override;
	}
	
	static void drawBlockBreaking(RenderGlobal rg, EntityPlayer ply, MovingObjectPosition pos, int pass, ItemStack holding, float f, AxisAlignedBB aabb)
	{
		Tessellator tessellator = Tessellator.instance;
        GL11.glEnable(GL11.GL_BLEND);
        if (rg.damagePartialTime > 0.0F)
        {
            GL11.glBlendFunc(774, 768);
            int j = rg.renderEngine.getTexture("/terrain.png");
            GL11.glBindTexture(3553 /*GL_TEXTURE_2D*/, j);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 0.5F);
            GL11.glPushMatrix();
            GL11.glPolygonOffset(-3F, -3F);
            GL11.glEnable(32823 /*GL_POLYGON_OFFSET_FILL*/);
            double d = ply.lastTickPosX + (ply.posX - ply.lastTickPosX) * (double)f;
            double d1 = ply.lastTickPosY + (ply.posY - ply.lastTickPosY) * (double)f;
            double d2 = ply.lastTickPosZ + (ply.posZ - ply.lastTickPosZ) * (double)f;
            GL11.glEnable(3008 /*GL_ALPHA_TEST*/);
            tessellator.startDrawingQuads();
            tessellator.setTranslation(pos.blockX-d, pos.blockY-d1, pos.blockZ-d2);
            tessellator.disableColor();
            int tex = 240 + (int)(rg.damagePartialTime * 10F);
            CoversNonSharedProxy.renderAABB(tessellator, aabb, new int[] {tex, tex, tex, tex, tex, tex});
            tessellator.draw();
            tessellator.setTranslation(0.0D, 0.0D, 0.0D);
            GL11.glDisable(3008 /*GL_ALPHA_TEST*/);
            GL11.glPolygonOffset(0.0F, 0.0F);
            GL11.glDisable(32823 /*GL_POLYGON_OFFSET_FILL*/);
            GL11.glPopMatrix();
        }
        GL11.glDisable(GL11.GL_BLEND);
	}
	
	
	static EnumPosition getPanelPlacement(EntityPlayer ply, MovingObjectPosition pos, EnumPosition placingOn) {
		Vec3D hv = pos.hitVec.addVector(-pos.blockX, -pos.blockY, -pos.blockZ);
		double x = hv.xCoord - 0.5;
		double y = hv.yCoord - 0.5;
		double z = hv.zCoord - 0.5;
		final double BORDER = 0.5 - SELECTOR_OUTER_SIZE;
		EnumPosition result = null;
		switch(pos.sideHit)
		{
		case Dir.NX:
		case Dir.PX:
			if(y >= -BORDER && y <= BORDER && z >= -BORDER && z <= BORDER)
				result = (pos.sideHit == Dir.NX ? EnumPosition.CoverPX : EnumPosition.CoverNX);
			else if(Math.abs(y) < Math.abs(z))
				result = (z < 0 ? EnumPosition.CoverNZ : EnumPosition.CoverPZ);
			else
				result = (y < 0 ? EnumPosition.CoverNY : EnumPosition.CoverPY);
			break;
		case Dir.NY:
		case Dir.PY:
			if(x >= -BORDER && x <= BORDER && z >= -BORDER && z <= BORDER)
				result = (pos.sideHit == Dir.NY ? EnumPosition.CoverPY : EnumPosition.CoverNY);
			else if(Math.abs(z) < Math.abs(x))
				result = (x < 0 ? EnumPosition.CoverNX : EnumPosition.CoverPX);
			else
				result = (z < 0 ? EnumPosition.CoverNZ : EnumPosition.CoverPZ);
			break;
		case Dir.NZ:
		case Dir.PZ:
			if(x >= -BORDER && x <= BORDER && y >= -BORDER && y <= BORDER)
				result = (pos.sideHit == Dir.NZ ? EnumPosition.CoverPZ : EnumPosition.CoverNZ);
			else if(Math.abs(x) < Math.abs(y))
				result = (y < 0 ? EnumPosition.CoverNY : EnumPosition.CoverPY);
			else
				result = (x < 0 ? EnumPosition.CoverNX : EnumPosition.CoverPX);
			break;
		}
		if(placingOn != null)
		{
			switch(result)
			{
			case CoverNX: if(pos.sideHit == Dir.PX && (placingOn.x == EnumAxisPosition.Negative || placingOn.x == EnumAxisPosition.Centre)) result = EnumPosition.CoverPX; break;
			case CoverNY: if(pos.sideHit == Dir.PY && (placingOn.y == EnumAxisPosition.Negative || placingOn.y == EnumAxisPosition.Centre)) result = EnumPosition.CoverPY; break;
			case CoverNZ: if(pos.sideHit == Dir.PZ && (placingOn.z == EnumAxisPosition.Negative || placingOn.z == EnumAxisPosition.Centre)) result = EnumPosition.CoverPZ; break;
			case CoverPX: if(pos.sideHit == Dir.NX && (placingOn.x == EnumAxisPosition.Positive || placingOn.x == EnumAxisPosition.Centre)) result = EnumPosition.CoverNX; break;
			case CoverPY: if(pos.sideHit == Dir.NY && (placingOn.y == EnumAxisPosition.Positive || placingOn.y == EnumAxisPosition.Centre)) result = EnumPosition.CoverNY; break;
			case CoverPZ: if(pos.sideHit == Dir.NZ && (placingOn.z == EnumAxisPosition.Positive || placingOn.z == EnumAxisPosition.Centre)) result = EnumPosition.CoverNZ; break;
			}
		}
		return result;
	}
	
	static EnumPosition getStripPlacement(EntityPlayer ply, MovingObjectPosition pos, EnumPosition placingOn) {
		Vec3D hv = pos.hitVec.addVector(-pos.blockX, -pos.blockY, -pos.blockZ);
		double x = hv.xCoord - 0.5;
		double y = hv.yCoord - 0.5;
		double z = hv.zCoord - 0.5;
		final double BORDER = 0.5 - SELECTOR_STRIP_OUTER_SIZE;
		EnumPosition result = EnumPosition.EdgePXPY;
		int sideHit = pos.sideHit;
		if(placingOn != null)
		{
			/*switch(sideHit)
			{
			case Side.NX: if(placingOn.x.touchesNegative()) sideHit ^= 1; break;
			case Side.PX: if(placingOn.x.touchesPositive()) sideHit ^= 1; break;
			case Side.NY: if(placingOn.y.touchesNegative()) sideHit ^= 1; break;
			case Side.PY: if(placingOn.y.touchesPositive()) sideHit ^= 1; break;
			case Side.NZ: if(placingOn.z.touchesNegative()) sideHit ^= 1; break;
			case Side.PZ: if(placingOn.z.touchesPositive()) sideHit ^= 1; break;
			}*/
			sideHit ^= 1;
		}
		switch(sideHit)
		{
		case Dir.PX:
			if(y >= -BORDER && y <= BORDER && z >= -BORDER && z <= BORDER)
				result = EnumPosition.PostX;
			else if(Math.abs(y) < Math.abs(z))
				result = (z < 0 ? EnumPosition.EdgeNXNZ : EnumPosition.EdgeNXPZ);
			else
				result = (y < 0 ? EnumPosition.EdgeNXNY : EnumPosition.EdgeNXPY);
			break;
		case Dir.NX:
			if(y >= -BORDER && y <= BORDER && z >= -BORDER && z <= BORDER)
				result = EnumPosition.PostX;
			else if(Math.abs(y) < Math.abs(z))
				result = (z < 0 ? EnumPosition.EdgePXNZ : EnumPosition.EdgePXPZ);
			else
				result = (y < 0 ? EnumPosition.EdgePXNY : EnumPosition.EdgePXPY);
			break;
		case Dir.PY:
			if(x >= -BORDER && x <= BORDER && z >= -BORDER && z <= BORDER)
				result = EnumPosition.PostY;
			else if(Math.abs(x) < Math.abs(z))
				result = (z < 0 ? EnumPosition.EdgeNYNZ : EnumPosition.EdgeNYPZ);
			else
				result = (x < 0 ? EnumPosition.EdgeNXNY : EnumPosition.EdgePXNY);
			break;
		case Dir.NY:
			if(x >= -BORDER && x <= BORDER && z >= -BORDER && z <= BORDER)
				result = EnumPosition.PostY;
			else if(Math.abs(x) < Math.abs(z))
				result = (z < 0 ? EnumPosition.EdgePYNZ : EnumPosition.EdgePYPZ);
			else
				result = (x < 0 ? EnumPosition.EdgeNXPY : EnumPosition.EdgePXPY);
			break;
		case Dir.PZ:
			if(x >= -BORDER && x <= BORDER && y >= -BORDER && y <= BORDER)
				result = EnumPosition.PostZ;
			else if(Math.abs(x) < Math.abs(y))
				result = (y < 0 ? EnumPosition.EdgeNYNZ : EnumPosition.EdgePYNZ);
			else
				result = (x < 0 ? EnumPosition.EdgeNXNZ : EnumPosition.EdgePXNZ);
			break;
		case Dir.NZ:
			if(x >= -BORDER && x <= BORDER && y >= -BORDER && y <= BORDER)
				result = EnumPosition.PostZ;
			else if(Math.abs(x) < Math.abs(y))
				result = (y < 0 ? EnumPosition.EdgeNYPZ : EnumPosition.EdgePYPZ);
			else
				result = (x < 0 ? EnumPosition.EdgeNXPZ : EnumPosition.EdgePXPZ);
			break;
		}
		return result;
	}
	
	static EnumPosition getCornerPlacement(EntityPlayer ply, MovingObjectPosition pos, EnumPosition placingOn) {
		Vec3D hv = pos.hitVec.addVector(-pos.blockX, -pos.blockY, -pos.blockZ);
		double x = hv.xCoord - 0.5;
		double y = hv.yCoord - 0.5;
		double z = hv.zCoord - 0.5;
		final double BORDER = 0.5 - SELECTOR_OUTER_SIZE;
		EnumPosition result = EnumPosition.CornerPXPYPZ;
		switch(pos.sideHit)
		{
		case Dir.NX:
			result = EnumPosition.getCornerPos((placingOn == null || placingOn.x != EnumAxisPosition.Positive ? 1 : -1), (y < 0 ? -1 : 1), (z < 0 ? -1 : 1));
			break;
		case Dir.PX:
			result = EnumPosition.getCornerPos((placingOn == null || placingOn.x != EnumAxisPosition.Negative ? -1 : 1), (y < 0 ? -1 : 1), (z < 0 ? -1 : 1));
			break;
		case Dir.NY:
			result = EnumPosition.getCornerPos((x < 0 ? -1 : 1), (placingOn == null || placingOn.y != EnumAxisPosition.Positive ? 1 : -1), (z < 0 ? -1 : 1));
			break;
		case Dir.PY:
			result = EnumPosition.getCornerPos((x < 0 ? -1 : 1), (placingOn == null || placingOn.y != EnumAxisPosition.Negative ? -1 : 1), (z < 0 ? -1 : 1));
			break;
		case Dir.NZ:
			result = EnumPosition.getCornerPos((x < 0 ? -1 : 1), (y < 0 ? -1 : 1), (placingOn == null || placingOn.z != EnumAxisPosition.Positive ? 1 : -1));
			break;
		case Dir.PZ:
			result = EnumPosition.getCornerPos((x < 0 ? -1 : 1), (y < 0 ? -1 : 1), (placingOn == null || placingOn.z != EnumAxisPosition.Negative ? -1 : 1));
			break;
		}
		return result;
	}
	
	private static void renderEdgeSelector(MovingObjectPosition pos, EntityPlayer ply, double outer_size)
	{
		Tessellator t = Tessellator.instance;
		GL11.glLineWidth(4);
		t.startDrawing(GL11.GL_LINES);
		switch(pos.sideHit)
		{
		case Dir.NX:
		case Dir.PX:
			int x = (pos.sideHit == Dir.NX ? 0 : 1);
			t.addVertex(x, 0, 0);
			t.addVertex(x, 0, 1);
			t.addVertex(x, 0, 1);
			t.addVertex(x, 1, 1);
			t.addVertex(x, 1, 1);
			t.addVertex(x, 1, 0);
			t.addVertex(x, 1, 0);
			t.addVertex(x, 0, 0);
			
			t.addVertex(x, outer_size, outer_size);
			t.addVertex(x, outer_size, 1-outer_size);
			t.addVertex(x, outer_size, 1-outer_size);
			t.addVertex(x, 1-outer_size, 1-outer_size);
			t.addVertex(x, 1-outer_size, 1-outer_size);
			t.addVertex(x, 1-outer_size, outer_size);
			t.addVertex(x, 1-outer_size, outer_size);
			t.addVertex(x, outer_size, outer_size);
			
			t.addVertex(x, 0, 0);
			t.addVertex(x, outer_size, outer_size);
			t.addVertex(x, 1, 0);
			t.addVertex(x, 1-outer_size, outer_size);
			t.addVertex(x, 1, 1);
			t.addVertex(x, 1-outer_size, 1-outer_size);
			t.addVertex(x, 0, 1);
			t.addVertex(x, outer_size, 1-outer_size);
			break;
		case Dir.NY:
		case Dir.PY:
			int y = (pos.sideHit == Dir.NY ? 0 : 1);
			t.addVertex(0, y, 0);
			t.addVertex(0, y, 1);
			t.addVertex(0, y, 1);
			t.addVertex(1, y, 1);
			t.addVertex(1, y, 1);
			t.addVertex(1, y, 0);
			t.addVertex(1, y, 0);
			t.addVertex(0, y, 0);
			
			t.addVertex(outer_size, y, outer_size);
			t.addVertex(outer_size, y, 1-outer_size);
			t.addVertex(outer_size, y, 1-outer_size);
			t.addVertex(1-outer_size, y, 1-outer_size);
			t.addVertex(1-outer_size, y, 1-outer_size);
			t.addVertex(1-outer_size, y, outer_size);
			t.addVertex(1-outer_size, y, outer_size);
			t.addVertex(outer_size, y, outer_size);
			
			t.addVertex(0, y, 0);
			t.addVertex(outer_size, y, outer_size);
			t.addVertex(1, y, 0);
			t.addVertex(1-outer_size, y, outer_size);
			t.addVertex(1, y, 1);
			t.addVertex(1-outer_size, y, 1-outer_size);
			t.addVertex(0, y, 1);
			t.addVertex(outer_size, y, 1-outer_size);
			break;
		case Dir.NZ:
		case Dir.PZ:
			int z = (pos.sideHit == Dir.NZ ? 0 : 1);
			t.addVertex(0, 0, z);
			t.addVertex(0, 1, z);
			t.addVertex(0, 1, z);
			t.addVertex(1, 1, z);
			t.addVertex(1, 1, z);
			t.addVertex(1, 0, z);
			t.addVertex(1, 0, z);
			t.addVertex(0, 0, z);
			
			t.addVertex(outer_size, outer_size, z);
			t.addVertex(outer_size, 1-outer_size, z);
			t.addVertex(outer_size, 1-outer_size, z);
			t.addVertex(1-outer_size, 1-outer_size, z);
			t.addVertex(1-outer_size, 1-outer_size, z);
			t.addVertex(1-outer_size, outer_size, z);
			t.addVertex(1-outer_size, outer_size, z);
			t.addVertex(outer_size, outer_size, z);
			
			t.addVertex(0, 0, z);
			t.addVertex(outer_size, outer_size, z);
			t.addVertex(1, 0, z);
			t.addVertex(1-outer_size, outer_size, z);
			t.addVertex(1, 1, z);
			t.addVertex(1-outer_size, 1-outer_size, z);
			t.addVertex(0, 1, z);
			t.addVertex(outer_size, 1-outer_size, z);
			break;
		}
		t.draw();
	}
	
	private static void renderCornerSelector(MovingObjectPosition pos, EntityPlayer ply)
	{
		Tessellator t = Tessellator.instance;
		GL11.glLineWidth(4);
		t.startDrawing(GL11.GL_LINES);
		switch(pos.sideHit)
		{
		case Dir.NX:
		case Dir.PX:
			int x = (pos.sideHit == Dir.NX ? 0 : 1);
			t.addVertex(x, 0, 0);
			t.addVertex(x, 0, 1);
			t.addVertex(x, 0, 1);
			t.addVertex(x, 1, 1);
			t.addVertex(x, 1, 1);
			t.addVertex(x, 1, 0);
			t.addVertex(x, 1, 0);
			t.addVertex(x, 0, 0);
			t.addVertex(x, 0.5, 0);
			t.addVertex(x, 0.5, 1);
			t.addVertex(x, 0, 0.5);
			t.addVertex(x, 1, 0.5);
			break;
		case Dir.NY:
		case Dir.PY:
			int y = (pos.sideHit == Dir.NY ? 0 : 1);
			t.addVertex(0, y, 0);
			t.addVertex(0, y, 1);
			t.addVertex(0, y, 1);
			t.addVertex(1, y, 1);
			t.addVertex(1, y, 1);
			t.addVertex(1, y, 0);
			t.addVertex(1, y, 0);
			t.addVertex(0, y, 0);
			t.addVertex(0.5, y, 0);
			t.addVertex(0.5, y, 1);
			t.addVertex(0, y, 0.5);
			t.addVertex(1, y, 0.5);
			break;
		case Dir.NZ:
		case Dir.PZ:
			int z = (pos.sideHit == Dir.NZ ? 0 : 1);
			t.addVertex(0, 0, z);
			t.addVertex(0, 1, z);
			t.addVertex(0, 1, z);
			t.addVertex(1, 1, z);
			t.addVertex(1, 1, z);
			t.addVertex(1, 0, z);
			t.addVertex(1, 0, z);
			t.addVertex(0, 0, z);
			t.addVertex(0.5, 0, z);
			t.addVertex(0.5, 1, z);
			t.addVertex(0, 0.5, z);
			t.addVertex(1, 0.5, z);
			break;
		}
		t.draw();
	}
	
	private static boolean canPlaceInBlock(World world, int x, int y, int z)
	{
		int blockid = world.getBlockId(x, y, z);
		if(blockid == 0)
			return true;
		if(!(Block.blocksList[blockid] instanceof ICoverableBlock))
			return false;
		TileEntity te = world.getBlockTileEntity(x, y, z);
		return te instanceof ICoverableTile;
	}

}
