package immibis.core.porting;

/* $if mc == 1.4.2$ */

import java.io.File;

import cpw.mods.fml.common.registry.LanguageRegistry;

import net.minecraft.client.Minecraft;
import net.minecraft.src.*;
import net.minecraftforge.common.DimensionManager;
import immibis.core.api.porting.IClientPacketHandler;
import immibis.core.api.porting.IServerPacketHandler;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.api.porting.SidedProxy;

public abstract class CommonProxy142 extends SidedProxy {
	@Override
	public boolean isWorldCurrent(World w) {
		return DimensionManager.getWorld(w.provider.dimensionId) == w;
	}
	
	@Override
	public void addLocalization(String key, String value) {
		LanguageRegistry.instance().addStringLocalization(key, value);
	}
	
	@Override
	public void sendChat(String msg, EntityPlayer player) {
		player.addChatMessage(msg);
	}
	
	@Override
	public Vec3 createVector(IBlockAccess world, double x, double y, double z) {
		return world.func_82732_R().getVecFromPool(x, y, z);
	}
}

/* $endif$ */