package immibis.core.covers;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public abstract class ItemCoverableBase extends Item {

	protected ItemCoverableBase(int id) {
		super(id);
	}
	
	protected boolean mergeIntoMultipartBlock(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, int blockID)
	{
		TileEntity te = world.getBlockTileEntity(i, j, k);
		if(te == null || !(te instanceof TileMultipart))
			return false;
		TileMultipart tm = (TileMultipart)te;
		CoverImpl cover = tm.getCoverImpl();
		if(!world.setBlockWithNotify(i, j, k, blockID))
			return false;
		TileCoverableBase tcb = (TileCoverableBase)world.getBlockTileEntity(i, j, k);
		for(Part p : cover.parts)
			tcb.cover.parts.add(p);
		Block b = Block.blocksList[blockID];
		
		/* $if mc < 1.3$
		// no 1.3 equivalent?
		b.onBlockPlaced(world, i, j, k, l);
		$endif$ */
		
        b.onBlockPlacedBy(world, i, j, k, entityplayer);
		return true;
	}

}
