package immibis.core.net;

import immibis.core.mod_ImmibisCore;
import immibis.core.api.porting.PortableContainer;

import java.util.List;
import net.minecraft.src.*;

public abstract class AbstractSyncedContainer extends PortableContainer implements ISyncedContainer {
	public AbstractSyncedContainer(EntityPlayer player, IInventory inv) {
		super(player, inv);
	}

	/** Sends the packet to all players listening to this inventory.
	 * Use this to update the info displayed in the GUI, for example.
	 * They may be sent from the server to the client.
	 * 
	 * Calling this on the client has no effect in SSP, and throws
	 * an exception in SMP. It does NOT send the packet from the
	 * client to itself, on the rationale that the container should
	 * already know the information being sent.
	 */
	public void sendUpdatePacket(IPacket packet) {
		/* $if !joined$
			$if client2$
				if(!ModLoader.getMinecraftInstance().theWorld.isRemote)
					return;
				if(true)
					throw new IllegalStateException("Cannot send update packets from the client");
			$endif$
		$else$
			if(player.worldObj.isRemote)
				throw new IllegalStateException("Cannot send update packets from the client");
		$endif$ */
		//System.out.println("send update packet "+packet);
		String channel = getChannel();
		for(ICrafting ic : (List<ICrafting>)crafters)
			if(ic instanceof EntityPlayer)
				OneTwoFiveNetworking.send(channel, packet, (EntityPlayer)ic);
	}
	
	/** Sends the packet to the server. Throws an exception if run on the server.
	 * They may be sent from the client to the server, or the client
	 * to itself in SSP.
	 */
	public void sendActionPacket(IPacket packet) {
		sendActionPacket(packet, getChannel());
	}
	
	public void sendActionPacket(IPacket packet, String channel) {
		/* $if joined$ */
		if(!player.worldObj.isRemote)
			throw new IllegalStateException("Cannot send action packets from the server");
		/* $elseif server2$
		if(true)
			throw new IllegalStateException("Cannot send action packets from the server");
		$else$
		if(!player.worldObj.isRemote) {
			// SSP
			onActionPacket(packet);
			return;
		}
		$endif$ */
		//System.out.println("send action packet "+packet);
		OneTwoFiveNetworking.send(channel, packet, null);
	}
	
	/** Must return the channel to send container packets on. */
	public abstract String getChannel();
	
	/** Called when an action packet is received. */
	public void onActionPacket(IPacket p) {}
	/** Called when an update packet is received. */
	public void onUpdatePacket(IPacket p) {}
	
	/** Called when a button-press packet is received.
	 * It's like an action packet that carries a single int,
	 * for convenience (you don't have to make a packet
	 * class to wrap just one int)
	 */
	public void onButtonPressed(int id) {}
	
	/** Sends a button-press packet. */
	public void sendButtonPressed(int id) {
		sendActionPacket(new PacketButtonPress(id), mod_ImmibisCore.CHANNEL_GUI);
	}
	
	private void onActionPacket2(IPacket p) {
		if(p instanceof PacketButtonPress)
			onButtonPressed(((PacketButtonPress)p).buttonID);
		else
			onActionPacket(p);
	}
	
	public final void onReceivePacket(IPacket p) {
		/* $if joined$ */
		//System.out.println("receive "+(player.worldObj.isRemote?"update":"action")+" packet "+p);
		if(!player.worldObj.isRemote)
			onActionPacket2(p);
		else
			onUpdatePacket(p);
		/* $elseif server2$
		onActionPacket2(p);
		$else$
		onUpdatePacket(p);
		$endif$ */
	}
}
